/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.weight;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.superscary.heavyinventories.api.format.Format;
import net.superscary.heavyinventories.api.resource.IResourceList;
import net.superscary.heavyinventories.api.weight.WeightCache;
import net.superscary.heavyinventories.api.weight.WeightOverride;

public final class CalculateWeight {
    private static final ConcurrentHashMap<ItemLike, Float> RECURSIVE_CACHE = new ConcurrentHashMap();

    private CalculateWeight() {
    }

    public static float from(ItemLike itemLike, Level level) {
        return CalculateWeight.from(itemLike, level, new HashSet<ItemLike>(), 0);
    }

    private static float from(ItemLike itemLike, Level level, Set<ItemLike> visited, int depth) {
        if (depth > 10) {
            return CalculateWeight.from(new ItemStack(itemLike));
        }
        if (visited.contains(itemLike)) {
            return CalculateWeight.from(new ItemStack(itemLike));
        }
        Float cachedWeight = RECURSIVE_CACHE.get(itemLike);
        if (cachedWeight != null) {
            return Format.format(cachedWeight.floatValue());
        }
        float weight = CalculateWeight.calculateRecursiveWeight(itemLike, level, visited, depth);
        if (weight == 0.0f) {
            weight = 0.1f;
        }
        RECURSIVE_CACHE.put(itemLike, Float.valueOf(weight));
        return Format.format(weight);
    }

    private static float calculateRecursiveWeight(ItemLike itemLike, Level level, Set<ItemLike> visited, int depth) {
        visited.add(itemLike);
        float weight = 0.0f;
        IResourceList resources = IResourceList.getResourceList(itemLike, level);
        if (!resources.getResources().isEmpty()) {
            HashMap<ItemLike, Integer> firstRecipe = resources.getResources().iterator().next();
            for (Map.Entry<ItemLike, Integer> entry : firstRecipe.entrySet()) {
                ItemLike ingredient = entry.getKey();
                int amount = entry.getValue();
                float ingredientWeight = CalculateWeight.from(ingredient, level, visited, depth + 1);
                weight += ingredientWeight * (float)amount;
            }
        } else {
            weight = CalculateWeight.from(new ItemStack(itemLike));
        }
        visited.remove(itemLike);
        return weight;
    }

    public static float from(Fluid fluid, int millibuckets, Level level) {
        return 0.0f;
    }

    public static float from(Container inventory, Level level) {
        float weight = 0.0f;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            weight += CalculateWeight.from(inventory.getItem(i));
        }
        return Format.format(weight);
    }

    public static float from(Player player) {
        float weight = 0.0f;
        Inventory inventory = player.getInventory();
        weight += (float)inventory.items.stream().mapToDouble(CalculateWeight::from).sum();
        weight += (float)inventory.armor.stream().mapToDouble(CalculateWeight::from).sum();
        return Format.format(weight += (float)inventory.offhand.stream().mapToDouble(CalculateWeight::from).sum());
    }

    public static float from(ItemStack itemStack) {
        return CalculateWeight.from(itemStack, itemStack.getCount());
    }

    private static float from(ItemStack itemStack, int count) {
        return Format.format(WeightCache.get(itemStack.getItem(), () -> WeightOverride.get((ItemLike)itemStack.getItem())) * (float)count);
    }

    public static void clearRecursiveCache() {
        RECURSIVE_CACHE.clear();
    }
}

