/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.weight;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import net.minecraft.world.item.Item;

public final class WeightCache {
    private static final ConcurrentHashMap<Item, Float> PER_ITEM = new ConcurrentHashMap();

    private WeightCache() {
    }

    public static float get(Item item, DoubleSupplier compute) {
        return PER_ITEM.computeIfAbsent(item, k -> Float.valueOf((float)compute.getAsDouble())).floatValue();
    }

    public static void put(Item item, float weight) {
        PER_ITEM.put(item, Float.valueOf(weight));
    }

    public static void invalidate(Item item) {
        PER_ITEM.remove(item);
    }

    public static void clearAll() {
        PER_ITEM.clear();
    }
}

