/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.api.weight;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.superscary.heavyinventories.api.files.DataType;
import net.superscary.heavyinventories.api.files.ReadFile;
import net.superscary.heavyinventories.api.files.WriteFile;
import net.superscary.heavyinventories.api.weight.CalculateWeight;

public final class WeightOverride {
    private WeightOverride() {
    }

    public static float get(ItemLike itemLike) {
        return WeightOverride.get(new ItemStack(itemLike, 1));
    }

    public static float get(ItemStack itemStack) {
        return ReadFile.get((ItemLike)itemStack.getItem(), DataType.WEIGHT) * (float)itemStack.getCount();
    }

    public static void put(ItemLike itemLike, float weight) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem());
        WriteFile.writeToFile(Minecraft.getInstance().gameDirectory.getPath() + "/weights/" + id.getNamespace() + ".json", id.getPath(), DataType.WEIGHT, weight);
    }

    public static void putDumpFile(List<Item> items, List<Block> blocks, Level level) {
        for (Item item : items) {
            WeightOverride.put((ItemLike)item, CalculateWeight.from((ItemLike)item, level));
        }
        for (Block block : blocks) {
            WeightOverride.put((ItemLike)block, CalculateWeight.from((ItemLike)block, level));
        }
    }
}

