/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.superscary.heavyinventories.HeavyInventories;
import net.superscary.heavyinventories.api.player.PlayerWeightCache;
import net.superscary.heavyinventories.api.weight.CalculateWeight;
import net.superscary.heavyinventories.api.weight.WeightCache;
import net.superscary.heavyinventories.api.weight.WeightOverride;
import net.superscary.heavyinventories.helper.RegistryHelper;
import net.superscary.heavyinventories.platform.Services;

public class ModCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heavyinventories").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"weight").then(RequiredArgumentBuilder.argument((String)"weight_argument", (ArgumentType)FloatArgumentType.floatArg()).executes(ModCommands::executeSetWeightCommand)))).then(Commands.literal((String)"density").then(RequiredArgumentBuilder.argument((String)"density_argument", (ArgumentType)FloatArgumentType.floatArg()).executes(ModCommands::executeSetDensityCommand)))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").then(Commands.literal((String)"weight").executes(context -> {
            WeightCache.clearAll();
            return 1;
        }))).then(Commands.literal((String)"players").executes(context -> {
            PlayerWeightCache.clearAll();
            return 1;
        }))))).then(Commands.literal((String)"reload").executes(ModCommands::executeReloadCommand))).then(Commands.literal((String)"dump").then(RequiredArgumentBuilder.argument((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ModidSuggestionProvider()).executes(ModCommands::executeDumpCommand))));
    }

    protected static int executeSetWeightCommand(CommandContext<CommandSourceStack> context) {
        float number = FloatArgumentType.getFloat(context, (String)"weight_argument");
        if (((CommandSourceStack)context.getSource()).getPlayer() == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"chat.heavyinventories.command_set.failure", (Object[])new Object[]{Float.valueOf(number)}));
            return 1;
        }
        ItemStack stack = ((CommandSourceStack)context.getSource()).getPlayer().getItemInHand(((CommandSourceStack)context.getSource()).getPlayer().getUsedItemHand());
        WeightOverride.put((ItemLike)stack.getItem(), number);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"chat.heavyinventories.command_set.success", (Object[])new Object[]{Float.valueOf(number)}), true);
        return 1;
    }

    protected static int executeSetDensityCommand(CommandContext<CommandSourceStack> context) {
        float number = FloatArgumentType.getFloat(context, (String)"density_argument");
        if (((CommandSourceStack)context.getSource()).getPlayer() == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"chat.heavyinventories.command_set.failure", (Object[])new Object[]{Float.valueOf(number)}));
            return 1;
        }
        ItemStack stack = ((CommandSourceStack)context.getSource()).getPlayer().getItemInHand(((CommandSourceStack)context.getSource()).getPlayer().getUsedItemHand());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"chat.heavyinventories.command_set.success", (Object[])new Object[]{Float.valueOf(number)}), true);
        return 1;
    }

    protected static int executeReloadCommand(CommandContext<CommandSourceStack> context) {
        WeightCache.clearAll();
        PlayerWeightCache.clearAll();
        CalculateWeight.clearRecursiveCache();
        return 1;
    }

    protected static int executeDumpCommand(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)"modid");
        if (!Services.PLATFORM.isModLoaded(modid)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(modid + " is invalid or not loaded!")));
            return 1;
        }
        List<Item> items = RegistryHelper.getItemsFor(modid);
        List<Block> blocks = RegistryHelper.getBlocksFor(modid);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Dumping " + modid + "...")));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Found " + items.size() + " items and " + blocks.size() + " blocks.")));
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        WeightOverride.putDumpFile(items, blocks, (Level)level);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Done!"), true);
        return 1;
    }

    private static class ModidSuggestionProvider
    implements SuggestionProvider<CommandSourceStack> {
        private ModidSuggestionProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
            for (String modid : HeavyInventories.getInstance().getModIds()) {
                if (modid.equals(Services.PLATFORM.getPlatformName().toLowerCase()) || RegistryHelper.getItemsFor(modid).isEmpty() || RegistryHelper.getBlocksFor(modid).isEmpty()) continue;
                builder.suggest(modid);
            }
            return builder.buildFuture();
        }
    }
}

