/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityFallDamageMixin {
    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private float heavyinventories$scaleFallDamage(float damageMultiplier) {
        LivingEntity self = (LivingEntity)this;
        if (self.level().isClientSide()) {
            return damageMultiplier;
        }
        if (!(self instanceof Player)) {
            return damageMultiplier;
        }
        Player player = (Player)self;
        PlayerHolder holder = PlayerHolder.getOrCreate(player);
        if (holder.isOverEncumbered()) {
            return damageMultiplier * 3.0f;
        }
        if (holder.isEncumbered()) {
            return damageMultiplier * 1.5f;
        }
        return damageMultiplier;
    }
}

