/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityFluidGravityMixin {
    @ModifyVariable(method={"getFluidFallingAdjustedMovement"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private double heavyinventories$scaleFluidGravity(double gravity) {
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof Player)) {
            return gravity;
        }
        Player player = (Player)self;
        if (!self.isInWaterOrBubble() && !self.isInLava()) {
            return gravity;
        }
        float mult = PlayerHolder.getOrCreate(player).getFluidSinkGravityMultiplier();
        return gravity * (double)mult;
    }
}

