/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.mixin;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import net.superscary.heavyinventories.api.util.Functions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class LivingEntityJumpFromGroundMixin {
    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    private void heavyinventories$preventJump(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof Player)) {
            return;
        }
        Player player = (Player)self;
        PlayerHolder holder = PlayerHolder.getOrCreate(player);
        if (holder.isEncumbered() || holder.isOverEncumbered()) {
            player.sendSystemMessage((Component)Component.translatable((String)"chat.heavyinventories.no_jump", (Object[])new Object[]{Component.translatable((String)Functions.either("chat.heavyinventories.over_encumbered", "chat.heavyinventories.encumbered", holder.isOverEncumbered()))}));
            ci.cancel();
        }
    }
}

