/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.neoforge.core;

import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModInfo;
import net.superscary.heavyinventories.CommonClass;
import net.superscary.heavyinventories.ModBase;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import net.superscary.heavyinventories.neoforge.config.ServerConfig;
import net.superscary.heavyinventories.neoforge.enchantments.ModEnchantmentEffects;
import net.superscary.heavyinventories.neoforge.hooks.ModHooks;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyInventoriesNeoForgeBase
extends ModBase {
    public HeavyInventoriesNeoForgeBase(ModContainer modContainer, IEventBus modEventBus) {
        CommonClass.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ServerConfig.SPEC);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayer);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerClone);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerChangedDimension);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerPickupItem);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookOnCraft);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookOnSmelt);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerMove);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerEquip);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookPlayerLogout);
        NeoForge.EVENT_BUS.addListener(ModHooks::hookCommands);
        modEventBus.addListener(HeavyInventoriesNeoForgeBase::postInitialization);
        ModEnchantmentEffects.register(modEventBus);
    }

    private static void postInitialization(FMLLoadCompleteEvent event) {
        PlayerHolder.setWeightStarting(((Double)ServerConfig.STARTING_WEIGHT.get()).floatValue());
    }

    @Override
    @Nullable
    public MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public List<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }
}

