/*
 * Decompiled with CFR 0.152.
 */
package net.superscary.heavyinventories.neoforge.hooks;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.superscary.heavyinventories.api.events.PlayerEvents;
import net.superscary.heavyinventories.api.player.PlayerHolder;
import net.superscary.heavyinventories.command.ModCommands;
import net.superscary.heavyinventories.neoforge.config.ClientConfig;
import net.superscary.heavyinventories.tooltips.Tooltip;

public class ModHooks {
    public static void hookTooltip(ItemTooltipEvent event) {
        Tooltip.addTooltips(event.getToolTip(), event.getItemStack());
    }

    public static void hookPlayer(PlayerTickEvent.Pre event) {
        PlayerEvents.onPlayerTick(event.getEntity());
    }

    public static void hookPlayerClone(PlayerEvent.Clone event) {
        PlayerEvents.clone(event.getOriginal(), event.getEntity());
    }

    public static void hookPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEvents.playerChangedDimension(event.getEntity());
    }

    public static void hookPlayerPickupItem(ItemEntityPickupEvent.Post event) {
        PlayerEvents.onPickupItem(event.getPlayer());
    }

    public static void hookOnCraft(PlayerEvent.ItemCraftedEvent event) {
        PlayerEvents.onCraft(event.getEntity());
    }

    public static void hookOnSmelt(PlayerEvent.ItemSmeltedEvent event) {
        PlayerEvents.onSmelt(event.getEntity());
    }

    public static void hookPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEvents.logout(event.getEntity());
    }

    public static void hookPlayerMove(MovementInputUpdateEvent event) {
        PlayerHolder holder = PlayerHolder.getOrCreate(event.getEntity());
        if (event.getEntity().isCreative()) {
            return;
        }
        if (!holder.isEncumbered() && !holder.isOverEncumbered()) {
            return;
        }
        Input input = event.getInput();
        float mult = holder.getSureFootedMult();
        if (mult == 1.0f) {
            if (holder.isOverEncumbered()) {
                mult = 0.0f;
            } else if (holder.isEncumbered()) {
                mult = 0.25f;
            }
        }
        input.forwardImpulse *= mult;
        input.leftImpulse *= mult;
    }

    public static void hookPlayerEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!event.getSlot().isArmor()) {
            return;
        }
        PlayerEvents.onUnequipItem(player);
    }

    public static void hookCommands(RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void hookGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.isCreative() || mc.options.hideGui || mc.screen != null) {
            return;
        }
        GuiGraphics g = event.getGuiGraphics();
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        int margin = 4;
        Objects.requireNonNull(mc.font);
        int lineH = 9;
        PlayerHolder holder = PlayerHolder.getOrCreate((Player)mc.player);
        float cur = holder.getWeight();
        float max = holder.getMaxWeight();
        float pct = holder.getEncumberedPercentage();
        String main = String.format("%.1f/%.1f %s (%.1f%%)", Float.valueOf(cur), Float.valueOf(max), ClientConfig.WEIGHT_MEASURE.get(), Float.valueOf(pct));
        MutableComponent statusComp = null;
        int statusColor = 0xFFFFFF;
        if (holder.isOverEncumbered()) {
            statusComp = Component.translatable((String)"chat.heavyinventories.over_encumbered");
            statusColor = 0xFF5555;
        } else if (holder.isEncumbered()) {
            statusComp = Component.translatable((String)"chat.heavyinventories.encumbered");
            statusColor = 0xFFFF55;
        }
        int mainW = mc.font.width(main);
        int statusW = statusComp == null ? 0 : mc.font.width((FormattedText)statusComp);
        int totalLines = statusComp == null ? 1 : 2;
        int blockH = totalLines * lineH;
        int yTop = sh - blockH - margin;
        if (statusComp != null) {
            int xStatus = sw - statusW - margin;
            g.drawString(mc.font, (Component)statusComp, xStatus, yTop, statusColor, true);
            yTop += lineH;
        }
        int mainColor = pct >= 100.0f ? 0xFF5555 : (pct >= 90.0f ? 0xFFAA00 : (pct >= 75.0f ? 0xFFFF55 : 0xFFFFFF));
        int xMain = sw - mainW - margin;
        g.drawString(mc.font, main, xMain, yTop, mainColor, true);
    }
}

