#> invisibleplayername:image/set_image_data
#
# This function sets the image data.
#
# @input $(image_data) {string[][]} The data to set  
# @input $(width) {number} The width of the image  
# @input $(height) {number} The height of the image  
# @input $(background_color) {string} The background color of the image  
# @input $(description) {string[]} The description on the right hand side  
# @writes storage invisibleplayername:image image_data  
# @writes storage invisibleplayername:image width  
# @writes storage invisibleplayername:image height  
# @writes storage invisibleplayername:image background_color  
# @writes storage invisibleplayername:image description  
# @writes storage invisibleplayername:image pixel_character.blank  
# @writes storage invisibleplayername:image pixel_character.chat  
# @writes storage invisibleplayername:image pixel_character.lore

data remove storage invisibleplayername:image image_data
data remove storage invisibleplayername:image width
data remove storage invisibleplayername:image height
data remove storage invisibleplayername:image background_color
data remove storage invisibleplayername:image description

$data modify storage invisibleplayername:image image_data set value $(image_data)
$data modify storage invisibleplayername:image width set value $(width)
$data modify storage invisibleplayername:image height set value $(height)
$data modify storage invisibleplayername:image background_color set value "$(background_color)"
$data modify storage invisibleplayername:image description set value $(description)

data modify storage invisibleplayername:image pixel_character.blank set value "　"
data modify storage invisibleplayername:image pixel_character.pixel set value "▌▌"
data modify storage invisibleplayername:image pixel_character.line_break set value '\n'

function invisibleplayername:image/process/generate
