package com.smeaves.falling_apples;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ItemEntity;
import net.minecraft.item.Items;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.random.Random;

public class FallingApples implements ModInitializer {
    private static final int APPLE_DROP_CHANCE = 40;
    private static final int SAMPLE_ATTEMPTS_PER_TICK = 200;
    private static final int RADIUS = 16;

    @Override
    public void onInitialize() {
        ServerTickEvents.END_WORLD_TICK.register(this::onWorldTick);
    }

    private void onWorldTick(ServerWorld world) {
        Random random = world.random;

        for (ServerPlayerEntity player : world.getPlayers()) {
            BlockPos playerPos = player.getBlockPos();

            for (int i = 0; i < SAMPLE_ATTEMPTS_PER_TICK; i++) {
                int x = playerPos.getX() + random.nextBetween(-RADIUS, RADIUS);
                int z = playerPos.getZ() + random.nextBetween(-RADIUS, RADIUS);
                int y = world.getBottomY() + random.nextInt(world.getHeight());

                BlockPos pos = new BlockPos(x, y, z);

                if (world.getBlockState(pos).isOf(Blocks.OAK_LEAVES) || world.getBlockState(pos).isOf(Blocks.DARK_OAK_LEAVES)) {
                    if (random.nextInt(APPLE_DROP_CHANCE) == 0) {
                        BlockPos below = pos.down();
                        if (world.isAir(below)) {
                            ItemEntity apple = new ItemEntity(
                                    world,
                                    below.getX() + 0.5,
                                    below.getY() + 0.5,
                                    below.getZ() + 0.5,
                                    Items.APPLE.getDefaultStack()
                            );
                            world.spawnEntity(apple);
                        }
                    }
                }
            }
        }
    }
}
