/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.meticulous.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.sssubtlety.meticulous.Meticulous;
import net.sssubtlety.meticulous.Util;
import net.sssubtlety.meticulous.config.ClothConfig;
import net.sssubtlety.meticulous.config.Config;
import net.sssubtlety.meticulous.config.DefaultConfig;
import org.jetbrains.annotations.Nullable;

public final class ConfigManager {
    public static final int MIN_MIN_BREAK_TIME = 0;
    public static final int MAX_MIN_BREAK_TIME = 100;
    public static final class_304.class_11900 KEY_BIND_CATEGORY = class_304.class_11900.method_74698((class_2960)Meticulous.idOf("main"));
    public static final class_304 TOGGLE_KEY = ConfigManager.registerKeyBind("toggle", 77);
    public static final class_304 MODIFIER_KEY = ConfigManager.registerUnboundKeyBind("modifier");
    public static final class_304 ALWAYS_SLOW_MODIFIER_KEY = ConfigManager.registerUnboundKeyBind("always_slow_modifier");
    public static final class_304 ALWAYS_SLOW_BLOCKS_TOGGLE_KEY = ConfigManager.registerUnboundKeyBind("always_slow_blocks_toggle");
    private static final Config CONFIG;
    private static final class_2561 ENABLED;
    private static final class_2561 DISABLED;
    private static final class_2561 ALWAYS_SLOW_BLOCKS;
    private static final ImmutableList<ToolPredicate> TOOL_PREDICATES;
    private static boolean enable;
    private static float maxFirstBlockBreakDelta;
    private static float maxSecondBlockBreakDelta;
    private static float maxAlwaysSlowBlockBreakDelta;
    private static ImmutableSet<class_1792> additionalItems;
    private static ImmutableSet<class_1792> excludedItems;
    private static boolean alwaysSlowBlocksInList;
    private static ImmutableSet<class_2248> alwaysSlowBlocks;

    private ConfigManager() {
    }

    public static void init() {
    }

    private static class_1269 update(Config config) {
        enable = config.enable();
        ValidatedMaxDelta validatedMaxFirstDelta = ValidatedMaxDelta.of(config, Config::minFirstBlockBreakTime);
        maxFirstBlockBreakDelta = validatedMaxFirstDelta.delta;
        ValidatedMaxDelta validatedMaxSecondDelta = ValidatedMaxDelta.of(config, Config::minSecondBlockBreakTime);
        maxSecondBlockBreakDelta = validatedMaxSecondDelta.delta;
        additionalItems = ConfigManager.createItemSet(config.enableForItems().additionalIdStrings());
        excludedItems = ConfigManager.createItemSet(config.enableForItems().excludedIdStrings());
        alwaysSlowBlocksInList = config.alwaysSlowBlocksInList();
        alwaysSlowBlocks = ConfigManager.createBlockSet(config.alwaysSlowBlockIdStrings());
        ValidatedMaxDelta validatedMaxAlwaysSlowDelta = ValidatedMaxDelta.of(config, Config::minAlwaysSlowBlockBreakTime);
        maxAlwaysSlowBlockBreakDelta = validatedMaxAlwaysSlowDelta.delta;
        return validatedMaxFirstDelta.invalidConfig || validatedMaxSecondDelta.invalidConfig || validatedMaxAlwaysSlowDelta.invalidConfig ? class_1269.field_5814 : class_1269.field_5812;
    }

    private static class_304 registerUnboundKeyBind(String translationKeySuffix) {
        return ConfigManager.registerKeyBind(translationKeySuffix, -1);
    }

    private static class_304 registerKeyBind(String translationKeySuffix, int defaultKeyCode) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.meticulous." + translationKeySuffix, defaultKeyCode, KEY_BIND_CATEGORY));
    }

    private static boolean isEnabled() {
        return enable;
    }

    public static boolean shouldNotifyOnToggle() {
        return CONFIG.notifyOnToggle();
    }

    public static float getMaxFirstBlockBreakDelta() {
        return maxFirstBlockBreakDelta;
    }

    public static float getMaxSecondBlockBreakDelta() {
        return maxSecondBlockBreakDelta;
    }

    public static float getMaxAlwaysSlowBlockBreakDelta() {
        return maxAlwaysSlowBlockBreakDelta;
    }

    public static Optional<Float> getAdjustedBlockBreakDelta(float originalDelta, Util.SlowBreaking slowBreaking, class_2248 block) {
        return ConfigManager.getMaxBlockBreakingDelta(slowBreaking, block).filter(maxBlockBreakingDelta -> maxBlockBreakingDelta.floatValue() < originalDelta);
    }

    public static boolean blockIsAlwaysSlow(class_2248 block) {
        return alwaysSlowBlocksInList && alwaysSlowBlocks.contains((Object)block);
    }

    private static Optional<Float> getMaxBlockBreakingDelta(Util.SlowBreaking slowBreaking, class_2248 block) {
        if (ConfigManager.blockIsAlwaysSlow(block)) {
            return Optional.of(Float.valueOf(maxAlwaysSlowBlockBreakDelta));
        }
        return Optional.ofNullable(switch (slowBreaking) {
            default -> throw new IncompatibleClassChangeError();
            case Util.SlowBreaking.FIRST -> Float.valueOf(maxFirstBlockBreakDelta);
            case Util.SlowBreaking.SECOND -> Float.valueOf(maxSecondBlockBreakDelta);
            case Util.SlowBreaking.ALL -> Float.valueOf(maxAlwaysSlowBlockBreakDelta);
            case Util.SlowBreaking.NONE -> null;
        });
    }

    public static boolean shouldExcludeHardness0() {
        return CONFIG.excludeHardness0();
    }

    private static boolean isAllowed(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (excludedItems.contains((Object)item)) {
            return false;
        }
        if (additionalItems.contains((Object)item)) {
            return true;
        }
        return TOOL_PREDICATES.stream().noneMatch(predicate -> predicate.denies(stack, CONFIG.enableForItems()));
    }

    private static <T> ImmutableSet<T> createRegistryEntrySet(Collection<String> ids, class_2378<T> registry) {
        return (ImmutableSet)ids.stream().flatMap(string -> {
            Optional<class_2960> id = Optional.ofNullable(class_2960.method_12829((String)string));
            if (id.isEmpty()) {
                Meticulous.LOGGER.error("Invalid identifier: {}", string);
            }
            return id.stream();
        }).flatMap(id -> {
            Optional entry = registry.method_17966(id);
            if (entry.isEmpty()) {
                Meticulous.LOGGER.error("No \"{}\" with id: {}", (Object)registry.method_46765().method_29177(), id);
            }
            return entry.stream();
        }).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<class_1792> createItemSet(Collection<String> ids) {
        return ConfigManager.createRegistryEntrySet(ids, class_7923.field_41178);
    }

    public static ImmutableSet<class_2248> createBlockSet(Collection<String> ids) {
        return ConfigManager.createRegistryEntrySet(ids, class_7923.field_41175);
    }

    public static Function<class_437, ? extends class_437> getScreenFactory() {
        return CONFIG.screenFactory();
    }

    public static boolean shouldSlowFirstBlocks(class_746 player) {
        return ConfigManager.isEnabled() != MODIFIER_KEY.method_1434() && ConfigManager.isAllowed(player.method_6047());
    }

    public static Util.SlowBreaking getSlowBreaking(int brokenBlockCount, class_2338 pos, class_746 player, class_638 world, class_2680 state) {
        if (ALWAYS_SLOW_MODIFIER_KEY.method_1434()) {
            return ConfigManager.getMaxAlwaysSlowBlockBreakDelta() > 0.0f && ConfigManager.shouldAffectStateAt(state, pos, world) ? Util.SlowBreaking.ALL : Util.SlowBreaking.NONE;
        }
        if (ConfigManager.blockIsAlwaysSlow(state.method_26204())) {
            return ConfigManager.getMaxAlwaysSlowBlockBreakDelta() > 0.0f ? Util.SlowBreaking.ALL : Util.SlowBreaking.NONE;
        }
        if (ConfigManager.shouldSlowFirstBlocks(player)) {
            if (brokenBlockCount == 0) {
                return ConfigManager.getMaxFirstBlockBreakDelta() > 0.0f && ConfigManager.shouldAffectStateAt(state, pos, world) ? Util.SlowBreaking.FIRST : Util.SlowBreaking.NONE;
            }
            if (brokenBlockCount == 1) {
                return ConfigManager.getMaxSecondBlockBreakDelta() > 0.0f && ConfigManager.shouldAffectStateAt(state, pos, world) ? Util.SlowBreaking.SECOND : Util.SlowBreaking.NONE;
            }
            return Util.SlowBreaking.NONE;
        }
        return Util.SlowBreaking.NONE;
    }

    private static boolean shouldAffectStateAt(class_2680 state, class_2338 pos, class_638 world) {
        return !ConfigManager.shouldExcludeHardness0() || state.method_26214((class_1922)world, pos) > 0.0f;
    }

    private static void onEndClientTick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        boolean dirtyEnable = ConfigManager.tryToggle(TOGGLE_KEY, Meticulous.NAME, () -> {
            enable = !enable;
            return enable;
        }, CONFIG::setEnable, client.field_1724);
        boolean dirtyListEnable = ConfigManager.tryToggle(ALWAYS_SLOW_BLOCKS_TOGGLE_KEY, ALWAYS_SLOW_BLOCKS, () -> {
            alwaysSlowBlocksInList = !alwaysSlowBlocksInList;
            return alwaysSlowBlocksInList;
        }, CONFIG::setAlwaysSlowBlocksInList, client.field_1724);
        if (dirtyEnable || dirtyListEnable) {
            CONFIG.save();
        }
    }

    private static boolean tryToggle(class_304 toggleKey, class_2561 messagePrefix, BooleanSupplier toggler, BooleanConsumer setter, @Nullable class_746 player) {
        if (toggleKey.method_1436()) {
            boolean value = toggler.getAsBoolean();
            if (ConfigManager.shouldNotifyOnToggle() && player != null) {
                player.method_7353((class_2561)messagePrefix.method_27661().method_27693(": ").method_10852(value ? ENABLED : DISABLED), true);
            }
            setter.accept(value);
            return true;
        }
        return false;
    }

    static {
        ENABLED = class_2561.method_43471((String)"message.meticulous.enabled");
        DISABLED = class_2561.method_43471((String)"message.meticulous.disabled");
        ALWAYS_SLOW_BLOCKS = class_2561.method_43471((String)"message.meticulous.always_slow_blocks");
        TOOL_PREDICATES = ImmutableList.of((Object)new ToolPredicate(Config.EnableForItems::axes, (class_6862<class_1792>)class_3489.field_42612), (Object)new ToolPredicate(Config.EnableForItems::hoes, (class_6862<class_1792>)class_3489.field_42613), (Object)new ToolPredicate(Config.EnableForItems::pickaxes, (class_6862<class_1792>)class_3489.field_42614), (Object)new ToolPredicate(Config.EnableForItems::shears, (class_6862<class_1792>)ConventionalItemTags.SHEAR_TOOLS), (Object)new ToolPredicate(Config.EnableForItems::shovels, (class_6862<class_1792>)class_3489.field_42615), (Object)new ToolPredicate(Config.EnableForItems::swords, (class_6862<class_1792>)class_3489.field_42611));
        CONFIG = Util.isModLoaded("cloth-config", ">=7.0.72") ? ClothConfig.register(ConfigManager::update) : DefaultConfig.INSTANCE;
        ConfigManager.update(CONFIG);
        ClientTickEvents.END_CLIENT_TICK.register(ConfigManager::onEndClientTick);
    }

    private record ValidatedMaxDelta(float delta, boolean invalidConfig) {
        public static ValidatedMaxDelta of(Config config, Function<Config, Integer> minBreakTimeGetter) {
            int configuredMinBreakTime = minBreakTimeGetter.apply(config);
            boolean validConfig = ValidatedMaxDelta.isValidMinBreakTime(configuredMinBreakTime);
            int minBreakTime = validConfig ? configuredMinBreakTime : minBreakTimeGetter.apply(DefaultConfig.INSTANCE);
            return new ValidatedMaxDelta(ValidatedMaxDelta.ticksToDelta(minBreakTime), !validConfig);
        }

        private static float ticksToDelta(int ticks) {
            return ticks > 0 ? 1.0f / (float)ticks : -1.0f;
        }

        private static boolean isValidMinBreakTime(int breakTime) {
            return breakTime == class_3532.method_15340((int)breakTime, (int)0, (int)100);
        }
    }

    private record ToolPredicate(Predicate<Config.EnableForItems> isToolEnabled, class_6862<class_1792> tag) {
        boolean denies(class_1799 stack, Config.EnableForItems enableForItems) {
            return !this.isToolEnabled.test(enableForItems) && stack.method_31573(this.tag);
        }
    }
}

