/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import cy.jdkdigital.tfcgroomer.common.block.GroomingStation;
import cy.jdkdigital.tfcgroomer.common.block.entity.GroomingStationBlockEntity;
import cy.jdkdigital.tfcgroomer.common.item.GroomingStationItem;
import cy.jdkdigital.tfcgroomer.config.GroomerConfig;
import cy.jdkdigital.tfcgroomer.inventory.GroomingStationContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="tfcgroomer")
public class Groomer {
    public static final String MODID = "tfcgroomer";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tfcgroomer");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tfcgroomer");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tfcgroomer");
    public static final DeferredRegister<MenuType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tfcgroomer");
    public static final RegistryObject<BlockEntityType<GroomingStationBlockEntity>> GROOMING_STATION_BLOCK_ENTITY;
    public static final List<RegistryObject<GroomingStation>> GROOMING_STATIONS;
    public static final List<RegistryObject<GroomingStationItem>> GROOMING_STATION_ITEMS;
    public static final RegistryObject<MenuType<GroomingStationContainer>> GROOMING_STATION_MENU;

    public Groomer() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        GroomerConfig.init();
        modEventBus.addListener(this::addCreative);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            GROOMING_STATION_ITEMS.forEach(item -> event.m_246326_((ItemLike)item.get()));
        }
    }

    private static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> RegistryObject<MenuType<C>> registerBlock(String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return RegistrationHelpers.registerBlockEntityContainer(CONTAINER_TYPES, (String)name, type, factory);
    }

    static {
        GROOMING_STATIONS = new ArrayList<RegistryObject<GroomingStation>>();
        GROOMING_STATION_ITEMS = new ArrayList<RegistryObject<GroomingStationItem>>();
        GROOMING_STATION_BLOCK_ENTITY = BLOCK_ENTITY.register("grooming_station", () -> new BlockEntityType.Builder(GroomingStationBlockEntity::new, (Set)ImmutableSet.copyOf(GROOMING_STATIONS.stream().map(RegistryObject::get).toList())).m_58966_(null));
        Arrays.stream(Metal.Default.values()).filter(Metal.Default::hasUtilities).forEach(metal -> {
            RegistryObject GROOMING_STATION = BLOCKS.register(metal.m_7912_() + "_grooming_station", () -> new GroomingStation(ExtendedProperties.of((MapColor)metal.mapColor()).sound(SoundType.f_56743_).instrument(NoteBlockInstrument.BANJO).noOcclusion().strength(10.0f, 10.0f).requiresCorrectToolForDrops().blockEntity(GROOMING_STATION_BLOCK_ENTITY).ticks((level, pos, state, gstation) -> GroomingStationBlockEntity.tickServer(level, pos, gstation)), (Metal.Default)metal));
            RegistryObject GROOMING_STATION_ITEM = ITEMS.register(metal.m_7912_() + "_grooming_station", () -> new GroomingStationItem((Block)GROOMING_STATION.get(), new Item.Properties()));
            GROOMING_STATIONS.add((RegistryObject<GroomingStation>)GROOMING_STATION);
            GROOMING_STATION_ITEMS.add((RegistryObject<GroomingStationItem>)GROOMING_STATION_ITEM);
        });
        GROOMING_STATION_MENU = Groomer.registerBlock("grooming_station", GROOMING_STATION_BLOCK_ENTITY, GroomingStationContainer::create);
    }
}

