/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer.common.block;

import cy.jdkdigital.tfcgroomer.Groomer;
import cy.jdkdigital.tfcgroomer.common.block.entity.GroomingStationBlockEntity;
import cy.jdkdigital.tfcgroomer.config.GroomerConfig;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GroomingStation
extends DeviceBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)2);
    public final Metal.Default metal;

    public GroomingStation(ExtendedProperties pProperties, Metal.Default metal) {
        super(pProperties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.metal = metal;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LEVEL});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        level.m_141902_(pos, (BlockEntityType)Groomer.GROOMING_STATION_BLOCK_ENTITY.get()).ifPresent(groomingStation -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen((ServerPlayer)serverPlayer, (MenuProvider)groomingStation, (BlockPos)pos);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState pState) {
        return (Boolean)GroomerConfig.SERVER.groomingStationRedstoneOutput.get();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return level.m_141902_(pos, (BlockEntityType)Groomer.GROOMING_STATION_BLOCK_ENTITY.get()).map(GroomingStationBlockEntity::getAnalogOutputSignal).orElse(0);
    }

    public int getRange() {
        return (Integer)GroomerConfig.SERVER.rangeBlocks.get(this.metal).get();
    }
}

