/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer.common.block.entity;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.tfcgroomer.Groomer;
import cy.jdkdigital.tfcgroomer.common.block.GroomingStation;
import cy.jdkdigital.tfcgroomer.config.GroomerConfig;
import cy.jdkdigital.tfcgroomer.inventory.GroomingStationContainer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IntArrayBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroomingStationBlockEntity
extends TickableInventoryBlockEntity<GroomingStationInventory> {
    private static final Component NAME = Component.m_237115_((String)"block.tfcgroomer.grooming_station");
    static final UUID PLAYER_UUID = UUID.nameUUIDFromBytes("grooming_station".getBytes(StandardCharsets.UTF_8));
    private double range = 1.0;
    int counter;
    protected final ContainerData syncData;
    public boolean breedingEnabled;

    public static void tickServer(Level level, BlockPos pos, GroomingStationBlockEntity groomStation) {
        if (groomStation.counter-- > 0 || !(level instanceof ServerLevel)) {
            return;
        }
        groomStation.counter = (Integer)GroomerConfig.SERVER.groomingStationTicks.get();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < ((GroomingStationInventory)groomStation.inventory).getSlots(); ++i) {
            ItemStack stack = ((GroomingStationInventory)groomStation.inventory).getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        List entities = level.m_45976_(Animal.class, new AABB(pos).m_82377_(groomStation.range, 1.0, groomStation.range)).stream().toList();
        if (entities.isEmpty()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)new GameProfile(PLAYER_UUID, "grooming_station"));
        entities.forEach(arg_0 -> GroomingStationBlockEntity.lambda$tickServer$0(stacks, (Player)fakePlayer, groomStation, arg_0));
    }

    private static void feedAnimalIfConditionsMet(Animal animal, List<ItemStack> currentStacks, Player fakePlayer, boolean breedingEnabled) {
        if (animal instanceof TFCAnimalProperties) {
            TFCAnimalProperties tfcAnimal = (TFCAnimalProperties)animal;
            float animalFamiliarity = tfcAnimal.getFamiliarity();
            boolean isChild = tfcAnimal.getAgeType() == TFCAnimalProperties.Age.CHILD;
            boolean animalHungry = tfcAnimal.isHungry();
            for (ItemStack stack : currentStacks) {
                boolean stackHasItems = !stack.m_41619_();
                boolean stackIsEdible = GroomingStationBlockEntity.isFood(tfcAnimal, stack);
                if (!stackHasItems || !animalHungry || !stackIsEdible) continue;
                if (breedingEnabled) {
                    tfcAnimal.eatFood(stack, InteractionHand.MAIN_HAND, fakePlayer);
                    break;
                }
                if (!(isChild && animalFamiliarity < 1.0f) && !(animalFamiliarity < tfcAnimal.getAdultFamiliarityCap())) continue;
                tfcAnimal.eatFood(stack, InteractionHand.MAIN_HAND, fakePlayer);
                break;
            }
        }
    }

    static boolean isFood(TFCAnimalProperties tfcAnimal, ItemStack stack) {
        return (tfcAnimal.eatsRottenFood() || !FoodCapability.isRotten((ItemStack)stack)) && Helpers.isItem((ItemStack)stack, (TagKey)tfcAnimal.getFoodTag());
    }

    public GroomingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Groomer.GROOMING_STATION_BLOCK_ENTITY.get(), pos, state, GroomingStationInventory::new, NAME);
        Block block;
        this.breedingEnabled = (Boolean)GroomerConfig.SERVER.breedingEnabledByDefault.get();
        this.syncData = new IntArrayBuilder().add(() -> GroomingStationBlockEntity.toInt(this.breedingEnabled), value -> {
            this.breedingEnabled = GroomingStationBlockEntity.toBool(value);
        });
        if (((Boolean)GroomerConfig.SERVER.groomingStationEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3}), d -> d != Direction.DOWN).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), new Direction[]{Direction.DOWN});
        }
        if ((block = state.m_60734_()) instanceof GroomingStation) {
            GroomingStation groomingStation = (GroomingStation)block;
            this.range = groomingStation.getRange();
        }
    }

    public ContainerData getSyncData() {
        return this.syncData;
    }

    public void setBreedingEnabled(boolean b) {
        if (!((Boolean)GroomerConfig.SERVER.enableBreedingToggle.get()).booleanValue()) {
            Groomer.LOGGER.info("Breeding toggling is disabled by server config. How did you even call this?");
            return;
        }
        this.breedingEnabled = b;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInv, @NotNull Player player) {
        return GroomingStationContainer.create(this, playerInv, containerId);
    }

    public void loadAdditional(CompoundTag nbt) {
        this.breedingEnabled = nbt.m_128441_("breedingEnabled") ? nbt.m_128471_("breedingEnabled") : ((Boolean)GroomerConfig.SERVER.breedingEnabledByDefault.get()).booleanValue();
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_("breedingEnabled", this.breedingEnabled);
        super.m_183515_(nbt);
    }

    public int getAnalogOutputSignal() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < ((GroomingStationInventory)this.inventory).getSlots(); ++j) {
            ItemStack itemstack = ((GroomingStationInventory)this.inventory).getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(((GroomingStationInventory)this.inventory).getSlotStackLimit(i), itemstack.m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)((GroomingStationInventory)this.inventory).getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    private static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    private static boolean toBool(int i) {
        return i >= 1;
    }

    private static /* synthetic */ void lambda$tickServer$0(List stacks, Player fakePlayer, GroomingStationBlockEntity groomStation, Animal animal) {
        GroomingStationBlockEntity.feedAnimalIfConditionsMet(animal, stacks, fakePlayer, groomStation.breedingEnabled);
    }

    public static class GroomingStationInventory
    extends InventoryItemHandler
    implements INBTSerializable<CompoundTag> {
        private static final TagKey<Item> SEEDS = ItemTags.create((ResourceLocation)new ResourceLocation("tfc:seeds"));
        private final InventoryBlockEntity<?> entity;

        GroomingStationInventory(InventoryBlockEntity<?> entity) {
            super(entity, 9);
            this.entity = entity;
        }

        public int getSlots() {
            return super.getSlots();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack) && (FoodCapability.has((ItemStack)stack) || stack.m_204117_(SEEDS));
        }

        protected void onContentsChanged(int slot) {
            Level level;
            int level2;
            super.onContentsChanged(slot);
            int itemCount = 0;
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                itemCount += stack.m_41613_();
            }
            int n = itemCount >= 160 ? 2 : (level2 = itemCount > 0 ? 1 : 0);
            if (this.entity.m_58900_().m_61138_((Property)GroomingStation.LEVEL) && (level = this.entity.m_58904_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Integer currentLevel = (Integer)this.entity.m_58900_().m_61143_((Property)GroomingStation.LEVEL);
                if (currentLevel != level2) {
                    serverLevel.m_46597_(this.entity.m_58899_(), (BlockState)this.entity.m_58900_().m_61124_((Property)GroomingStation.LEVEL, (Comparable)Integer.valueOf(level2)));
                }
            }
        }
    }
}

