/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigBuilderWrapper {
    private final ForgeConfigSpec.Builder builder;
    private final String translationKeyPrefix;
    private boolean emptyLineAdded;

    public ConfigBuilderWrapper(ForgeConfigSpec.Builder builder, String translationKeyPrefix) {
        this.builder = builder;
        this.translationKeyPrefix = translationKeyPrefix;
        this.emptyLineAdded = false;
    }

    public ConfigBuilderWrapper push(String path) {
        this.builder.push(path);
        return this;
    }

    public ConfigBuilderWrapper swap(String path) {
        this.builder.pop().push(path);
        return this;
    }

    public ConfigBuilderWrapper pop() {
        this.builder.pop();
        return this;
    }

    public ConfigBuilderWrapper pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
        return this;
    }

    public ConfigBuilderWrapper comment(String ... path) {
        if (!this.emptyLineAdded) {
            this.builder.comment("");
            this.emptyLineAdded = true;
        }
        for (String line : path) {
            this.builder.comment(" " + line);
        }
        return this;
    }

    public ForgeConfigSpec.BooleanValue define(String path, boolean value) {
        return this.begin(path).define(path, value);
    }

    public ForgeConfigSpec.IntValue define(String path, int value, int min, int max) {
        return this.begin(path).defineInRange(path, value, min, max);
    }

    public ForgeConfigSpec.DoubleValue define(String path, double value, double min, double max) {
        return this.begin(path).defineInRange(path, value, min, max);
    }

    public ForgeConfigSpec.ConfigValue<String> define(String path, String value) {
        return this.begin(path).define(path, (Object)value);
    }

    public <E extends Enum<E>> ForgeConfigSpec.EnumValue<E> define(String path, E value) {
        return this.begin(path).defineEnum(path, value);
    }

    public ForgeConfigSpec.ConfigValue<List<? extends String>> define(String path, List<? extends String> value, Predicate<String> predicate) {
        return this.begin(path).defineListAllowEmpty(path, new ArrayList<String>(value), o -> {
            String s;
            return o instanceof String && predicate.test(s = (String)o);
        });
    }

    private ForgeConfigSpec.Builder begin(String path) {
        this.builder.translation("tfcgroomer.config." + this.translationKeyPrefix + "." + path);
        this.emptyLineAdded = false;
        return this.builder;
    }
}

