/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer.config;

import cy.jdkdigital.tfcgroomer.config.ConfigBuilderWrapper;
import java.util.EnumMap;
import net.dries007.tfc.util.Metal;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.BooleanValue enableBreedingToggle;
    public final ForgeConfigSpec.BooleanValue breedingEnabledByDefault;
    public final ForgeConfigSpec.IntValue groomingStationTicks;
    public final EnumMap<Metal.Default, ForgeConfigSpec.IntValue> rangeBlocks;
    public final ForgeConfigSpec.BooleanValue groomingStationEnableAutomation;
    public final ForgeConfigSpec.BooleanValue groomingStationRedstoneOutput;

    ServerConfig(ConfigBuilderWrapper builder) {
        builder.push("general");
        this.enableBreedingToggle = builder.comment("Enable option to toggle automatic breeding of animals by a Grooming Station on a block-to-block basis.").define("enableBreedingToggle", true);
        this.breedingEnabledByDefault = builder.comment("If true, grooming stations will automatically breed animals together when feeding.").define("breedingEnabledByDefault", false);
        this.groomingStationTicks = builder.comment("How much time (in ticks) the Grooming Station waits before checking for animals to feed.").define("groomingStationTicks", 1200, 20, 6000);
        builder.swap("tier_ranges");
        this.rangeBlocks = new EnumMap(Metal.Default.class);
        for (Metal.Default metal : Metal.Default.values()) {
            if (!metal.hasUtilities()) continue;
            this.rangeBlocks.put(metal, builder.comment(String.format("The maximum distance in blocks a %s grooming station will scan for animals to feed", metal.m_7912_().replace("_", " "))).define(metal.m_7912_(), metal.metalTier().ordinal(), 1, Integer.MAX_VALUE));
        }
        builder.swap("whitelist");
        builder.swap("automation");
        this.groomingStationEnableAutomation = builder.comment("If true, grooming stations will interact with in-world automation such as hoppers on a side-specific basis.").define("groomingStationEnableAutomation", true);
        this.groomingStationRedstoneOutput = builder.comment("If true, the Grooming Station will emit a redstone signal proportional to how full it is.").define("groomingStationRedstoneOutput", true);
        builder.pop();
    }
}

