/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.tfcgroomer.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.tfcgroomer.Groomer;
import cy.jdkdigital.tfcgroomer.common.block.GroomingStation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public ModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.m_6968_();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            Groomer.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        Groomer.GROOMING_STATIONS.forEach(block -> this.addBlockItemParentModel((Block)block.get(), itemModels));
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.m_245731_(ForgeRegistries.BLOCKS.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.m_245731_(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return ModelProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)item);
        return new TextureMapping().m_125758_(TextureSlot.f_125863_, resourcelocation.m_246208_(prefix).m_266382_(suffix));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.m_125571_((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemModel(Block block, String base, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(new ResourceLocation("tfcgroomer", "block/" + base)), itemModels);
        }
    }

    private void addBlockItemParentModel(Block block, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)block);
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(new ResourceLocation(rl.m_135827_(), "block/" + rl.m_135815_())), itemModels);
        }
    }

    public String m_6055_() {
        return "TFC: Grooming Station Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            Groomer.GROOMING_STATIONS.forEach(block -> this.createComposter((Block)block.get(), block.getId().m_135815_()));
        }

        private void createComposter(Block block, String name) {
            ModelTemplate groomingStationEmpty = new ModelTemplate(Optional.of(new ResourceLocation("tfcgroomer", "block/grooming_station")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_, TextureSlot.f_125869_});
            ModelTemplate groomingStationLevel1 = new ModelTemplate(Optional.of(new ResourceLocation("tfcgroomer", "block/grooming_station_level1")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_, TextureSlot.f_125869_});
            ModelTemplate groomingStationLevel2 = new ModelTemplate(Optional.of(new ResourceLocation("tfcgroomer", "block/grooming_station_level2")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_, TextureSlot.f_125869_});
            TextureMapping textureMap = new TextureMapping().m_125758_(TextureSlot.f_125871_, new ResourceLocation("tfcgroomer", "block/" + name + "_side")).m_125758_(TextureSlot.f_125872_, new ResourceLocation("tfcgroomer", "block/" + name + "_top")).m_125758_(TextureSlot.f_125875_, new ResourceLocation("tfcgroomer", "block/" + name + "_side")).m_176477_(TextureSlot.f_125875_, TextureSlot.f_125869_);
            groomingStationEmpty.m_125612_(new ResourceLocation("tfcgroomer", "block/" + name), textureMap, this.modelOutput);
            groomingStationLevel1.m_125612_(new ResourceLocation("tfcgroomer", "block/" + name + "_half"), textureMap, this.modelOutput);
            groomingStationLevel2.m_125612_(new ResourceLocation("tfcgroomer", "block/" + name + "_full"), textureMap, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)block).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)TextureMapping.m_125740_((Block)block))).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)GroomingStation.LEVEL, (Comparable)Integer.valueOf(0)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)TextureMapping.m_125753_((Block)block, (String)""))).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)GroomingStation.LEVEL, (Comparable)Integer.valueOf(1)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)TextureMapping.m_125753_((Block)block, (String)"_half"))).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)GroomingStation.LEVEL, (Comparable)Integer.valueOf(2)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)TextureMapping.m_125753_((Block)block, (String)"_full"))));
        }
    }
}

