/*
 * Decompiled with CFR 0.152.
 */
package waves.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import waves.Waves;
import waves.util.WaveHelpers;

public record PresencePacket(boolean isPresent) implements CustomPacketPayload
{
    public static final ResourceLocation ID = WaveHelpers.identifier("presence");
    public static final CustomPacketPayload.Type<PresencePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PresencePacket> CODEC = StreamCodec.ofMember(PresencePacket::write, PresencePacket::read);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isPresent);
    }

    public static PresencePacket read(FriendlyByteBuf buf) {
        return new PresencePacket(buf.readBoolean());
    }

    public static void handle(PresencePacket packet, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                WaveHelpers.setIsPresent(packet.isPresent);
                Waves.LOGGER.info("Received PresencePacket: isPresent = {}", (Object)packet.isPresent);
            });
        }
    }
}

