/*
 * Decompiled with CFR 0.152.
 */
package waves.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import waves.Waves;
import waves.common.WavesTags;
import waves.util.WaveHelpers;

public class TagLoader {
    public static final String DATA_PATH = "data/waves/tags/";
    public static final Map<TagKey<?>, Set<ResourceLocation>> LOADED_TAGS = new HashMap();
    private static boolean tagsLoaded = false;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(TagLoader::onClientSetup);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        if (!tagsLoaded) {
            String jarName = TagLoader.getJarName();
            Waves.LOGGER.info("Loading tags during client setup from {}\\{}", (Object)(jarName != null ? jarName : "mod JAR"), (Object)DATA_PATH);
            TagLoader.loadTagsFromFiles();
            tagsLoaded = !LOADED_TAGS.isEmpty();
        }
    }

    private static String getJarName() {
        try {
            String jarPath = TagLoader.accessFirstMatchingJar();
            if (jarPath != null) {
                return new File(jarPath).getName();
            }
        }
        catch (IOException e) {
            Waves.LOGGER.error("Failed to get JAR name: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static Map<String, Map<String, TagKey<?>>> getTagKeys() {
        HashMap tagKeys = new HashMap();
        try {
            for (Class<?> innerClass : WavesTags.class.getDeclaredClasses()) {
                for (Field field : innerClass.getDeclaredFields()) {
                    if (field.getType() != TagKey.class) continue;
                    TagKey tagKey = (TagKey)field.get(null);
                    String registryPath = TagLoader.getTagPathForRegistry(tagKey.f_203867_());
                    String tagPath = tagKey.f_203868_().m_135815_();
                    tagKeys.computeIfAbsent(registryPath, k -> new HashMap()).put(registryPath + "/" + tagPath, tagKey);
                    Waves.LOGGER.debug("Registered tag key: {} for registry: {}", (Object)tagKey.f_203868_(), (Object)registryPath);
                }
            }
        }
        catch (IllegalAccessException e) {
            Waves.LOGGER.error("Failed to access WavesTags fields: {}", (Object)e.getMessage());
        }
        Waves.LOGGER.info("Discovered tag types: {}", tagKeys.keySet());
        return tagKeys;
    }

    private static String getTagPathForRegistry(ResourceKey<? extends Registry<?>> registryKey) {
        String path = registryKey.m_135782_().m_135815_();
        if (path.startsWith("worldgen/")) {
            return path;
        }
        return switch (path) {
            case "block" -> "blocks";
            case "item" -> "items";
            case "entity_type" -> "entity_types";
            case "fluid" -> "fluids";
            default -> path + "s";
        };
    }

    private static String accessFirstMatchingJar() throws IOException {
        String fileName;
        File directory = new File(FMLPaths.MODSDIR.get().toString());
        if (!directory.exists() || !directory.isDirectory()) {
            Waves.LOGGER.error("Invalid directory path: {}", (Object)directory.getAbsolutePath());
            throw new IOException("Invalid directory path: " + directory.getAbsolutePath());
        }
        File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (files == null || files.length == 0) {
            Waves.LOGGER.warn("No JAR files found in {}", (Object)directory.getAbsolutePath());
            return null;
        }
        Waves.LOGGER.debug("Scanning JAR files in {}:", (Object)directory.getAbsolutePath());
        for (File jarFile : files) {
            Waves.LOGGER.debug("Found JAR: {}", (Object)jarFile.getName());
        }
        for (File jarFile : files) {
            fileName = jarFile.getName();
            String baseName = fileName.toLowerCase().replaceAll("-.*\\.jar$", "");
            Waves.LOGGER.debug("JAR: {}, Base name after stripping: {}", (Object)fileName, (Object)baseName);
            if (!baseName.equalsIgnoreCase("waves")) continue;
            Waves.LOGGER.debug("Selected JAR file: {}", (Object)jarFile.getAbsolutePath());
            try (JarFile jar = new JarFile(jarFile);){
                String string = jarFile.getAbsolutePath();
                return string;
            }
        }
        for (File jarFile : files) {
            fileName = jarFile.getName();
            if (!fileName.toLowerCase().startsWith("waves".toLowerCase()) || !fileName.toLowerCase().endsWith(".jar")) continue;
            Waves.LOGGER.warn("No exact match for mod ID '{}', falling back to startsWith check. Selected JAR: {}", (Object)"waves", (Object)fileName);
            try (JarFile jar = new JarFile(jarFile);){
                String string = jarFile.getAbsolutePath();
                return string;
            }
        }
        Waves.LOGGER.warn("No JAR file found with name matching or starting with mod ID: {}", (Object)"waves");
        return null;
    }

    private static void readAllJsonFromDirectory(String jarPath, Map<String, JsonElement> map) throws IOException {
        File jarFile = new File(jarPath);
        if (!jarFile.exists() || !jarFile.getName().endsWith(".jar")) {
            Waves.LOGGER.error("Invalid JAR file path: {}", (Object)jarPath);
            throw new IOException("Invalid JAR file path: " + jarPath);
        }
        String fullDirPath = DATA_PATH;
        Waves.LOGGER.debug("Scanning for JSON files in: {}", (Object)fullDirPath);
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry entry;
            Enumeration<JarEntry> entries = jar.entries();
            Waves.LOGGER.debug("Listing all JAR entries in {}:", (Object)jarFile.getName());
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                Waves.LOGGER.debug("JAR entry: {}", (Object)entry.getName());
            }
            entries = jar.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(fullDirPath) || !name.endsWith(".json")) continue;
                String jsonFileName = name.substring(fullDirPath.length());
                if (jsonFileName.contains("/")) {
                    jsonFileName = jsonFileName.substring(jsonFileName.lastIndexOf("/") + 1);
                }
                Waves.LOGGER.debug("Found JSON file: {} (full path: {})", (Object)jsonFileName, (Object)name);
                InputStream inputStream = jar.getInputStream(entry);
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
                        String filePathWithoutExtension = name.substring(DATA_PATH.length(), name.length() - ".json".length());
                        map.put(filePathWithoutExtension, jsonElement);
                        Waves.LOGGER.debug("Successfully loaded JSON content for {}: {}", (Object)name, (Object)jsonElement.toString());
                    }
                    catch (JsonParseException e) {
                        Waves.LOGGER.warn("Skipping invalid JSON file: {} due to parsing error: {}", (Object)name, (Object)e.getMessage());
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadTagsFromFiles() {
        String jarName = TagLoader.getJarName();
        String jarPrefix = jarName != null ? jarName : "mod JAR";
        Waves.LOGGER.info("Loading tags from files for mod 'waves' in namespace 'waves' from {}\\{}", (Object)jarPrefix, (Object)DATA_PATH);
        Map<String, Map<String, TagKey<?>>> tagKeys = TagLoader.getTagKeys();
        ConcurrentHashMap<String, JsonElement> jsonMap = new ConcurrentHashMap<String, JsonElement>();
        try {
            String jarPath = TagLoader.accessFirstMatchingJar();
            if (jarPath == null) {
                Waves.LOGGER.error("No matching JAR file found for mod ID: {}", (Object)"waves");
                return;
            }
            Waves.LOGGER.debug("Found JAR file: {}", (Object)jarPath);
            TagLoader.readAllJsonFromDirectory(jarPath, jsonMap);
            if (jsonMap.isEmpty()) {
                Waves.LOGGER.warn("No JSON files found in directory: {}\\{}", (Object)jarPrefix, (Object)DATA_PATH);
                return;
            }
            for (Map.Entry<String, Map<String, TagKey<?>>> typeEntry : tagKeys.entrySet()) {
                String type = typeEntry.getKey();
                Waves.LOGGER.debug("Processing tag type: {}", (Object)type);
                for (Map.Entry<String, TagKey<?>> tagEntry : typeEntry.getValue().entrySet()) {
                    String tagPath = tagEntry.getKey();
                    TagKey<?> tagKey = tagEntry.getValue();
                    if (!tagKey.f_203868_().m_135827_().equals("waves")) {
                        Waves.LOGGER.warn("Skipping tag {}: not in 'waves' namespace", (Object)tagKey.f_203868_());
                        continue;
                    }
                    String filePath = DATA_PATH + tagPath + ".json";
                    JsonElement json = (JsonElement)jsonMap.get(tagPath);
                    if (json != null) {
                        try {
                            HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
                            JsonArray values = json.isJsonArray() ? json.getAsJsonArray() : json.getAsJsonObject().getAsJsonArray("values");
                            Waves.LOGGER.debug("Processing JSON values for {}: {}", (Object)filePath, (Object)values.toString());
                            for (JsonElement element : values) {
                                String id;
                                block19: {
                                    if (element.isJsonObject()) {
                                        JsonObject obj = element.getAsJsonObject();
                                        if (obj.has("id")) {
                                            id = obj.get("id").getAsString();
                                            break block19;
                                        } else {
                                            Waves.LOGGER.warn("Skipping JSON object without 'id' field in tag {}: {}", (Object)tagKey.f_203868_(), (Object)element.toString());
                                            continue;
                                        }
                                    }
                                    if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                                        id = element.getAsString();
                                    } else {
                                        Waves.LOGGER.warn("Skipping invalid JSON element in tag {}: {}", (Object)tagKey.f_203868_(), (Object)element.toString());
                                        continue;
                                    }
                                }
                                try {
                                    if (id.startsWith("#") || id.matches("[a-z0-9_.-]+:[a-z0-9_.-/]+")) {
                                        ResourceLocation location = WaveHelpers.resourceLocation(id.startsWith("#") ? id.substring(1) : id);
                                        locations.add(location);
                                        Waves.LOGGER.debug("Added ResourceLocation to tag {}: {}", (Object)tagKey.f_203868_(), (Object)id);
                                        continue;
                                    }
                                    Waves.LOGGER.warn("Invalid ResourceLocation format in tag {}: {}", (Object)tagKey.f_203868_(), (Object)id);
                                }
                                catch (Exception e) {
                                    Waves.LOGGER.warn("Invalid ResourceLocation in tag {}: {}", (Object)tagKey.f_203868_(), (Object)id);
                                }
                            }
                            LOADED_TAGS.put(tagKey, locations);
                            Waves.LOGGER.info("Loaded tag {} from file {}\\{}: {}", new Object[]{tagKey.f_203868_(), jarPrefix, filePath.replace("/", "\\"), locations});
                        }
                        catch (JsonParseException e) {
                            Waves.LOGGER.error("Failed to parse tag file {}\\{}: {}", new Object[]{jarPrefix, filePath.replace("/", "\\"), e.getMessage()});
                            LOADED_TAGS.put(tagKey, Collections.emptySet());
                        }
                        continue;
                    }
                    Waves.LOGGER.warn("Tag file not found: {}\\{}", (Object)jarPrefix, (Object)filePath.replace("/", "\\"));
                    LOADED_TAGS.put(tagKey, Collections.emptySet());
                }
            }
            return;
        }
        catch (IOException e) {
            Waves.LOGGER.error("Failed to load JSON files from directory {}\\{}: {}", new Object[]{jarPrefix, DATA_PATH, e.getMessage()});
        }
    }

    public static <T> Set<ResourceLocation> getTagLocations(TagKey<T> tagKey) {
        return LOADED_TAGS.getOrDefault(tagKey, Collections.emptySet());
    }

    public static <T> boolean isInTag(T element, TagKey<T> tagKey) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        Registry registry = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(tagKey.f_203867_());
        Optional resourceKey = registry.m_7854_(element);
        if (resourceKey.isEmpty()) {
            return false;
        }
        ResourceLocation elementLocation = ((ResourceKey)resourceKey.get()).m_135782_();
        boolean isInTag = LOADED_TAGS.getOrDefault(tagKey, Collections.emptySet()).contains(elementLocation);
        return isInTag;
    }
}

