/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import waves.client.ClientHelpers;
import waves.client.WaveSounds;
import waves.config.Config;
import waves.util.Color;
import waves.util.WaveHelpers;

public class WaveParticle {
    public Level level;
    public double xo;
    public double yo;
    public double zo;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public float quadSize;
    public double alpha;
    public int age;
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public Vec3 wavePos;
    public BlockPos behindBlockPos;
    public BlockPos shoreBlockPos;
    public float size;
    public float speed;
    public double initialDistance;
    public double angleToShore;
    public String waveSizeName;
    public int surroundWaterBlocks;
    public static double minDistance = Double.MAX_VALUE;
    public int waveSpriteOld;
    public double distanceOld;
    public double waveSpeedOld;
    public ResourceLocation waveTexture;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlayedSound = false;
    public float starBrightness;
    public float skyOvercast;
    public double bioluminescenceNoise;
    public int packedLight;
    public Color color = new Color();
    public List<Direction> renderDir = new ArrayList<Direction>();
    public Quaternionf rotation = new Quaternionf();
    public boolean renderParticle = false;

    public WaveParticle(Level level, Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        this.level = level;
        this.setPos(startPos.m_7096_(), startPos.m_7098_(), startPos.m_7094_());
        this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + WaveHelpers.toSize(waveSize).toLowerCase() + "_0.png");
        this.quadSize = size * 0.5f;
        this.xd = direction.m_7096_() * (double)speed;
        this.zd = direction.m_7094_() * (double)speed;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.size = size;
        this.speed = speed;
        this.initialDistance = startPos.m_82554_(shorePos);
        this.angleToShore = WaveHelpers.calculateAngleToTarget(startPos, shorePos);
        this.waveSizeName = WaveHelpers.toSize(waveSize).toLowerCase();
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.waveSpriteOld = 0;
        this.distanceOld = Double.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Player player, float partialTicks) {
        float soundMod;
        boolean shouldDecay;
        RandomSource random = RandomSource.m_216343_();
        Vec3 currentPos = new Vec3(this.x, this.y, this.z);
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        double distance = currentPos.m_82554_(this.shorePos);
        boolean hasFluidBelow = !this.level.m_6425_(blockPos.m_7495_()).m_76178_();
        this.skyOvercast = (float)WaveHelpers.scale(this.level.m_46722_(partialTicks) * (0.5f + this.level.m_46661_(partialTicks)), 0.0, 1.5, 0.0, 1.0);
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        if (this.waveSpriteOld < waveSprite) {
            this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + this.waveSizeName + "_" + waveSprite + ".png");
        }
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).m_82553_();
        boolean bl = shouldDecay = this.hasReachedShore || vecSpeed == 0.0 || waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1;
        if (!shouldDecay) {
            this.alpha = Mth.m_14008_((double)(this.alpha + (double)0.025f), (double)0.0, (double)1.0);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                this.alpha = 1.0;
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.m_7094_() * 0.015;
                this.xd = vecInverse.m_7096_() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.m_82554_(this.shorePos) <= 2.0) {
            double weatherFactor = WaveHelpers.scale(1.0f - this.skyOvercast, 0.0, 1.0, 0.5, 1.0);
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).m_82553_() * 0.02) * weatherFactor;
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        if ((!hasFluidBelow || this.waveSpeedOld == vecSpeed || distance > this.distanceOld) && this.hasReachedShore) {
            this.alpha = Mth.m_14008_((double)(this.alpha - (double)0.1f), (double)0.0, (double)1.0);
        }
        if (hasFluidBelow && this.hasTouchedLand) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            this.alpha = Mth.m_14008_((double)(this.alpha - (double)0.1f), (double)0.0, (double)1.0);
        }
        this.move(this.xd, 0.0, this.zd);
        if (this.alpha <= (double)0.01f || this.age > 600) {
            this.remove();
        }
        ++this.age;
        this.waveSpeedOld = vecSpeed;
        this.distanceOld = distance;
        if (this.waveSpriteOld <= waveSprite) {
            this.waveSpriteOld = waveSprite;
        }
        this.wavePos = new Vec3(this.x, this.y, this.z);
        this.behindBlockPos = WaveHelpers.toBlockPos(WaveHelpers.getPositionOffset(this.wavePos, this.angleToShore, 180.0, 6.0));
        if (currentPos.m_82554_(this.shorePos) < 4.0 && random.m_188503_((Integer)Config.COMMON.waveBreakingSoundChance.get() + 1) == 0 && !this.hasPlayedSound && (soundMod = (float)WaveHelpers.soundDistanceMod(player, this.shorePos, 60.0, 10.0)) > 0.0f) {
            Level level = this.level;
            synchronized (level) {
                float rainfall = 1.0f + this.skyOvercast * 0.5f;
                ClientHelpers.playSound(random, this.wavePos, WaveSounds.WAVES_BREAKING_CLIENT, SoundSource.AMBIENT, rainfall * 0.5f * soundMod * ((Double)Config.COMMON.waveVolume.get()).floatValue());
                this.hasPlayedSound = true;
            }
        }
        double distanceToParticle = player.m_20182_().m_82554_(this.wavePos);
        boolean bl2 = this.renderParticle = (ClientHelpers.isInFrustum(this.wavePos) || distanceToParticle <= 20.0) && distanceToParticle <= (double)ClientHelpers.getChunkRenderDistance() * 16.0;
        if (this.shouldRender()) {
            double dayTime = (double)this.level.m_46468_() * (Double)Config.COMMON.waveBioluminescenceFrequency.get();
            double speed = Math.sqrt(this.xd * this.xd + this.zd * this.zd) * 10.0;
            double skyBrightness = WaveHelpers.getSkyBrightness(this.level, partialTicks);
            double bioluminescenceNoise = Mth.m_14008_((double)(WaveHelpers.bioluminescenceNoise(this.level, 10L, (Integer)Config.COMMON.waveBioluminescenceChange.get()).noise(dayTime + this.x, dayTime + this.z) * speed), (double)0.0, (double)1.0) * (1.0 - skyBrightness);
            bioluminescenceNoise = bioluminescenceNoise < 0.05 ? 0.0 : bioluminescenceNoise;
            float r = (float)Mth.m_14008_((double)skyBrightness, (double)0.2, (double)1.0);
            float g = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise * 0.8), (double)0.2, (double)1.0);
            float b = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise), (double)0.2, (double)1.0);
            this.packedLight = (int)Math.round(Mth.m_14008_((double)((double)WaveHelpers.getLightColor(this.level, this.behindBlockPos.m_7494_()) + 1.0E7 * bioluminescenceNoise), (double)0.0, (double)1.572888E7));
            this.color = new Color((double)r, (double)g, (double)b, this.alpha);
            this.rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.f_252392_.m_252961_((float)(this.angleToShore - 1.5707963267948966))).mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        }
    }

    public void setPos(double pX, double pY, double pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public void move(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public int getLightColor(float pPartialTick) {
        BlockPos blockpos = BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z);
        return this.level.m_46805_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public void remove() {
        WaveHelpers.removeWaveParticle((ResourceKey<Level>)this.level.m_46472_(), this);
    }

    public boolean shouldRender() {
        return this.renderParticle;
    }
}

