/*
 * Decompiled with CFR 0.152.
 */
package waves.common.entities;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import waves.client.WaveSounds;
import waves.common.WavesTags;
import waves.config.Config;
import waves.util.Color;
import waves.util.WaveHelpers;

public class Wave
extends Entity {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> X = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Z = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> XO = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> YO = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ZO = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> QUAD_SIZE = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PACKED_LIGHT = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> WAVE_TEXTURE = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_X = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_Y = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_Z = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_W = SynchedEntityData.m_135353_(Wave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean hasInitializedParameters = false;
    public Level level;
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public Vec3 wavePos;
    public BlockPos behindBlockPos;
    public BlockPos shoreBlockPos;
    public float scale;
    public float size;
    public float speed;
    public float alpha;
    public int waveSize;
    public int surroundWaterBlocks;
    public int seaLevel;
    public double initialDistance;
    public double angleToShore;
    public String waveSizeName;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlacedBlock = false;
    public boolean hasPlayedSound = false;
    public int waveSpriteOld;
    public double distanceOld;
    public double waveSpeedOld;
    public String waveTexture;
    public float starBrightness;
    public float skyOvercast;
    public double bioluminescenceNoise;
    public int packedLight;
    public Color color = new Color();
    public Quaternionf rotation = new Quaternionf();
    public float quadSize;
    public boolean onGround;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.8f;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public int age;
    public double diagonalSize;
    public AABB aabb;

    public Wave(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.level = level;
        this.m_20242_(true);
        this.m_6842_(true);
        this.m_20225_(false);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(XO, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YO, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ZO, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(QUAD_SIZE, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(PACKED_LIGHT, (Object)0);
        this.f_19804_.m_135372_(WAVE_TEXTURE, (Object)"textures/particle/waves/small_0.png");
        this.f_19804_.m_135372_(ALPHA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ROTATION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_W, (Object)Float.valueOf(1.0f));
    }

    public void setParameters(Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks, int seaLevel) {
        this.hasInitializedParameters = true;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.scale = scale;
        this.size = size;
        this.speed = speed;
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.seaLevel = seaLevel;
        this.m_146884_(startPos);
        this.x = startPos.m_7096_();
        this.y = startPos.m_7098_();
        this.z = startPos.m_7094_();
        this.xd = direction.m_7096_() * (double)speed;
        this.zd = direction.m_7094_() * (double)speed;
        this.yd = 0.0;
        this.f_19804_.m_135381_(X, (Object)Float.valueOf((float)this.x));
        this.f_19804_.m_135381_(Y, (Object)Float.valueOf((float)this.y));
        this.f_19804_.m_135381_(Z, (Object)Float.valueOf((float)this.z));
        this.f_19804_.m_135381_(XO, (Object)Float.valueOf((float)this.f_19854_));
        this.f_19804_.m_135381_(YO, (Object)Float.valueOf((float)this.f_19855_));
        this.f_19804_.m_135381_(ZO, (Object)Float.valueOf((float)this.f_19856_));
        this.waveTexture = "textures/particle/waves/" + WaveHelpers.toSize(waveSize).toLowerCase() + "_0.png";
        this.f_19804_.m_135381_(WAVE_TEXTURE, (Object)this.waveTexture);
        this.quadSize = size * 0.5f;
        this.f_19804_.m_135381_(QUAD_SIZE, (Object)Float.valueOf(this.quadSize));
        this.waveSizeName = WaveHelpers.toSize(waveSize).toLowerCase();
        this.initialDistance = startPos.m_82554_(shorePos);
        this.angleToShore = WaveHelpers.calculateAngleToTarget(startPos, shorePos);
        this.waveSpriteOld = 0;
        this.distanceOld = Double.MAX_VALUE;
        this.waveSpeedOld = 0.0;
        this.age = 0;
        this.f_19804_.m_135381_(AGE, (Object)this.age);
        this.diagonalSize = Math.sqrt(Math.pow(this.quadSize, 2.0) + Math.pow(this.quadSize, 2.0)) / 2.0;
        this.aabb = new AABB(-this.diagonalSize, -this.diagonalSize, -this.diagonalSize, this.diagonalSize, this.diagonalSize, this.diagonalSize);
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
        this.m_20331_(true);
        this.f_19794_ = true;
        this.rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.f_252392_.m_252961_((float)(this.angleToShore - 1.5707963267948966))).mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        this.f_19804_.m_135381_(ROTATION_X, (Object)Float.valueOf(this.rotation.x));
        this.f_19804_.m_135381_(ROTATION_Y, (Object)Float.valueOf(this.rotation.y));
        this.f_19804_.m_135381_(ROTATION_Z, (Object)Float.valueOf(this.rotation.z));
        this.f_19804_.m_135381_(ROTATION_W, (Object)Float.valueOf(this.rotation.w));
    }

    public void m_8119_() {
        if (!this.hasInitializedParameters) {
            return;
        }
        RandomSource random = RandomSource.m_216343_();
        Vec3 currentPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        double distance = currentPos.m_82554_(this.shorePos);
        FluidState fluidState = WaveHelpers.getFastFluidState(this.level, blockPos.m_7495_());
        boolean hasFluidBelow = fluidState == null ? true : !fluidState.m_76178_();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        double vecSpeed = new Vec3(this.xd, 0.0, this.zd).m_82553_();
        boolean shouldDecay = this.hasReachedShore || vecSpeed == 0.0 || waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1;
        this.skyOvercast = (float)WaveHelpers.scale(this.level.m_46722_(0.0f) * (0.5f + this.level.m_46661_(0.0f)), 0.0, 1.5, 0.0, 1.0);
        if (!shouldDecay) {
            this.alpha = Mth.m_14036_((float)(this.alpha + 0.025f), (float)0.0f, (float)1.0f);
            this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        this.f_19854_ = this.x;
        this.f_19855_ = this.y;
        this.f_19856_ = this.z;
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            if (vecSpeed <= 0.01) {
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.zd = vecInverse.m_7094_() * 0.015;
                this.xd = vecInverse.m_7096_() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.m_82554_(this.shorePos) <= 2.0) {
            double weatherFactor = WaveHelpers.scale(1.0f - this.skyOvercast, 0.0, 1.0, 0.5, 1.0);
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).m_82553_() * 0.02) * weatherFactor;
            this.xd *= speedFactor;
            this.zd *= speedFactor;
        }
        if ((!hasFluidBelow || this.waveSpeedOld == vecSpeed || distance > this.distanceOld) && this.hasReachedShore) {
            this.alpha = Mth.m_14036_((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f);
            this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        if (hasFluidBelow && this.hasTouchedLand) {
            this.xd *= 0.95;
            this.zd *= 0.95;
            this.alpha = Mth.m_14036_((float)(this.alpha - 0.1f), (float)0.0f, (float)1.0f);
            this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(this.alpha));
        }
        this.m_6478_(MoverType.SELF, new Vec3(this.xd, 0.0, this.zd));
        this.depositBlock(currentPos, this.waveSpriteOld);
        if (this.alpha <= 0.01f || this.age > 600 || hasFluidBelow && this.hasTouchedLand) {
            this.remove();
            return;
        }
        ++this.age;
        this.f_19804_.m_135381_(AGE, (Object)this.age);
        this.waveSpeedOld = vecSpeed;
        this.distanceOld = distance;
        if (this.waveSpriteOld < waveSprite) {
            this.waveTexture = "textures/particle/waves/" + this.waveSizeName + "_" + waveSprite + ".png";
            this.f_19804_.m_135381_(WAVE_TEXTURE, (Object)this.waveTexture);
            this.waveSpriteOld = waveSprite;
        }
        this.wavePos = new Vec3(this.x, this.y, this.z);
        this.f_19804_.m_135381_(X, (Object)Float.valueOf((float)this.x));
        this.f_19804_.m_135381_(Y, (Object)Float.valueOf((float)this.y));
        this.f_19804_.m_135381_(Z, (Object)Float.valueOf((float)this.z));
        this.f_19804_.m_135381_(XO, (Object)Float.valueOf((float)this.f_19854_));
        this.f_19804_.m_135381_(YO, (Object)Float.valueOf((float)this.f_19855_));
        this.f_19804_.m_135381_(ZO, (Object)Float.valueOf((float)this.f_19856_));
        this.behindBlockPos = WaveHelpers.toBlockPos(WaveHelpers.getPositionOffset(this.wavePos, this.angleToShore, 180.0, 6.0));
        this.shoreBlockPos = WaveHelpers.toBlockPos(this.shorePos);
        if (currentPos.m_82554_(this.shorePos) < 4.0 && random.m_188503_((Integer)Config.COMMON.waveBreakingSoundChance.get() + 1) == 0 && !this.hasPlayedSound) {
            for (Player player : this.level.m_6907_()) {
                float soundMod = (float)WaveHelpers.soundDistanceMod(player, this.shorePos, 60.0, 10.0);
                if (!(soundMod > 0.0f)) continue;
                float rainfall = 1.0f + this.skyOvercast * 0.5f;
                float amplifier = rainfall * 0.5f * soundMod * ((Double)Config.COMMON.waveVolume.get()).floatValue();
                float volume = (random.m_188501_() * 0.75f + 0.35f) * amplifier;
                float pitch = random.m_188501_() * 0.8f + 0.7f;
                this.m_9236_().m_6263_((Player)null, this.x, this.y, this.z, (SoundEvent)WaveSounds.WAVES_BREAKING.get(), SoundSource.AMBIENT, volume, pitch);
                this.hasPlayedSound = true;
            }
        }
        double dayTime = (double)this.level.m_46468_() * (Double)Config.COMMON.waveBioluminescenceFrequency.get();
        double speed = Math.sqrt(this.xd * this.xd + this.zd * this.zd) * 10.0;
        double skyBrightness = WaveHelpers.getSkyBrightness(this.level, 0.0f);
        double bioluminescenceNoise = Mth.m_14008_((double)(WaveHelpers.bioluminescenceNoise(this.level, 10L, (Integer)Config.COMMON.waveBioluminescenceChange.get()).noise(dayTime + this.x, dayTime + this.z) * speed), (double)0.0, (double)1.0) * (1.0 - skyBrightness);
        this.bioluminescenceNoise = bioluminescenceNoise < 0.05 ? 0.0 : bioluminescenceNoise;
        float r = (float)Mth.m_14008_((double)skyBrightness, (double)0.2, (double)1.0);
        float g = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise * 0.8), (double)0.2, (double)1.0);
        float b = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise), (double)0.2, (double)1.0);
        this.packedLight = (int)Math.round(Mth.m_14008_((double)((double)WaveHelpers.getLightColor(this.level, this.behindBlockPos.m_7494_()) + 1.0E7 * bioluminescenceNoise), (double)0.0, (double)1.572888E7));
        this.f_19804_.m_135381_(PACKED_LIGHT, (Object)this.packedLight);
        this.color = new Color(r, g, b, this.alpha);
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        if (((Boolean)Config.COMMON.waveEntityInteraction.get()).booleanValue() && this.level.m_46467_() % (long)((Integer)Config.COMMON.waveInteractionUpdateFrequency.get()).intValue() == 0L) {
            AABB box = this.aabb.m_82383_(currentPos).m_82400_(2.0);
            List entityList = this.level.m_45976_(Entity.class, box);
            entityList.stream().filter(entity -> !(entity instanceof Wave)).forEach(entity -> {
                boolean isWhitelisted = WaveHelpers.isEntity(entity, WavesTags.EntityTypes.WAVE_INTERACTION_WHITELIST);
                boolean isBlacklisted = WaveHelpers.isEntity(entity, WavesTags.EntityTypes.WAVE_INTERACTION_BLACKLIST);
                if (isWhitelisted && !isBlacklisted || !isWhitelisted && !isBlacklisted) {
                    double sizeNorm = ((double)this.size - 3.0) / 11.0;
                    double sizeForceFactor = sizeNorm + 0.5;
                    Vec3 sizeFactor = new Vec3(0.125, 0.125, 0.125).m_82490_(sizeNorm * 3.0 + 1.0);
                    for (double i = 0.0; i < 7.0; i += 1.0) {
                        Level patt17523$temp;
                        ServerLevel server;
                        double spacing = (i / 3.0 - 1.0) * (double)this.quadSize * 0.5;
                        Vec3 offsetVec = new Vec3(spacing, 0.0, 0.0).m_82524_((float)(-this.angleToShore + 1.5707963267948966));
                        Vec3 aabbCenter = offsetVec.m_82549_(currentPos);
                        AABB aabb = new AABB(Vec3.f_82478_, sizeFactor).m_82383_(aabbCenter);
                        if (entity.m_20191_().m_82381_(aabb)) {
                            Level patt16432$temp;
                            if (this.level.m_46467_() % 1L + (long)random.m_188503_(8) == 0L && (patt16432$temp = this.level) instanceof ServerLevel) {
                                server = (ServerLevel)patt16432$temp;
                                double entityWidth = (double)entity.m_20205_() * 0.5;
                                server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, entity.m_20185_() + random.m_188583_() * entityWidth * 0.8, currentPos.m_7098_() - 0.1 + random.m_188500_() * 0.2, entity.m_20189_() + random.m_188583_() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                                server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_() + random.m_188583_() * entityWidth * 0.8, currentPos.m_7098_() - 0.1 + random.m_188500_() * 0.2, entity.m_20189_() + random.m_188583_() * entityWidth * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            entity.m_20256_(entity.m_20184_().m_82549_(new Vec3(this.xd * 0.025, (double)this.quadSize * 0.0015, this.zd * 0.025).m_82490_(sizeForceFactor).m_82490_(((Double)Config.COMMON.waveInteractionForceFactor.get()).doubleValue())));
                            break;
                        }
                        if (!((Boolean)Config.COMMON.debug.get()).booleanValue() || !((patt17523$temp = this.level) instanceof ServerLevel)) continue;
                        server = (ServerLevel)patt17523$temp;
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, aabbCenter.m_7096_(), aabbCenter.m_7098_(), aabbCenter.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            });
        }
    }

    public void depositBlock(Vec3 currentPos, int waveSprite) {
        if (!this.hasPlacedBlock && this.hasReachedShore && waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1) {
            this.hasPlacedBlock = true;
            RandomSource random = this.level.m_213780_();
            if ((Integer)Config.COMMON.waveBlockDepositChance.get() <= 0 || random.m_188503_(((Integer)Config.COMMON.waveBlockDepositChance.get()).intValue()) == 0) {
                BlockPos posDeposit = WaveHelpers.getRandomBlockPosAlongWave(this.level, random, currentPos, this.direction, this.size, this.seaLevel);
                BlockState stateDeposit = WaveHelpers.getFastBlockState(this.level, posDeposit);
                BlockState stateDepositBelow = WaveHelpers.getFastBlockState(this.level, posDeposit.m_7495_());
                Optional<Block> depositBlock = WaveHelpers.randomBlock(WavesTags.Blocks.TIDE_POOL_BLOCKS, random);
                if (!depositBlock.isEmpty()) {
                    BlockState depositState = depositBlock.get().m_49966_();
                    if ((stateDeposit.m_60795_() || stateDeposit.m_247087_()) && stateDepositBelow.m_60819_().m_76178_() && depositState.m_60710_((LevelReader)this.level, posDeposit)) {
                        this.level.m_46597_(posDeposit, depositState);
                    }
                }
            }
        }
    }

    public void remove() {
        this.m_146870_();
    }

    public void setSize(double length, double height, double width) {
        this.bbWidth = (float)width;
        this.bbHeight = (float)height;
        this.m_20011_(new AABB(-length, -width, -height, length, width, height));
    }

    public Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128379_("HasInitializedParameters", this.hasInitializedParameters);
        tag.m_128347_("X", this.x);
        tag.m_128347_("Y", this.y);
        tag.m_128347_("Z", this.z);
        tag.m_128347_("XO", this.f_19854_);
        tag.m_128347_("YO", this.f_19855_);
        tag.m_128347_("ZO", this.f_19856_);
        tag.m_128347_("StartPosX", this.startPos.m_7096_());
        tag.m_128347_("StartPosY", this.startPos.m_7098_());
        tag.m_128347_("StartPosZ", this.startPos.m_7094_());
        tag.m_128347_("ShorePosX", this.shorePos.m_7096_());
        tag.m_128347_("ShorePosY", this.shorePos.m_7098_());
        tag.m_128347_("ShorePosZ", this.shorePos.m_7094_());
        tag.m_128347_("DirectionX", this.direction.m_7096_());
        tag.m_128347_("DirectionY", this.direction.m_7098_());
        tag.m_128347_("DirectionZ", this.direction.m_7094_());
        tag.m_128350_("Scale", this.scale);
        tag.m_128350_("Size", this.size);
        tag.m_128350_("Speed", this.speed);
        tag.m_128405_("WaveSize", this.waveSize);
        tag.m_128405_("SurroundWaterBlocks", this.surroundWaterBlocks);
        tag.m_128405_("SeaLevel", this.seaLevel);
        tag.m_128347_("InitialDistance", this.initialDistance);
        tag.m_128379_("HasReachedShore", this.hasReachedShore);
        tag.m_128379_("HasTouchedLand", this.hasTouchedLand);
        tag.m_128379_("HasPlacedBlock", this.hasPlacedBlock);
        tag.m_128379_("HasPlayedSound", this.hasPlayedSound);
        tag.m_128405_("WaveSpriteOld", this.waveSpriteOld);
        tag.m_128347_("DistanceOld", this.distanceOld);
        tag.m_128347_("WaveSpeedOld", this.waveSpeedOld);
        tag.m_128359_("WaveTexture", this.waveTexture);
        tag.m_128347_("AngleToShore", this.angleToShore);
        tag.m_128350_("QuadSize", this.quadSize);
        tag.m_128405_("Age", this.age);
        tag.m_128347_("DiagonalSize", this.diagonalSize);
        tag.m_128350_("Alpha", this.alpha);
        tag.m_128350_("ColorR", this.color.red());
        tag.m_128350_("ColorG", this.color.green());
        tag.m_128350_("ColorB", this.color.blue());
        tag.m_128350_("RotationX", this.rotation.x);
        tag.m_128350_("RotationY", this.rotation.y);
        tag.m_128350_("RotationZ", this.rotation.z);
        tag.m_128350_("RotationW", this.rotation.w);
    }

    public void m_7378_(CompoundTag tag) {
        this.hasInitializedParameters = tag.m_128471_("HasInitializedParameters");
        this.x = tag.m_128459_("X");
        this.y = tag.m_128459_("Y");
        this.z = tag.m_128459_("Z");
        this.f_19854_ = tag.m_128459_("XO");
        this.f_19855_ = tag.m_128459_("YO");
        this.f_19856_ = tag.m_128459_("ZO");
        this.startPos = new Vec3(tag.m_128459_("StartPosX"), tag.m_128459_("StartPosY"), tag.m_128459_("StartPosZ"));
        this.shorePos = new Vec3(tag.m_128459_("ShorePosX"), tag.m_128459_("ShorePosY"), tag.m_128459_("ShorePosZ"));
        this.direction = new Vec3(tag.m_128459_("DirectionX"), tag.m_128459_("DirectionY"), tag.m_128459_("DirectionZ"));
        this.scale = tag.m_128457_("Scale");
        this.size = tag.m_128457_("Size");
        this.speed = tag.m_128457_("Speed");
        this.waveSize = tag.m_128451_("WaveSize");
        this.surroundWaterBlocks = tag.m_128451_("SurroundWaterBlocks");
        this.seaLevel = tag.m_128451_("SeaLevel");
        this.initialDistance = tag.m_128459_("InitialDistance");
        this.hasReachedShore = tag.m_128471_("HasReachedShore");
        this.hasTouchedLand = tag.m_128471_("HasTouchedLand");
        this.hasPlacedBlock = tag.m_128471_("HasPlacedBlock");
        this.hasPlayedSound = tag.m_128471_("HasPlayedSound");
        this.waveSpriteOld = tag.m_128451_("WaveSpriteOld");
        this.distanceOld = tag.m_128459_("DistanceOld");
        this.waveSpeedOld = tag.m_128459_("WaveSpeedOld");
        this.waveTexture = tag.m_128461_("WaveTexture");
        this.f_19804_.m_135381_(WAVE_TEXTURE, (Object)this.waveTexture);
        this.angleToShore = tag.m_128459_("AngleToShore");
        this.quadSize = tag.m_128457_("QuadSize");
        this.f_19804_.m_135381_(QUAD_SIZE, (Object)Float.valueOf(this.quadSize));
        this.age = tag.m_128451_("Age");
        this.f_19804_.m_135381_(AGE, (Object)this.age);
        this.diagonalSize = tag.m_128459_("DiagonalSize");
        this.alpha = tag.m_128457_("Alpha");
        this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(this.alpha));
        this.color = new Color(tag.m_128457_("ColorR"), tag.m_128457_("ColorG"), tag.m_128457_("ColorB"), this.alpha);
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(tag.m_128457_("ColorR")));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(tag.m_128457_("ColorG")));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(tag.m_128457_("ColorB")));
        this.rotation = new Quaternionf(tag.m_128457_("RotationX"), tag.m_128457_("RotationY"), tag.m_128457_("RotationZ"), tag.m_128457_("RotationW"));
        this.f_19804_.m_135381_(ROTATION_X, (Object)Float.valueOf(this.rotation.x));
        this.f_19804_.m_135381_(ROTATION_Y, (Object)Float.valueOf(this.rotation.y));
        this.f_19804_.m_135381_(ROTATION_Z, (Object)Float.valueOf(this.rotation.z));
        this.f_19804_.m_135381_(ROTATION_W, (Object)Float.valueOf(this.rotation.w));
        this.setSize(this.quadSize, (double)this.quadSize * 0.075, (double)this.quadSize * 0.2);
    }

    public Vec3 getPos() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(Z)).floatValue());
    }

    public Vec3 getPosOld() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(XO)).floatValue(), (double)((Float)this.f_19804_.m_135370_(YO)).floatValue(), (double)((Float)this.f_19804_.m_135370_(ZO)).floatValue());
    }

    public float getQuadSize() {
        return ((Float)this.f_19804_.m_135370_(QUAD_SIZE)).floatValue();
    }

    public int getPackedLight() {
        return (Integer)this.f_19804_.m_135370_(PACKED_LIGHT);
    }

    public ResourceLocation getWaveTexture() {
        return WaveHelpers.identifier((String)this.f_19804_.m_135370_(WAVE_TEXTURE));
    }

    public Color getColor() {
        return new Color(((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(ALPHA)).floatValue());
    }

    public Quaternionf getRotation() {
        return new Quaternionf(((Float)this.f_19804_.m_135370_(ROTATION_X)).floatValue(), ((Float)this.f_19804_.m_135370_(ROTATION_Y)).floatValue(), ((Float)this.f_19804_.m_135370_(ROTATION_Z)).floatValue(), ((Float)this.f_19804_.m_135370_(ROTATION_W)).floatValue());
    }

    public boolean m_6052_() {
        return false;
    }
}

