/*
 * Decompiled with CFR 0.152.
 */
package waves.util;

import java.util.List;
import waves.util.Color;

public class ColorUtils {
    public static float[] gGreen = new float[]{0.05882353f, 0.6156863f, 0.34509805f, 1.0f};
    public static Color gGreenC = ColorUtils.getColor(gGreen);
    public static float[] gBlue = new float[]{0.25882354f, 0.52156866f, 0.95686275f, 1.0f};
    public static Color gBlueC = ColorUtils.getColor(gBlue);
    public static float[] gRed = new float[]{0.85882354f, 0.26666668f, 0.21568628f, 1.0f};
    public static Color gRedC = ColorUtils.getColor(gRed);
    public static float[] gYellow = new float[]{0.95686275f, 0.627451f, 0.0f, 1.0f};
    public static Color gYellowC = ColorUtils.getColor(gYellow);
    public static float[] gWhite = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public static Color gWhiteC = ColorUtils.getColor(gWhite);
    public static float[] gPink = new float[]{1.0f, 0.4f, 1.0f, 1.0f};
    public static Color gPinkC = ColorUtils.getColor(gPink);
    public static float[] aOrange = new float[]{1.0f, 0.6f, 0.0f, 1.0f};
    public static Color aOrangeC = ColorUtils.getColor(aOrange);
    public static float[] tPurple = new float[]{0.047058824f, 0.1254902f, 0.50980395f, 1.0f};
    public static Color tPurpleC = ColorUtils.getColor(tPurple);
    public static float[] ddMagenta = new float[]{0.85490197f, 0.09411765f, 0.5176471f, 1.0f};
    public static Color ddMagentaC = ColorUtils.getColor(ddMagenta);
    public static float[] ddBrown = new float[]{0.39607844f, 0.21960784f, 0.09803922f, 1.0f};
    public static Color ddBrownC = ColorUtils.getColor(ddBrown);
    public static float[] oLighterGray = new float[]{0.85f, 0.85f, 0.85f, 1.0f};
    public static Color oLighterGrayC = ColorUtils.getColor(oLighterGray);
    public static float[] oLightGray = new float[]{0.85f, 0.85f, 0.85f, 1.0f};
    public static Color oLightGrayC = ColorUtils.getColor(oLightGray);
    public static float[] oDarkGray = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    public static Color oDarkGrayC = ColorUtils.getColor(oDarkGray);
    public static float[] oCyan = new float[]{0.0f, 0.9019608f, 1.0f, 1.0f};
    public static Color oCyanC = ColorUtils.getColor(ddMagenta);
    public static float[][] colorArray = new float[][]{gBlue, gRed, gYellow, gGreen, gPink, aOrange, tPurple, ddBrown, ddMagenta, oCyan};
    public static float[][] teffToRGB_harre;

    public static Color getColor(float[] c) {
        return new Color(c[0], c[1], c[2], c[3]);
    }

    public static Color getColor(List<Double> c) {
        return new Color(c.get(0).floatValue(), c.get(1).floatValue(), c.get(2).floatValue(), c.get(3).floatValue());
    }

    public static java.awt.Color toColor(Color color) {
        return new java.awt.Color(color.r, color.g, color.b, color.a);
    }

    public static float[] getColorFromIndex(int idx) {
        return colorArray[idx % colorArray.length];
    }

    public static float[] getRgbaComplimentary(float[] rgba) {
        float[] hsb = ColorUtils.rgbToHsb(rgba);
        float hue = hsb[0] * 360.0f;
        hsb[0] = (hue + 180.0f) % 360.0f / 360.0f;
        float[] rgb = ColorUtils.hsbToRgb(hsb);
        return new float[]{rgb[0], rgb[1], rgb[2], rgba[3]};
    }

    public static float[] getRgbComplimentary(float[] rgb) {
        float[] hsb = ColorUtils.rgbToHsb(rgb);
        float hue = hsb[0] * 360.0f;
        hsb[0] = (hue + 180.0f) % 360.0f / 360.0f;
        hsb[0] = 1.0f - hsb[0];
        return ColorUtils.hsbToRgb(hsb);
    }

    public static float[] rgbToHsb(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        return java.awt.Color.RGBtoHSB(r, g, b, null);
    }

    public static float[] hsbToRgb(float[] hsb) {
        java.awt.Color c = new java.awt.Color(java.awt.Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f};
    }

    public static String rgbaToHex(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        int a = (int)(color[3] * 255.0f);
        return String.format("#%02x%02x%02x%02x", r, g, b, a);
    }

    public static String rgbToHex(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static float[] hexToRgba(String hex) {
        return new float[]{(float)Integer.valueOf(hex.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(5, 7), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(7, 9), 16).intValue() / 255.0f};
    }

    public static float[] hexToRgb(String hex) {
        return new float[]{(float)Integer.valueOf(hex.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(5, 7), 16).intValue() / 255.0f};
    }

    public static float normalize(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return (value - min) / (max - min);
    }

    public static void grayscale(float value, float[] rgba) {
        rgba[0] = value;
        rgba[1] = value;
        rgba[2] = value;
        rgba[3] = 1.0f;
    }

    public static void colormap_blue_white_red(float value, float[] rgba) {
        float a = value * 2.0f - 1.0f;
        if (a <= 0.0f) {
            rgba[0] = rgba[1] = 1.0f + a;
            rgba[2] = 1.0f;
        } else {
            rgba[0] = 1.0f;
            rgba[1] = rgba[2] = 1.0f - a;
        }
    }

    public static void colormap_short_rainbow(float value, float[] rgba) {
        float a = (1.0f - value) / 0.25f;
        int X = (int)Math.floor(a);
        float Y = a - (float)X;
        rgba[3] = 1.0f;
        switch (X) {
            case 0: {
                rgba[0] = 1.0f;
                rgba[1] = Y;
                rgba[2] = 0.0f;
                break;
            }
            case 1: {
                rgba[0] = 1.0f - Y;
                rgba[1] = 1.0f;
                rgba[2] = 0.0f;
                break;
            }
            case 2: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f;
                rgba[2] = Y;
                break;
            }
            case 3: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f - Y;
                rgba[2] = 1.0f;
                break;
            }
            case 4: {
                rgba[0] = 0.0f;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
            }
        }
    }

    public static void colormap_long_rainbow(float value, float[] rgba) {
        if (rgba == null) {
            return;
        }
        float a = (1.0f - value) / 0.2f;
        int X = (int)Math.floor(a);
        float Y = a - (float)X;
        rgba[3] = 1.0f;
        switch (X) {
            case 0: {
                rgba[0] = 1.0f;
                rgba[1] = Y;
                rgba[2] = 0.0f;
                break;
            }
            case 1: {
                rgba[0] = 1.0f - Y;
                rgba[1] = 1.0f;
                rgba[2] = 0.0f;
                break;
            }
            case 2: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f;
                rgba[2] = Y;
                break;
            }
            case 3: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f - Y;
                rgba[2] = 1.0f;
                break;
            }
            case 4: {
                rgba[0] = Y;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
                break;
            }
            case 5: {
                rgba[0] = 1.0f;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
            }
        }
    }

    public static void colormap_yellow_to_red(float value, float[] rgba) {
        rgba[0] = 1.0f;
        rgba[1] = value;
        rgba[2] = 0.0f;
    }

    public static void colormap_blue_to_magenta(float value, float[] rgba) {
        rgba[0] = value;
        rgba[1] = 0.0f;
        rgba[2] = 1.0f;
    }

    public static float correctGamma(double clinear) {
        float result;
        if (clinear <= 0.0031308) {
            result = 12.92f * (float)clinear;
        } else {
            float a = 0.5f;
            result = (float)((double)(1.0f + a) * Math.pow(clinear, 0.4166666567325592) - (double)a);
        }
        return result;
    }

    public static float[] brighten(float[] rgb, float luminosity) {
        float[] hsl = ColorUtils.rgbToHsl(rgb);
        hsl[2] = luminosity;
        return ColorUtils.hslToRgb(hsl);
    }

    public static float[] rgbToHsl(float[] rgb) {
        float s;
        float avg;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float h = avg = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = (double)avg > 0.5 ? d / (2.0f - max - min) : d / (max + min);
            if (max == r) {
                h = (g - b) / d + (float)(g < b ? 6 : 0);
            } else if (max == g) {
                h = (b - r) / d + 2.0f;
            } else if (max == b) {
                h = (r - g) / d + 4.0f;
            }
            h /= 6.0f;
        }
        return new float[]{h, s, avg};
    }

    public static float[] hslToRgb(float[] hsl) {
        float r;
        float g;
        float b;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorUtils.hue2rgb(p, q, h + 0.0f);
            g = ColorUtils.hue2rgb(p, q, h);
            b = ColorUtils.hue2rgb(p, q, h - 0.0f);
        }
        return new float[]{r, g, b};
    }

    public static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.0f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.0f - t) * 6.0f;
        }
        return p;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static boolean isZero(Color c) {
        return c.r == 0.0f && c.g == 0.0f && c.b == 0.0f;
    }
}

