/*
 * Decompiled with CFR 0.152.
 */
package waves;

import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import waves.config.Config;
import waves.util.WaveDataManager;
import waves.util.WaveHelpers;

public class EventHandler {
    public static volatile boolean firstTick = true;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(EventHandler::onServerStarted);
        bus.addListener(EventHandler::onServerStopped);
        bus.addListener(EventHandler::handleWaves);
        bus.addListener(EventHandler::tickWaveEntities);
        bus.addListener(EventHandler::onBlockUpdated);
    }

    public static void onServerStarted(ServerStartedEvent event) {
        WaveDataManager.WAVE_DATA.initConfigs();
        event.getServer().m_129785_().forEach(level -> {
            WaveHelpers.BIOME_CACHE.clear();
            WaveHelpers.SHORE_CACHE.clear();
            WaveHelpers.NEAREST_SHORE_CACHE.clear();
            level.m_6907_().stream().forEach(player -> WaveHelpers.updateCaches((Level)level, (Player)player));
        });
    }

    public static void onServerStopped(ServerStoppedEvent event) {
        firstTick = true;
        WaveDataManager.WAVE_DATA.clearData();
        event.getServer().m_129785_().forEach(level -> {
            WaveHelpers.BIOME_CACHE.clear();
            WaveHelpers.SHORE_CACHE.clear();
            WaveHelpers.NEAREST_SHORE_CACHE.clear();
        });
    }

    public static void onBlockUpdated(BlockEvent event) {
        if (!((Boolean)Config.COMMON.useCaches.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            ConcurrentMap shoreCache;
            Level level = (Level)levelAccessor;
            ResourceKey levelKey = level.m_46472_();
            ChunkPos chunk = new ChunkPos(event.getPos());
            ConcurrentMap biomeLevelCache = (ConcurrentMap)WaveHelpers.BIOME_CACHE.get(levelKey);
            if (biomeLevelCache != null) {
                biomeLevelCache.remove(chunk);
            }
            if ((shoreCache = (ConcurrentMap)WaveHelpers.SHORE_CACHE.get(levelKey)) != null) {
                shoreCache.remove(chunk);
            }
        }
    }

    public static void handleWaves(TickEvent.PlayerTickEvent event) {
        if (!WaveHelpers.isClientSide()) {
            Player player = event.player;
            Level level = player.m_9236_();
            if (player != null && level != null && (Integer)Config.COMMON.waveSpawnFrequency.get() > 0 && (Double)Config.COMMON.waveSpawnAmount.get() > 0.0 && !WaveDataManager.WAVE_DATA.get().isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    long gameTime = level.m_46467_();
                    if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && (firstTick || (Integer)Config.COMMON.cacheUpdateFrequency.get() > 0 && gameTime % (long)((Integer)Config.COMMON.cacheUpdateFrequency.get()).intValue() == 0L)) {
                        WaveHelpers.wipeCaches(gameTime);
                        WaveHelpers.updateCaches(level, player);
                        firstTick = false;
                    }
                    if (gameTime % (long)((Integer)Config.COMMON.waveSpawnFrequency.get()).intValue() == 0L) {
                        WaveHelpers.spawnWaves((Level)serverLevel, (Player)serverPlayer);
                    }
                }
            }
        }
    }

    public static void tickWaveEntities(TickEvent.ServerTickEvent event) {
        if (WaveDataManager.WAVE_DATA.get().isEmpty()) {
            WaveDataManager.WAVE_DATA.initConfigs();
        }
    }
}

