/*
 * Decompiled with CFR 0.152.
 */
package waves.client;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import waves.client.ClientHelpers;
import waves.client.particle.WaveParticle;
import waves.client.particle.WaveParticleHandler;
import waves.client.render.WaveRenderer;
import waves.common.entities.WaveEntities;
import waves.config.Config;
import waves.util.WaveDataManager;
import waves.util.WaveHelpers;

public class ClientEventHandler {
    public static final ConcurrentMap<ResourceKey<Level>, List<WaveParticle>> WAVE_PARTICLES = new ConcurrentHashMap<ResourceKey<Level>, List<WaveParticle>>();
    public static final ConcurrentMap<ResourceKey<Level>, WaveParticleHandler> WAVE_PARTICLE_HANDLER = new ConcurrentHashMap<ResourceKey<Level>, WaveParticleHandler>();
    public static volatile Minecraft mc;
    public static volatile ClientLevel level;
    public static volatile Player player;
    public static volatile Camera camera;
    public static volatile float partialTicks;
    public static volatile double playerFOV;
    public static volatile boolean firstTick;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus busEvent = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::registerKeyBindings);
        busEvent.addListener(ClientEventHandler::onConnect);
        busEvent.addListener(ClientEventHandler::onDisconnect);
        busEvent.addListener(ClientEventHandler::onClientUpdate);
        busEvent.addListener(ClientEventHandler::onKeyEvent);
        busEvent.addListener(ClientEventHandler::handleWaves);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)WaveEntities.WAVES.get(), WaveRenderer::new);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(ClientHelpers.DRAW_SHORE_MAP);
    }

    public static void onConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        WaveHelpers.BIOME_CACHE.clear();
        WaveHelpers.SHORE_CACHE.clear();
        WaveHelpers.NEAREST_SHORE_CACHE.clear();
    }

    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        if (WaveHelpers.isClientSide()) {
            WaveDataManager.WAVE_DATA.clearData();
        }
        WAVE_PARTICLE_HANDLER.clear();
        WaveHelpers.BIOME_CACHE.clear();
        WaveHelpers.SHORE_CACHE.clear();
        WaveHelpers.NEAREST_SHORE_CACHE.clear();
    }

    public static void onClientUpdate(TickEvent.ClientTickEvent event) {
        Minecraft mc;
        if (WaveHelpers.isClientSide() && WaveDataManager.WAVE_DATA.get().isEmpty()) {
            WaveDataManager.WAVE_DATA.initConfigs();
        }
        if ((mc = Minecraft.m_91087_()) != null && mc.f_91074_ != null && mc.f_91073_ != null) {
            ResourceKey levelKey = mc.f_91073_.m_46472_();
            ClientEventHandler.mc = mc;
            level = mc.f_91073_;
            player = mc.f_91074_;
            camera = mc.f_91063_.m_109153_();
            partialTicks = mc.getPartialTick();
            playerFOV = ClientHelpers.getFOV(camera, partialTicks, 40.0) * ClientHelpers.getFieldOfViewModifier(player);
            WAVE_PARTICLE_HANDLER.computeIfAbsent((ResourceKey<Level>)levelKey, key -> {
                WaveParticleHandler handler = new WaveParticleHandler(level);
                mc.f_91061_.m_107344_((Particle)handler);
                return handler;
            });
        }
    }

    public static void handleWaves(TickEvent.ClientTickEvent event) {
        if (WaveHelpers.isClientSide() && mc != null && (Integer)Config.COMMON.waveSpawnFrequency.get() > 0 && (Double)Config.COMMON.waveSpawnAmount.get() > 0.0 && !WaveDataManager.WAVE_DATA.get().isEmpty() && level != null && player != null) {
            long gameTime = level.m_46467_();
            if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && (firstTick || (Integer)Config.COMMON.cacheUpdateFrequency.get() > 0 && gameTime % (long)((Integer)Config.COMMON.cacheUpdateFrequency.get()).intValue() == 0L)) {
                WaveHelpers.wipeCaches(gameTime);
                WaveHelpers.updateCaches((Level)level, player);
                firstTick = false;
            }
            if (gameTime % (long)((Integer)Config.COMMON.waveSpawnFrequency.get()).intValue() == 0L) {
                WaveHelpers.spawnWaves((Level)level, player, false);
            }
        }
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (!Minecraft.f_91002_ && ClientHelpers.DRAW_SHORE_MAP.m_90857_() && level != null && player != null) {
            ConcurrentMap nearestShoreCache;
            ConcurrentMap shoreCache;
            BlockPos centerPos = player.m_20183_();
            ResourceKey dimension = level.m_46472_();
            int seaLevel = WaveDataManager.WAVE_DATA.getCachedSeaLevelOrDefault((Level)level) - 1;
            int radius = WaveHelpers.getServerChunkSimulationDistance((Level)level) * 16;
            WaveHelpers.updateCaches((Level)level, player);
            ConcurrentMap biomeCache = (ConcurrentMap)WaveHelpers.BIOME_CACHE.get(dimension);
            if (biomeCache != null) {
                ClientHelpers.exportBiomeCacheAsImage((Level)level, centerPos, seaLevel, radius, biomeCache);
            }
            if ((shoreCache = (ConcurrentMap)WaveHelpers.SHORE_CACHE.get(dimension)) != null) {
                ClientHelpers.exportShoreCacheAsImage((Level)level, centerPos, seaLevel, radius, shoreCache);
            }
            if ((nearestShoreCache = (ConcurrentMap)WaveHelpers.NEAREST_SHORE_CACHE.get(dimension)) != null) {
                ClientHelpers.exportNearestShoreCacheAsImage((Level)level, centerPos, seaLevel, radius, (Integer)Config.COMMON.waveSearchDistance.get(), nearestShoreCache);
            }
        }
    }

    static {
        playerFOV = 70.0;
        firstTick = true;
    }
}

