/*
 * Decompiled with CFR 0.152.
 */
package waves.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector2f;
import org.joml.Vector3f;
import waves.Waves;
import waves.client.ClientEventHandler;
import waves.client.TagLoader;
import waves.mixin.client.GameRendererAccessor;
import waves.util.WaveHelpers;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelpers {
    public static final Vector2f[] UVS = new Vector2f[]{new Vector2f(1.0f, 1.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 1.0f)};
    public static final Vector3f[] QUAD = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
    public static final KeyMapping DRAW_SHORE_MAP = new KeyMapping("waves.key.draw_shore_map", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, -1, "Waves");

    public static boolean isInFrustum(Vec3 targetPos) {
        double fov;
        Vec3 toTarget;
        Camera camera = ClientEventHandler.camera;
        if (camera == null) {
            return false;
        }
        Vec3 camPos = camera.m_90583_();
        Vec3 lookDir = WaveHelpers.toVec3(camera.m_253058_());
        double dot = lookDir.m_82526_(toTarget = targetPos.m_82546_(camPos).m_82541_());
        double angle = Math.toDegrees(Math.acos(dot));
        return angle <= (fov = ClientEventHandler.playerFOV) / 2.0;
    }

    public static double getFOV(Camera camera, float partialTicks) {
        return ClientHelpers.getFOV(camera, partialTicks, 0.0);
    }

    public static double getFOV(Camera camera, float partialTicks, double buffer) {
        Minecraft minecraft = Minecraft.m_91087_();
        GameRenderer gameRenderer = minecraft.f_91063_;
        GameRendererAccessor accessor = (GameRendererAccessor)gameRenderer;
        return accessor.getFov(camera, partialTicks, true) + buffer;
    }

    public static double getFieldOfViewModifier(Player player) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer client = (AbstractClientPlayer)player;
            return client.m_108565_();
        }
        return 1.0;
    }

    public static int getChunkRenderDistance() {
        return (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
    }

    public static int getChunkSimulationDistance() {
        return (Integer)Minecraft.m_91087_().f_91066_.m_232001_().m_231551_();
    }

    public static void exportBiomeCacheAsImage(Level level, BlockPos centerPos, int seaLevel, int radius, ConcurrentMap<ChunkPos, ConcurrentMap<BlockPos, Holder<Biome>>> biomeCache) {
        int size = radius * 2 + 1;
        BufferedImage image = new BufferedImage(size, size, 2);
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int x = centerX + dx;
                int z = centerZ + dz;
                BlockPos pos = new BlockPos(x, seaLevel, z);
                ChunkPos chunk = new ChunkPos(pos);
                ConcurrentMap chunkCache = (ConcurrentMap)biomeCache.get(chunk);
                Holder biome = chunkCache != null ? (Holder)chunkCache.get(pos) : null;
                int color = biome != null ? ((Biome)biome.get()).m_47464_((double)x, (double)z) : -16777216;
                image.setRGB(dx + radius, dz + radius, color);
            }
        }
        try {
            Path screenshotsDir = Minecraft.m_91087_().f_91069_.toPath().resolve("screenshots");
            Files.createDirectories(screenshotsDir, new FileAttribute[0]);
            String filename = "biomemap_" + System.currentTimeMillis() + ".png";
            Path outputPath = screenshotsDir.resolve(filename);
            ImageIO.write((RenderedImage)image, "png", outputPath.toFile());
            Waves.LOGGER.info("Saved biome map to screenshots/" + filename);
        }
        catch (IOException e) {
            Waves.LOGGER.info("Failed to save biome map: " + e.getMessage());
        }
    }

    public static void exportShoreCacheAsImage(Level level, BlockPos centerPos, int seaLevel, int radius, ConcurrentMap<ChunkPos, ConcurrentMap<BlockPos, Boolean>> shoreCache) {
        int size = radius * 2 + 1;
        BufferedImage image = new BufferedImage(size, size, 2);
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int x = centerX + dx;
                int z = centerZ + dz;
                BlockPos pos = new BlockPos(x, seaLevel, z);
                ChunkPos chunk = new ChunkPos(pos);
                ConcurrentMap chunkCache = (ConcurrentMap)shoreCache.get(chunk);
                boolean isShore = chunkCache != null && chunkCache.get(pos) != null ? (Boolean)chunkCache.get(pos) : WaveHelpers.getIsShore(level, pos);
                int color = isShore ? -1 : -16777216;
                image.setRGB(dx + radius, dz + radius, color);
            }
        }
        try {
            Path screenshotsDir = Minecraft.m_91087_().f_91069_.toPath().resolve("screenshots");
            Files.createDirectories(screenshotsDir, new FileAttribute[0]);
            String filename = "shoremap_" + System.currentTimeMillis() + ".png";
            Path outputPath = screenshotsDir.resolve(filename);
            ImageIO.write((RenderedImage)image, "png", outputPath.toFile());
            Waves.LOGGER.info("Saved shore map to screenshots/" + filename);
        }
        catch (IOException e) {
            Waves.LOGGER.info("Failed to save shore map: " + e.getMessage());
        }
    }

    public static void exportNearestShoreCacheAsImage(Level level, BlockPos centerPos, int seaLevel, int radius, int searchRadius, ConcurrentMap<ChunkPos, ConcurrentMap<BlockPos, Vec3>> nearestShoreCache) {
        int size = radius * 2 + 1;
        BufferedImage image = new BufferedImage(size, size, 2);
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int color;
                int x = centerX + dx;
                int z = centerZ + dz;
                BlockPos pos = new BlockPos(x, seaLevel, z);
                ChunkPos chunk = new ChunkPos(pos);
                if (nearestShoreCache != null) {
                    ConcurrentMap chunkCache = (ConcurrentMap)nearestShoreCache.get(chunk);
                    if (chunkCache != null) {
                        Vec3 nearestShore = (Vec3)chunkCache.get(pos);
                        if (nearestShore != null) {
                            Vec3 currentVec = new Vec3((double)x + 0.5, (double)seaLevel, (double)z + 0.5);
                            double distance = Math.sqrt(currentVec.m_82557_(nearestShore));
                            if (distance < 0.5) {
                                color = -1;
                            } else {
                                double normalizedDistance = Math.min(distance / (double)searchRadius, 1.0);
                                int red = (int)(255.0 * normalizedDistance);
                                int blue = (int)(255.0 * (1.0 - normalizedDistance));
                                color = 0xFF000000 | red << 16 | blue;
                            }
                        } else {
                            color = -16777216;
                        }
                    } else {
                        color = -16777216;
                    }
                } else {
                    color = -16777216;
                }
                image.setRGB(dx + radius, dz + radius, color);
            }
        }
        try {
            Path screenshotsDir = Minecraft.m_91087_().f_91069_.toPath().resolve("screenshots");
            Files.createDirectories(screenshotsDir, new FileAttribute[0]);
            String filename = "nearestshoremap_" + System.currentTimeMillis() + ".png";
            Path outputPath = screenshotsDir.resolve(filename);
            ImageIO.write((RenderedImage)image, "png", outputPath.toFile());
            Waves.LOGGER.info("Saved nearest shore map to screenshots/" + filename);
        }
        catch (IOException e) {
            Waves.LOGGER.info("Failed to save nearest shore map: " + e.getMessage());
        }
    }

    public static void playSound(RandomSource random, Vec3 pos, SoundEvent sound, SoundSource source, float amplifier) {
        Minecraft mc = ClientEventHandler.mc;
        SoundManager soundManager = mc.m_91106_();
        Camera camera = ClientEventHandler.camera;
        double x = pos.m_7096_() + 0.5;
        double y = pos.m_7098_() + 0.5;
        double z = pos.m_7094_() + 0.5;
        SimpleSoundInstance waveBreakingSound = new SimpleSoundInstance(sound, source, (random.m_188501_() * 0.75f + 0.35f) * amplifier, random.m_188501_() * 0.8f + 0.7f, random, x, y, z);
        double delay = camera.m_90583_().m_82531_(x, y, z);
        if (delay > 100.0) {
            double d1 = Math.sqrt(delay) / 40.0;
            soundManager.m_120369_((SoundInstance)waveBreakingSound, (int)(d1 * 20.0));
        } else {
            soundManager.m_120367_((SoundInstance)waveBreakingSound);
        }
    }

    public static boolean isBiome(Holder<Biome> biome, TagKey<Biome> tag) {
        return TagLoader.isInTag((Biome)biome.get(), tag);
    }

    public static boolean isEntity(Entity entity, TagKey<EntityType<?>> tag) {
        return ClientHelpers.isEntity(entity.m_6095_(), tag);
    }

    public static boolean isEntity(EntityType<?> entity, TagKey<EntityType<?>> tag) {
        return TagLoader.isInTag(entity, tag);
    }

    public static boolean isFluidType(FluidState fluidState, TagKey<FluidType> tag) {
        return ClientHelpers.isFluidType(fluidState.getFluidType(), tag);
    }

    public static boolean isFluidType(FluidType fluidType, TagKey<FluidType> tag) {
        return TagLoader.isInTag(fluidType, tag);
    }

    public static boolean isFluid(FluidState fluidState, TagKey<Fluid> tag) {
        return ClientHelpers.isFluid(fluidState.m_76152_(), tag);
    }

    public static boolean isFluid(Fluid fluid, TagKey<Fluid> tag) {
        return TagLoader.isInTag(fluid, tag);
    }

    public static boolean isBlock(BlockState state, TagKey<Block> tag) {
        return ClientHelpers.isBlock(state.m_60734_(), tag);
    }

    public static boolean isBlock(Block block, TagKey<Block> tag) {
        return TagLoader.isInTag(block, tag);
    }

    public static Optional<Block> randomBlock(TagKey<Block> tag, RandomSource random) {
        return ClientHelpers.getRandomElement(tag, random);
    }

    public static <T> Optional<T> getRandomElement(TagKey<T> tag, RandomSource random) {
        Set<ResourceLocation> locations = TagLoader.getTagLocations(tag);
        if (locations.isEmpty()) {
            Waves.LOGGER.warn("Cannot get random element from empty or non-existent tag: {}", (Object)tag.f_203868_());
            return Optional.empty();
        }
        ResourceLocation[] locationArray = locations.toArray(new ResourceLocation[0]);
        ResourceLocation selectedLocation = locationArray[random.m_188503_(locationArray.length)];
        Registry registry = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(tag.f_203867_());
        Optional<ResourceKey> resourceKey = Optional.of(ResourceKey.m_135785_((ResourceKey)tag.f_203867_(), (ResourceLocation)selectedLocation));
        Optional<Object> element = resourceKey.flatMap(arg_0 -> ((Registry)registry).m_203636_(arg_0)).map(Holder::m_203334_);
        return element;
    }
}

