/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.ClientEventHandler;
import waves.client.ClientHelpers;
import waves.client.particle.WaveParticle;
import waves.util.RenderHelpers;

public class WaveParticleHandler
extends TextureSheetParticle {
    public final BufferBuilder builder;
    public final ResourceKey<Level> dimensionKey;
    public List<WaveParticle> cachedWaveParticles = new CopyOnWriteArrayList<WaveParticle>();

    public WaveParticleHandler(ClientLevel level) {
        super(level, 0.0, 0.0, 0.0);
        this.builder = Tesselator.m_85913_().m_85915_();
        this.m_107259_(IForgeBlockEntity.INFINITE_EXTENT_AABB);
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107226_ = 0.0f;
        this.f_107230_ = 0.0f;
        this.f_107219_ = false;
        this.dimensionKey = level.m_46472_();
    }

    public void m_5989_() {
        Minecraft mc = ClientEventHandler.mc;
        Vec3 pos = mc.f_91074_.m_20182_();
        this.m_107264_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        List waveList = (List)ClientEventHandler.WAVE_PARTICLES.get(this.dimensionKey);
        if (waveList != null && !waveList.isEmpty()) {
            this.cachedWaveParticles.clear();
            this.cachedWaveParticles.addAll(waveList);
            LocalPlayer player = mc.f_91074_;
            float partialTicks = ClientEventHandler.partialTicks;
            this.cachedWaveParticles.parallelStream().forEach(arg_0 -> WaveParticleHandler.lambda$tick$0((Player)player, partialTicks, arg_0));
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (this.cachedWaveParticles != null && !this.cachedWaveParticles.isEmpty()) {
            Vec3 cameraPos = camera.m_90583_();
            this.cachedWaveParticles.stream().forEach(wave -> {
                if (wave != null && wave.shouldRender()) {
                    this.renderWave((WaveParticle)wave, this.builder, cameraPos, partialTicks);
                }
            });
        }
    }

    public void renderWave(WaveParticle wave, BufferBuilder builder, Vec3 cameraPos, float partialTicks) {
        int i;
        PoseStack poseStack = new PoseStack();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        RenderSystem.setShader(GameRenderer::m_172835_);
        RenderHelpers.translucentTransparency();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)wave.waveTexture);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.m_85836_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)wave.xo, (double)wave.x) - cameraPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)wave.yo, (double)wave.y) - cameraPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)wave.zo, (double)wave.z) - cameraPos.m_7094_());
        Vector3f[] quad = (Vector3f[])Arrays.stream(ClientHelpers.QUAD).map(Vector3f::new).toArray(Vector3f[]::new);
        for (i = 0; i < 4; ++i) {
            Vector3f vector3 = quad[i];
            vector3.rotate((Quaternionfc)wave.rotation);
            vector3.mul(wave.quadSize);
            vector3.add(x, y, z);
        }
        for (i = 0; i < 4; ++i) {
            RenderHelpers.drawVertex((VertexConsumer)builder, poseStack, matrix, quad[i], wave.color, ClientHelpers.UVS[i], wave.packedLight);
        }
        poseStack.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public boolean shouldCull() {
        return false;
    }

    private static /* synthetic */ void lambda$tick$0(Player player, float partialTicks, WaveParticle wave) {
        if (wave != null) {
            wave.tick(player, partialTicks);
        }
    }
}

