/*
 * Decompiled with CFR 0.152.
 */
package waves.config;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue debug;
    public final ForgeConfigSpec.BooleanValue parallelProcessing;
    public final ForgeConfigSpec.BooleanValue useCaches;
    public final ForgeConfigSpec.IntValue cacheUpdateFrequency;
    public final ForgeConfigSpec.IntValue cacheResetFrequency;
    public final ForgeConfigSpec.BooleanValue waveEntityInteraction;
    public final ForgeConfigSpec.BooleanValue waveEqualSpawnDistribution;
    public final ForgeConfigSpec.IntValue waveSearchDistance;
    public final ForgeConfigSpec.DoubleValue waveSpawnDistance;
    public final ForgeConfigSpec.DoubleValue waveSpawnAmount;
    public final ForgeConfigSpec.IntValue waveSpawnFrequency;
    public final ForgeConfigSpec.DoubleValue waveSpawnDistanceFromShoreMax;
    public final ForgeConfigSpec.DoubleValue waveSpawnDistanceFromShoreMin;
    public final ForgeConfigSpec.IntValue waveSpriteCount;
    public final ForgeConfigSpec.IntValue waveBlockDepositChance;
    public final ForgeConfigSpec.IntValue waveBreakingSoundChance;
    public final ForgeConfigSpec.IntValue waveBioluminescenceChange;
    public final ForgeConfigSpec.DoubleValue waveBioluminescenceFrequency;
    public final ForgeConfigSpec.DoubleValue waveSpawningFOVLimit;
    public final ForgeConfigSpec.IntValue waveFindNearestShoreIterations;
    public final ForgeConfigSpec.DoubleValue waveVolume;
    public final ForgeConfigSpec.DoubleValue waveInteractionForceFactor;
    public final ForgeConfigSpec.IntValue waveInteractionUpdateFrequency;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("waves.config.common." + name);
        innerBuilder.push("Debug, Processing and Caching");
        this.debug = builder.apply("debug").comment("Enable debug?").define("debug", false);
        this.parallelProcessing = builder.apply("parallelProcessing").comment(new String[]{"Enable parallel processing for performance-critical tasks. ", "When enabled, certain operations - such as wave spawning, shore detection, and entity interactions - ", "may be executed concurrently across multiple threads. This can significantly improve performance on multi-core systems. ", "Recommended for servers with high entity load."}).define("parallelProcessing", true);
        this.useCaches = builder.apply("useCaches").comment("Toggle whether or not caches should be utilized. For larger servers with lots of activity, the benefit of using caches give diminishing returns.").define("useCaches", true);
        this.cacheUpdateFrequency = builder.apply("cacheUpdateFrequency").comment("How often the caches should be updated. The time is in ticks, so 20 ticks = 1 second. Set to 0 to disable cache updates.").defineInRange("cacheUpdateFrequency", 6000, 0, Integer.MAX_VALUE);
        this.cacheResetFrequency = builder.apply("cacheResetFrequency").comment("How often the caches should be reset. The time is in ticks, so 20 ticks = 1 second. Set to 0 to disable cache updates.").defineInRange("cacheResetFrequency", 24000, 0, Integer.MAX_VALUE);
        innerBuilder.pop();
        this.waveEntityInteraction = builder.apply("waveEntityInteraction").comment("Toggle whether or not waves should be able to interact (push) with nearby entities? True = enabled.").define("waveEntityInteraction", true);
        this.waveEqualSpawnDistribution = builder.apply("waveEqualSpawnDistribution").comment("Toggle whether spawning should be equally distributed across distance from the player or have a higher chance to spawn near the player. True = equal distribution.").define("waveEqualSpawnDistribution", true);
        this.waveSearchDistance = builder.apply("waveSearchDistance").comment("Search distance for when creating coastal waves.").defineInRange("waveSearchDistance", 14, 0, Integer.MAX_VALUE);
        this.waveSpawnDistance = builder.apply("waveSpawnDistance").comment("Additional block distance on top of render distance at which waves can spawn.").defineInRange("waveSpawnDistance", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.waveSpawnAmount = builder.apply("waveSpawnAmount").comment("Additional amount of waves to spawn.").defineInRange("waveSpawnAmount", 0.7, 0.0, Double.MAX_VALUE);
        this.waveSpawnFrequency = builder.apply("waveSpawnFrequency").comment("Time in ticks between each spawn sequence of waves. Set to 0 to disable waves.").defineInRange("waveSpawnFrequency", 20, 0, Integer.MAX_VALUE);
        this.waveSpawnDistanceFromShoreMax = builder.apply("waveSpawnDistanceFromShoreMax").comment("Maximum spawn distance from shore.").defineInRange("waveSpawnDistanceFromShoreMax", 48.0, 0.0, Double.MAX_VALUE);
        this.waveSpawnDistanceFromShoreMin = builder.apply("waveSpawnDistanceFromShoreMin").comment("Minimum spawn distance from shore.").defineInRange("waveSpawnDistanceFromShoreMin", 4.0, 0.0, Double.MAX_VALUE);
        this.waveSpriteCount = builder.apply("waveSpriteCount").comment("Amount of sprites for waves. Zero indexed.").defineInRange("waveSpriteCount", 5, 1, Integer.MAX_VALUE);
        this.waveBlockDepositChance = builder.apply("waveBlockDepositChance").comment("How great should the chance for waves to deposit blocks be? Lower value = higher chance.").defineInRange("waveBlockDepositChance", 100, 1, Integer.MAX_VALUE);
        this.waveBreakingSoundChance = builder.apply("waveBreakingSoundChance").comment("How often the waves should make a sound. Higher value = rarer.").defineInRange("waveBreakingSoundChance", 40, 0, Integer.MAX_VALUE);
        this.waveBioluminescenceChange = builder.apply("waveBioluminescenceChange").comment("How fast the bioluminescence should change (octaves).").defineInRange("waveBioluminescenceChange", 16, 1, Integer.MAX_VALUE);
        this.waveBioluminescenceFrequency = builder.apply("waveBioluminescenceFrequency").comment("The amount of iterations to process the bioluminescence noise map. More = rarer bioluminescent events.").defineInRange("waveBioluminescenceFrequency", 0.5, 0.0, Double.MAX_VALUE);
        this.waveSpawningFOVLimit = builder.apply("waveSpawningFOVLimit").comment("The maximum angle within which waves can spawn irt. the player view direction. E.g. 360 degrees would allow waves to spawn all around the player.").defineInRange("waveSpawningFOVLimit", 140.0, 0.0, 360.0);
        this.waveFindNearestShoreIterations = builder.apply("waveFindNearestShoreIterations").comment("The amount of iterations to search for and refine for the nearest shore position.").defineInRange("waveFindNearestShoreIterations", 4, 1, Integer.MAX_VALUE);
        this.waveVolume = builder.apply("waveVolume").comment("Volume modifier for the waves. 1.0 = 100% volume.").defineInRange("waveVolume", 1.0, 0.0, 10.0);
        this.waveInteractionForceFactor = builder.apply("waveInteractionForceFactor").comment("The multiplier value for how strong the interaction force of the waves are. Higher value = stronger force.").defineInRange("waveInteractionForceFactor", 1.0, -1.7976931348623157E308, Double.MAX_VALUE);
        this.waveInteractionUpdateFrequency = builder.apply("waveInteractionUpdateFrequency").comment("How often the wave interaction should refresh/update. Higher values can yield better TPS at the cost of decreased interaction precision. Higher value => longer intervals between updates.").defineInRange("waveInteractionUpdateFrequency", 4, 1, Integer.MAX_VALUE);
    }
}

