/*
 * Decompiled with CFR 0.152.
 */
package waves.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import waves.util.Color;

public class RenderHelpers {
    public static final void translucentTransparency() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void drawVertex(VertexConsumer consumer, PoseStack poseStack, Matrix4f matrix, Vector3f vec, Color color, Vector2f uvs, int packedLight) {
        Vector3f normal = poseStack.m_85850_().m_252943_().transform(new Vector3f(vec.x(), vec.y(), vec.z()));
        consumer.m_252986_(matrix, vec.x(), vec.y(), vec.z()).m_85950_(color.red(), color.green(), color.blue(), color.alpha()).m_7421_(uvs.x(), uvs.y()).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void drawObject(VertexConsumer consumer, BakedModel model, BlockState state, PoseStack poseStack, Color color, @Nullable List<Direction> renderDirs, int packedLight) {
        RenderHelpers.renderBlockModel(consumer, model, state, poseStack, color, renderDirs, packedLight);
    }

    public static void renderBlockModel(VertexConsumer consumer, BakedModel model, BlockState state, PoseStack poseStack, Color color, @Nullable List<Direction> renderDirs, int packedLight) {
        RenderHelpers.renderBlockModel(consumer, model, state, poseStack, packedLight, OverlayTexture.f_118083_, ModelData.EMPTY, color, renderDirs);
    }

    public static void renderBlockModel(VertexConsumer consumer, BakedModel model, BlockState state, PoseStack poseStack, int packedLight, int packedOverlay, ModelData modelData, Color color, @Nullable List<Direction> renderDirs) {
        if (state.m_60799_() == RenderShape.MODEL) {
            for (RenderType type : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
                RenderHelpers.renderModel(consumer, poseStack, state, model, modelData, type, color, packedLight, packedOverlay, renderDirs);
            }
        }
    }

    public static void renderModel(VertexConsumer consumer, PoseStack poseStack, @Nullable BlockState state, BakedModel model, ModelData modelData, RenderType renderType, Color color, int packedLight, int packedOverlay, @Nullable List<Direction> renderDirs) {
        RandomSource random = RandomSource.m_216327_();
        long seed = 42L;
        random.m_188584_(seed);
        int[] combinedLight = new int[]{packedLight, packedLight, packedLight, packedLight};
        float[] colorMul = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        for (Direction direction : Direction.values()) {
            RenderHelpers.renderQuads(consumer, poseStack, model.getQuads(state, direction, random, modelData, renderType), color, combinedLight, colorMul, packedOverlay, renderDirs);
        }
        RenderHelpers.renderQuads(consumer, poseStack, model.getQuads(state, (Direction)null, random, modelData, renderType), color, combinedLight, colorMul, packedOverlay, null);
    }

    public static void renderQuads(VertexConsumer consumer, PoseStack poseStack, List<BakedQuad> quads, Color color, int[] light, float[] colorMul, int overlay, @Nullable List<Direction> renderDirs) {
        quads.stream().forEach(quad -> {
            if (renderDirs != null && !renderDirs.contains(quad.m_111306_())) {
                return;
            }
            consumer.putBulkData(poseStack.m_85850_(), quad, colorMul, color.red(), color.green(), color.blue(), color.alpha(), light, overlay, false);
        });
    }
}

