/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.config.fileconfig;

import com.txttext.taczlabs.hud.crosshair.CrosshairType;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class HudConfig {
    public static ForgeConfigSpec.BooleanValue ENABLE_TL_CROSSHAIR;
    public static ForgeConfigSpec.BooleanValue inaccuracySpread;
    public static ForgeConfigSpec.IntValue color;
    public static ForgeConfigSpec.IntValue R;
    public static ForgeConfigSpec.IntValue G;
    public static ForgeConfigSpec.IntValue B;
    public static ForgeConfigSpec.IntValue A;
    public static ForgeConfigSpec.IntValue shadowAlpha;
    public static ForgeConfigSpec.IntValue shadowOffset;
    public static ForgeConfigSpec.IntValue maxSpread;
    public static ForgeConfigSpec.IntValue animSpeed;
    public static ForgeConfigSpec.IntValue shootingSpread;
    public static ForgeConfigSpec.EnumValue<CrosshairType> pistolCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> smgCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> rifleCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> mgCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> shotgunCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> sniperCrosshair;
    public static ForgeConfigSpec.EnumValue<CrosshairType> rpgCrosshair;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> customCrosshairs;
    public static ForgeConfigSpec.IntValue crosshairRadius;
    public static ForgeConfigSpec.IntValue crosshairLength;
    public static ForgeConfigSpec.IntValue crosshairWidth;
    public static ForgeConfigSpec.IntValue rectCrosshairRadius;
    public static ForgeConfigSpec.IntValue rectCrosshairLength;
    public static ForgeConfigSpec.IntValue rectCrosshairWidth;
    public static ForgeConfigSpec.IntValue rightAngleCrosshairRadius;
    public static ForgeConfigSpec.IntValue rightAngleCrosshairWidth;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("HUD");
        ENABLE_TL_CROSSHAIR = builder.comment("New Crosshair of TaCZ:Labs.").define("Enable TaCZ:Labs Crosshair", true);
        builder.push("Global Settings");
        color = builder.comment("Crosshair RGBA HEX color, format: 0xAARRGGBB.").defineInRange("Crosshair Color", -419430452, Integer.MIN_VALUE, Integer.MAX_VALUE);
        A = builder.defineInRange("A", 230, 0, 255);
        R = builder.defineInRange("R", 255, 0, 255);
        G = builder.defineInRange("G", 255, 0, 255);
        B = builder.defineInRange("B", 204, 0, 255);
        shadowAlpha = builder.comment("Shadow alpha of crosshair, range 0 ~ 255, default 128.").defineInRange("Shadow Alpha", 128, 0, 255);
        shadowOffset = builder.comment("Shadow offset of crosshair, range 1 ~ 6, default 1 .").defineInRange("Shadow Offset", 1, 0, 3);
        builder.pop();
        inaccuracySpread = builder.comment("Default: Bonding a combination of values such as scattering and plane velocity.\nOn: Based strictly on real scattering values.").define("Diffusion strictly based on real spread", true);
        maxSpread = builder.comment("Max spread radius, range 0 ~ 50, default 20.").defineInRange("Crosshair Max Spread", 20, 0, 50);
        animSpeed = builder.comment("Speed of crosshair anim. range 10 ~ 30, default 20.").defineInRange("Anim Speed", 20, 10, 30);
        shootingSpread = builder.comment("Magnitude of collimation spread according to the recoil at the time of firing, range 0 ~ 5, default 2.").defineInRange("Shooting Judder", 2, 0, 5);
        builder.pop();
        builder.push("Local Settings");
        builder.push("Crosshair Type");
        pistolCrosshair = builder.comment("Crosshair of Pistol").defineEnum("Pistol", (Enum)CrosshairType.RIGHT_ANGLE);
        smgCrosshair = builder.comment("Crosshair of Sub-Machine Gun").defineEnum("Sub-Machine Gun", (Enum)CrosshairType.CROSSHAIR);
        rifleCrosshair = builder.comment("Crosshair of Rifle").defineEnum("Rifle", (Enum)CrosshairType.CROSSHAIR);
        mgCrosshair = builder.comment("Crosshair of Machine Gun").defineEnum("Machine Gun", (Enum)CrosshairType.CROSSHAIR);
        sniperCrosshair = builder.comment("Crosshair of Sniper").defineEnum("Sniper", (Enum)CrosshairType.CROSSHAIR);
        shotgunCrosshair = builder.comment("Crosshair of Shotgun").defineEnum("Shotgun", (Enum)CrosshairType.RECT);
        rpgCrosshair = builder.comment("Crosshair of Heavy Weapon").defineEnum("Heavy Weapon", (Enum)CrosshairType.RECT);
        builder.pop();
        builder.push("Crosshair Properties");
        crosshairRadius = builder.comment("Radius of crosshair, range 0 ~ 10, default 5 .").defineInRange("Crosshair Radius", 5, 0, 10);
        crosshairLength = builder.comment("Length of crosshair, range 1 ~ 20, default 6 .").defineInRange("Crosshair Length", 6, 1, 20);
        crosshairWidth = builder.comment("Width of crosshair, range 1 ~ 10, default 2 .").defineInRange("Crosshair Width", 1, 1, 10);
        rectCrosshairRadius = builder.comment("Radius of rect crosshair, range 0 ~ 20, default 12 .").defineInRange("Rect Crosshair Radius", 10, 0, 20);
        rectCrosshairLength = builder.comment("Length of rect crosshair, range 1 ~ 20, default 6 .").defineInRange("Rect Crosshair Length", 6, 1, 20);
        rectCrosshairWidth = builder.comment("Width of rect crosshair, range 1 ~ 10, default 1 .").defineInRange("Rect Crosshair Width", 1, 1, 10);
        rightAngleCrosshairRadius = builder.comment("Radius of right angle crosshair, range 0 ~ 10, default 4 .").defineInRange("Right Angle Crosshair Radius", 4, 0, 10);
        rightAngleCrosshairWidth = builder.comment("Width of right angle crosshair, range 1 ~ 5, default 1 .").defineInRange("Right Angle Crosshair Width", 1, 1, 5);
        builder.pop();
        builder.pop();
    }
}

