/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.event.shoot;

import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import com.txttext.taczlabs.config.fileconfig.HudConfig;
import com.txttext.taczlabs.util.DeltaTime;
import com.txttext.taczlabs.util.TLUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class PlayerFireHandler {
    private static float fireSpread;
    private static final DeltaTime deltaTime;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerFireHandler());
    }

    @SubscribeEvent
    public void onPlayerFire(GunFireEvent event) {
        if (!event.getLogicalSide().isClient()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getShooter() != player) {
            return;
        }
        GunData gunData = TLUtil.getGunData(event.getGunItemStack());
        GunRecoil recoil = gunData.getRecoil();
        float kick = PlayerFireHandler.getRecoilKick(recoil, 1.0f);
        fireSpread += Math.max(kick, 1.0f) * (float)((Integer)HudConfig.shootingSpread.get()).intValue();
    }

    public static float getRecoilKick(GunRecoil recoil, float modifier) {
        GunRecoilKeyFrame[] frames = recoil.getPitch();
        float maxKick = 0.0f;
        if (frames != null) {
            for (GunRecoilKeyFrame frame : frames) {
                float[] v = frame.getValue();
                if (v == null || v.length != 2) continue;
                maxKick = Math.max(maxKick, Math.max(v[0], v[1]) * modifier);
            }
        }
        return maxKick;
    }

    public static float getFireSpread() {
        return fireSpread;
    }

    public static void setFireSpread(float spread) {
        fireSpread = spread;
    }

    static {
        deltaTime = new DeltaTime();
    }
}

