/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.hud.crosshair;

import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.txttext.taczlabs.config.fileconfig.HudConfig;
import com.txttext.taczlabs.event.shoot.PlayerFireHandler;
import com.txttext.taczlabs.hud.crosshair.CrosshairRenderer;
import com.txttext.taczlabs.hud.crosshair.CrosshairSpread;
import com.txttext.taczlabs.hud.crosshair.CrosshairType;
import com.txttext.taczlabs.hud.crosshair.GunSpread;
import com.txttext.taczlabs.hud.crosshair.SpreadData;
import com.txttext.taczlabs.util.DeltaTime;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class Crosshair {
    private static final float lieGunSpread = 0.5f;
    private static final float sneakGunSpread = 0.7f;
    public static GunData gunData;
    private static float lastSpread;
    private static final DeltaTime deltaTime;

    public static void renderCrosshair(GuiGraphics graphics, CrosshairType type, float x, float y, ClientGunIndex gunIndex, LocalPlayer player) {
        float spread = Crosshair.getSpread(type, gunIndex, player);
        switch (type) {
            case CROSSHAIR: {
                CrosshairRenderer.drawCrosshair(x, y, spread);
                break;
            }
            case RECT: {
                CrosshairRenderer.drawRectCrosshair(x, y, spread);
                break;
            }
            case RIGHT_ANGLE: {
                CrosshairRenderer.drawRightAngleCrosshair(x, y, spread);
                break;
            }
            case ARC: {
                CrosshairRenderer.drawArcCrosshair(graphics, x, y, spread);
                break;
            }
            case POINT: {
                CrosshairRenderer.drawDot(x, y);
                break;
            }
            default: {
                CrosshairRenderer.drawCrosshair(x, y, spread);
            }
        }
    }

    private static float getSpread(CrosshairType type, ClientGunIndex gunIndex, LocalPlayer player) {
        boolean inaccuracy = (Boolean)HudConfig.inaccuracySpread.get();
        return inaccuracy ? Crosshair.getRealSpread(type, gunIndex, player) : Crosshair.getVisalSpread(type, player);
    }

    private static float getRealSpread(CrosshairType type, ClientGunIndex gunIndex, LocalPlayer player) {
        gunData = gunIndex.getGunData();
        CrosshairSpread crosshairSpread = Crosshair.getCrosshairSpread();
        float move = crosshairSpread.spreadData().move();
        float sneak = crosshairSpread.spreadData().sneak();
        float lie = crosshairSpread.spreadData().lie();
        InaccuracyType playerStatus = InaccuracyType.getInaccuracyType((LivingEntity)player);
        float status = switch (playerStatus) {
            case InaccuracyType.SNEAK -> sneak;
            case InaccuracyType.LIE -> lie;
            default -> 1.0f;
        };
        float speed = (float)player.m_20184_().m_165924_();
        float raw = speed > 0.01f ? move * 2.0f : 1.0f;
        float radius = Crosshair.getRadius(type);
        float baseSpread = radius * status * raw;
        return Crosshair.lerpAndUpdateSpread(baseSpread, radius);
    }

    private static float getVisalSpread(CrosshairType type, LocalPlayer player) {
        InaccuracyType playerStatus = InaccuracyType.getInaccuracyType((LivingEntity)player);
        float status = switch (playerStatus) {
            case InaccuracyType.SNEAK -> 0.7f;
            case InaccuracyType.LIE -> 0.5f;
            default -> 1.0f;
        };
        float speed = (float)player.m_20184_().m_165924_();
        float speedFactor = Mth.m_14036_((float)speed, (float)0.0f, (float)1.0f) * 80.0f;
        float radius = Crosshair.getRadius(type);
        float baseSpread = radius * status + speedFactor;
        return Crosshair.lerpAndUpdateSpread(baseSpread, radius);
    }

    private static float lerpAndUpdateSpread(float baseSpread, float radius) {
        float spread;
        float fireSpread = PlayerFireHandler.getFireSpread();
        float targetSpread = Math.min(baseSpread, radius + (float)((Integer)HudConfig.maxSpread.get()).intValue()) + fireSpread;
        float smoothing = ((Integer)HudConfig.animSpeed.get()).intValue();
        float tickDelta = deltaTime.updateTimeAndGetDeltaSec();
        float decayAlpha = 1.0f - (float)Math.exp(-smoothing * tickDelta);
        PlayerFireHandler.setFireSpread(Mth.m_14179_((float)decayAlpha, (float)fireSpread, (float)0.0f));
        float fixedDelta = 0.016666668f;
        float lerpAlpha = 1.0f - (float)Math.exp(-smoothing * fixedDelta);
        lastSpread = spread = Mth.m_14179_((float)lerpAlpha, (float)lastSpread, (float)targetSpread);
        return spread;
    }

    private static float getRadius(CrosshairType type) {
        return switch (type) {
            case CrosshairType.CROSSHAIR -> ((Integer)HudConfig.crosshairRadius.get()).intValue();
            case CrosshairType.RECT -> ((Integer)HudConfig.rectCrosshairRadius.get()).intValue();
            case CrosshairType.RIGHT_ANGLE -> ((Integer)HudConfig.rightAngleCrosshairRadius.get()).intValue();
            default -> ((Integer)HudConfig.crosshairRadius.get()).intValue();
        };
    }

    private static GunSpread getGunSpread(Map<InaccuracyType, Float> map) {
        float stand = map.getOrDefault(InaccuracyType.STAND, Float.valueOf(1.0f)).floatValue();
        return new GunSpread(new SpreadData(stand, map.getOrDefault(InaccuracyType.MOVE, Float.valueOf(stand)).floatValue(), map.getOrDefault(InaccuracyType.SNEAK, Float.valueOf(stand)).floatValue(), map.getOrDefault(InaccuracyType.LIE, Float.valueOf(stand)).floatValue()));
    }

    private static CrosshairSpread getCrosshairSpread(boolean inaccuracy) {
        GunSpread gunSpread = Crosshair.getGunSpread(gunData.getInaccuracy());
        float base = gunSpread.spreadData().stand();
        float move = gunSpread.spreadData().move();
        float sneak = gunSpread.spreadData().sneak();
        float lie = gunSpread.spreadData().lie();
        return new CrosshairSpread(new SpreadData(Math.max(base, 0.001f), move / base, inaccuracy ? 0.7f : sneak / base, inaccuracy ? 0.5f : lie / base));
    }

    private static CrosshairSpread getCrosshairSpread() {
        GunSpread gunSpread = Crosshair.getGunSpread(gunData.getInaccuracy());
        float base = gunSpread.spreadData().stand();
        float move = gunSpread.spreadData().move();
        float sneak = gunSpread.spreadData().sneak();
        float lie = gunSpread.spreadData().lie();
        return new CrosshairSpread(new SpreadData(Math.max(base, 0.001f), move / base, sneak / base, lie / base));
    }

    static {
        lastSpread = 0.0f;
        deltaTime = new DeltaTime();
    }
}

