/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.hud.crosshair;

import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.txttext.taczlabs.config.fileconfig.HudConfig;
import com.txttext.taczlabs.event.shoot.PlayerFireHandler;
import com.txttext.taczlabs.hud.crosshair.CrosshairRenderer;
import com.txttext.taczlabs.hud.crosshair.CrosshairType;
import com.txttext.taczlabs.hud.crosshair.GunSpread;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class Crosshair {
    private static float lastSpread = 0.0f;
    public static GunData gunData = null;

    public static void renderCrosshair(GuiGraphics graphics, CrosshairType type, float x, float y, ClientGunIndex gunIndex, LocalPlayer player) {
        float spread = Crosshair.getSpread(type, gunIndex, player, (Boolean)HudConfig.inaccuracySpread.get());
        switch (type) {
            case CROSSHAIR: {
                CrosshairRenderer.drawCrosshair(x, y, spread);
                break;
            }
            case RECT: {
                CrosshairRenderer.drawRectCrosshair(x, y, spread);
                break;
            }
            case RIGHT_ANGLE: {
                CrosshairRenderer.drawRightAngleCrosshair(x, y, spread);
                break;
            }
            case ARC: {
                CrosshairRenderer.drawArcCrosshair(graphics, x, y, spread);
                break;
            }
            case POINT: {
                CrosshairRenderer.drawDot(x, y);
                break;
            }
            default: {
                CrosshairRenderer.drawCrosshair(x, y, spread);
            }
        }
    }

    private static float getSpread(CrosshairType type, ClientGunIndex gunIndex, LocalPlayer player, boolean inaccuracy) {
        float spread;
        gunData = gunIndex.getGunData();
        GunSpread gunSpread = Crosshair.getGunSpread(gunData.getInaccuracy());
        float base = Math.max(gunSpread.stand(), 0.001f);
        float move = gunSpread.move() / base;
        float sneak = inaccuracy ? 0.7f : gunSpread.sneak() / base;
        float lie = inaccuracy ? 0.5f : gunSpread.lie() / base;
        InaccuracyType playerStatus = InaccuracyType.getInaccuracyType((LivingEntity)player);
        float status = switch (playerStatus) {
            case InaccuracyType.SNEAK -> sneak;
            case InaccuracyType.LIE -> lie;
            default -> 1.0f;
        };
        float speed = (float)player.m_20184_().m_165924_();
        float speedFactor = !inaccuracy ? Mth.m_14036_((float)speed, (float)0.0f, (float)1.0f) * 20.0f : 0.0f;
        float raw = speed > 0.01f ? move * 2.0f : 1.0f;
        float radius = Crosshair.getRadius(type);
        float baseSpread = radius * status * raw;
        float fireSpread = PlayerFireHandler.getFireSpread();
        float targetSpread = Math.min(baseSpread + speedFactor, radius + (float)((Integer)HudConfig.maxSpread.get()).intValue()) + fireSpread;
        PlayerFireHandler.setFireSpread(Mth.m_14179_((float)0.15f, (float)fireSpread, (float)0.0f));
        float tickDelta = Minecraft.m_91087_().m_91297_();
        float smoothing = (float)((Integer)HudConfig.animSpeed.get()).intValue() / 10.0f;
        float lerpAlpha = 1.0f - (float)Math.exp(-smoothing * tickDelta);
        lastSpread = spread = Mth.m_14179_((float)lerpAlpha, (float)lastSpread, (float)targetSpread);
        return spread;
    }

    private static float getRadius(CrosshairType type) {
        return switch (type) {
            case CrosshairType.CROSSHAIR -> ((Integer)HudConfig.crosshairRadius.get()).intValue();
            case CrosshairType.RECT -> ((Integer)HudConfig.rectCrosshairRadius.get()).intValue();
            case CrosshairType.RIGHT_ANGLE -> ((Integer)HudConfig.rightAngleCrosshairRadius.get()).intValue();
            default -> ((Integer)HudConfig.crosshairRadius.get()).intValue();
        };
    }

    private static GunSpread getGunSpread(Map<InaccuracyType, Float> map) {
        float stand = map.getOrDefault(InaccuracyType.STAND, Float.valueOf(1.0f)).floatValue();
        return new GunSpread(stand, map.getOrDefault(InaccuracyType.MOVE, Float.valueOf(stand)).floatValue(), map.getOrDefault(InaccuracyType.SNEAK, Float.valueOf(stand)).floatValue(), map.getOrDefault(InaccuracyType.LIE, Float.valueOf(stand)).floatValue());
    }

    private static void normalizeSpread() {
    }
}

