/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.hud.crosshair;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.txttext.taczlabs.config.fileconfig.HudConfig;
import com.txttext.taczlabs.hud.crosshair.Line;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class CrosshairRenderer {
    public static void drawRect(float x1, float y1, float x2, float y2, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        List<Float> argb = CrosshairRenderer.Argb(color);
        float a = argb.get(0).floatValue();
        float r = argb.get(1).floatValue();
        float g = argb.get(2).floatValue();
        float b = argb.get(3).floatValue();
        float left = Math.min(x1, x2);
        float right = Math.max(x1, x2);
        float top = Math.min(y1, y2);
        float bottom = Math.max(y1, y2);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)left, (double)bottom, 0.0).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)right, (double)bottom, 0.0).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)right, (double)top, 0.0).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)left, (double)top, 0.0).m_85950_(r, g, b, a).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawArc(PoseStack poseStack, double cx, double cy, double radius, float startAngle, float endAngle, int segments, int color) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        List<Float> argb = CrosshairRenderer.Argb(color);
        float a = argb.get(0).floatValue();
        float r = argb.get(1).floatValue();
        float g = argb.get(2).floatValue();
        float b = argb.get(3).floatValue();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= segments; ++i) {
            float angle = startAngle + (endAngle - startAngle) * (float)i / (float)segments;
            double x = cx + Math.cos(Math.toRadians(angle)) * radius;
            double y = cy + Math.sin(Math.toRadians(angle)) * radius;
            buffer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawLineWithShadow(List<Line> lines, int shadowColor) {
        for (Line l : lines) {
            CrosshairRenderer.drawRect(l.x1() + (float)((Integer)HudConfig.shadowOffset.get()).intValue() / 2.0f, l.y1() + (float)((Integer)HudConfig.shadowOffset.get()).intValue() / 2.0f, l.x2() + (float)((Integer)HudConfig.shadowOffset.get()).intValue() / 2.0f, l.y2() + (float)((Integer)HudConfig.shadowOffset.get()).intValue() / 2.0f, shadowColor);
        }
        for (Line l : lines) {
            CrosshairRenderer.drawRect(l.x1(), l.y1(), l.x2(), l.y2(), (Integer)HudConfig.color.get());
        }
    }

    public static void drawLineWithShadow(List<Line> lines) {
        CrosshairRenderer.drawLineWithShadow(lines, ((Integer)HudConfig.shadowAlpha.get() & 0xFF) << 24);
    }

    public static void drawArcWithShadow() {
    }

    public static void drawCrosshair(float x, float y, float spread) {
        float lineLength = ((Integer)HudConfig.crosshairLength.get()).intValue();
        float lineWidth = (float)((Integer)HudConfig.crosshairWidth.get()).intValue() / 2.0f;
        List<Line> lines = List.of(new Line(x - lineWidth, y + spread, x + lineWidth, y + spread + lineLength), new Line(x - lineWidth, y - spread - lineLength, x + lineWidth, y - spread), new Line(x - lineLength - spread, y - lineWidth, x - spread, y + lineWidth), new Line(x + spread, y - lineWidth, x + lineLength + spread, y + lineWidth));
        CrosshairRenderer.drawLineWithShadow(lines);
        CrosshairRenderer.drawDot(x, y);
    }

    public static void drawRightAngleCrosshair(float x, float y, float spread) {
        float lineLength1 = 5.0f;
        float lineLength2 = 4.0f;
        float lineLength3 = 0.5f;
        float lineWidth = (float)((Integer)HudConfig.rightAngleCrosshairWidth.get()).intValue() / 2.0f;
        List<Line> lines = List.of(new Line(x + spread + lineLength1, y, x + spread, y - lineWidth), new Line(x + spread + lineWidth, y + lineLength2, x + spread, y), new Line(x + lineLength3 + lineWidth, y + lineLength2, x + lineLength3, y + 1.0f), new Line(x + lineLength3, y + lineWidth + 1.0f, x - lineLength3, y + 1.0f), new Line(x - lineLength3, y + lineLength2, x - lineLength3 - lineWidth, y + 1.0f), new Line(x - spread, y + lineLength2, x - spread - lineWidth, y), new Line(x - spread, y, x - spread - lineLength1, y - lineWidth));
        CrosshairRenderer.drawLineWithShadow(lines);
    }

    public static void drawRectCrosshair(float x, float y, float spread) {
        float lineLength = ((Integer)HudConfig.rectCrosshairLength.get()).intValue();
        float lineWidth = ((Integer)HudConfig.rectCrosshairWidth.get()).intValue();
        List<Line> lines = List.of(new Line(x - lineLength, y - spread, x + lineLength, y - spread + lineWidth), new Line(x - lineLength, y + spread - lineWidth, x + lineLength, y + spread), new Line(x - spread, y - lineLength, x - spread + lineWidth, y + lineLength), new Line(x + spread - lineWidth, y - lineLength, x + spread, y + lineLength));
        CrosshairRenderer.drawLineWithShadow(lines);
        CrosshairRenderer.drawDot(x, y);
    }

    public static void drawArcCrosshair(GuiGraphics graphics, float x, float y, float spread) {
        int color = -1;
        PoseStack poseStack = graphics.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        CrosshairRenderer.drawDot(x, y);
        CrosshairRenderer.drawArc(poseStack, x - 6.0f, y, 5.0, 180.0f, 360.0f, 32, color);
        CrosshairRenderer.drawArc(poseStack, x + 6.0f, y, 5.0, 0.0f, 180.0f, 32, color);
    }

    public static void drawDot(float x, float y) {
        List<Line> lines = List.of(new Line(x - 0.5f, y - 0.5f, x + 0.5f, y + 0.5f));
        CrosshairRenderer.drawLineWithShadow(lines);
    }

    public static void drawDot2(float x, float y) {
        List<Line> lines = List.of(new Line(x - 0.5f, y - 1.0f, x + 0.5f, y + 1.0f), new Line(x - 1.0f, y - 0.5f, x + 1.0f, y + 0.5f));
        CrosshairRenderer.drawLineWithShadow(lines);
    }

    public static List<Float> Argb(int color) {
        return List.of(Float.valueOf((float)(color >> 24 & 0xFF) / 255.0f), Float.valueOf((float)(color >> 16 & 0xFF) / 255.0f), Float.valueOf((float)(color >> 8 & 0xFF) / 255.0f), Float.valueOf((float)(color & 0xFF) / 255.0f));
    }
}

