/*
 * Decompiled with CFR 0.152.
 */
package com.txttext.taczlabs.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FallTracker {
    private static final Map<UUID, FallInfo> playerFallInfo = new HashMap<UUID, FallInfo>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().m_5776_() || event.phase != TickEvent.Phase.END) {
            return;
        }
        UUID uuid = player.m_20148_();
        double y = player.m_20186_();
        boolean isFalling = !player.m_20096_() && player.m_20184_().f_82480_ < 0.0;
        FallTracker.updateFall(uuid, y, isFalling);
    }

    public static void updateFall(UUID uuid, double currentY, boolean isFalling) {
        if (isFalling) {
            FallInfo info = playerFallInfo.getOrDefault(uuid, new FallInfo());
            if (info.ticksFalling == 0) {
                info.startY = currentY;
            }
            ++info.ticksFalling;
            info.currentY = currentY;
            playerFallInfo.put(uuid, info);
        } else {
            playerFallInfo.remove(uuid);
        }
    }

    public static FallInfo getFallInfo(UUID uuid) {
        return playerFallInfo.get(uuid);
    }

    public static boolean isFalling(UUID uuid) {
        return playerFallInfo.containsKey(uuid);
    }

    public static class FallInfo {
        public int ticksFalling;
        public double startY;
        public double currentY;

        public double getFallDistance() {
            return this.startY - this.currentY;
        }
    }
}

