/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.entity;

import net.mcreator.thecrusader.entity.GoblinEntity;
import net.mcreator.thecrusader.init.TheCrusaderModEntities;
import net.mcreator.thecrusader.init.TheCrusaderModItems;
import net.mcreator.thecrusader.procedures.AttackPreyConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DirewolfEntity
extends Animal {
    public DirewolfEntity(EntityType<DirewolfEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, GoblinEntity.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, false, false){

            public boolean canUse() {
                double x = DirewolfEntity.this.getX();
                double y = DirewolfEntity.this.getY();
                double z = DirewolfEntity.this.getZ();
                DirewolfEntity entity = DirewolfEntity.this;
                Level world = DirewolfEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(14, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, -1.0, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wolf.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wolf.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wolf.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wolf.death"));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        DirewolfEntity retval = (DirewolfEntity)((EntityType)TheCrusaderModEntities.DIREWOLF.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)((ItemLike)TheCrusaderModItems.CHEESY_HOTDOG.get())).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.5f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TheCrusaderModEntities.DIREWOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 60.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }
}

