/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.entity;

import io.netty.buffer.Unpooled;
import net.mcreator.thecrusader.init.TheCrusaderModEntities;
import net.mcreator.thecrusader.procedures.AttackPreyConditionProcedure;
import net.mcreator.thecrusader.procedures.UtahraptorAggressiveProcedure;
import net.mcreator.thecrusader.procedures.UtahraptorAttackTargetProcedure;
import net.mcreator.thecrusader.procedures.UtahraptorFollowProcedure;
import net.mcreator.thecrusader.procedures.UtahraptorRightClickedOnEntityProcedure;
import net.mcreator.thecrusader.procedures.UtahraptorThisEntityKillsAnotherOneProcedure;
import net.mcreator.thecrusader.world.inventory.UtahraptorInventoryMenu;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;

public class UtahraptorEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_TamingProgress = SynchedEntityData.defineId(UtahraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_MovementMode = SynchedEntityData.defineId(UtahraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_AgressionLvl = SynchedEntityData.defineId(UtahraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_FeddingInterval = SynchedEntityData.defineId(UtahraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_BabyGrowth = SynchedEntityData.defineId(UtahraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemStackHandler inventory = new ItemStackHandler(this, 16){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public UtahraptorEntity(EntityType<UtahraptorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TamingProgress, (Object)0);
        builder.define(DATA_MovementMode, (Object)"");
        builder.define(DATA_AgressionLvl, (Object)"");
        builder.define(DATA_FeddingInterval, (Object)0);
        builder.define(DATA_BabyGrowth, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canUse() && UtahraptorFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canContinueToUse() && UtahraptorFollowProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(7, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(8, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canUse() && UtahraptorAttackTargetProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canContinueToUse() && UtahraptorAttackTargetProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, false, false){

            public boolean canUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, CaveSpider.class, false, false){

            public boolean canUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canUse() && AttackPreyConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, false){

            public boolean canUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canUse() && UtahraptorAggressiveProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = UtahraptorEntity.this.getX();
                double y = UtahraptorEntity.this.getY();
                double z = UtahraptorEntity.this.getZ();
                UtahraptorEntity entity = UtahraptorEntity.this;
                Level world = UtahraptorEntity.this.level();
                return super.canContinueToUse() && UtahraptorAggressiveProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(14, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, -0.5, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"the_crusader:utahraptor.call"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"the_crusader:utahraptor_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"the_crusader:utahraptor_death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public CombinedInvWrapper getCombinedInventory() {
        return this.combined;
    }

    protected void dropEquipment(ServerLevel serverLevel) {
        super.dropEquipment(serverLevel);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(serverLevel, itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataTamingProgress", ((Integer)this.entityData.get(DATA_TamingProgress)).intValue());
        compound.putString("DataMovementMode", (String)this.entityData.get(DATA_MovementMode));
        compound.putString("DataAgressionLvl", (String)this.entityData.get(DATA_AgressionLvl));
        compound.putInt("DataFeddingInterval", ((Integer)this.entityData.get(DATA_FeddingInterval)).intValue());
        compound.putInt("DataBabyGrowth", ((Integer)this.entityData.get(DATA_BabyGrowth)).intValue());
        compound.put("InventoryCustom", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        Tag tag;
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataTamingProgress")) {
            this.entityData.set(DATA_TamingProgress, (Object)compound.getInt("DataTamingProgress"));
        }
        if (compound.contains("DataMovementMode")) {
            this.entityData.set(DATA_MovementMode, (Object)compound.getString("DataMovementMode"));
        }
        if (compound.contains("DataAgressionLvl")) {
            this.entityData.set(DATA_AgressionLvl, (Object)compound.getString("DataAgressionLvl"));
        }
        if (compound.contains("DataFeddingInterval")) {
            this.entityData.set(DATA_FeddingInterval, (Object)compound.getInt("DataFeddingInterval"));
        }
        if (compound.contains("DataBabyGrowth")) {
            this.entityData.set(DATA_BabyGrowth, (Object)compound.getInt("DataBabyGrowth"));
        }
        if ((tag = compound.get("InventoryCustom")) instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)tag;
            this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), inventoryTag);
        }
    }

    public InteractionResult mobInteract(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        if (sourceentity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Utahraptor");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(sourceentity.blockPosition());
                    packetBuffer.writeByte(0);
                    packetBuffer.writeVarInt(UtahraptorEntity.this.getId());
                    return new UtahraptorInventoryMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.writeBlockPos(sourceentity.blockPosition());
                buf.writeByte(0);
                buf.writeVarInt(this.getId());
            });
        }
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        UtahraptorEntity entity = this;
        Level world = this.level();
        UtahraptorRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void awardKillScore(Entity entity, DamageSource damageSource) {
        super.awardKillScore(entity, damageSource);
        UtahraptorThisEntityKillsAnotherOneProcedure.execute(entity);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        UtahraptorEntity retval = (UtahraptorEntity)((EntityType)TheCrusaderModEntities.UTAHRAPTOR.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((HolderSet)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.ITEM, (TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"the_crusader:insectivore_foods")))).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TheCrusaderModEntities.UTAHRAPTOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        return builder;
    }
}

