/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.init;

import java.util.List;
import java.util.stream.Collectors;
import net.mcreator.thecrusader.init.TheCrusaderModEntities;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheCrusaderModAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ATTRIBUTE, (String)"the_crusader");
    public static final DeferredHolder<Attribute, Attribute> NUMERICAL_SIZE = REGISTRY.register("numerical_size", () -> new RangedAttribute("attribute.the_crusader.numerical_size", 0.0, 0.0, 600.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> STALKING_AGE = REGISTRY.register("stalking_age", () -> new RangedAttribute("attribute.the_crusader.stalking_age", 0.0, 0.0, 100.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> HUNGER_METER = REGISTRY.register("hunger_meter", () -> new RangedAttribute("attribute.the_crusader.hunger_meter", 72000.0, 0.0, 72000.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> WEIGHT = REGISTRY.register("weight", () -> new RangedAttribute("attribute.the_crusader.weight", 5.0, 0.0, 100.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> VILLAGER_SANITY = REGISTRY.register("villager_sanity", () -> new RangedAttribute("attribute.the_crusader.villager_sanity", 1000.0, -1000.0, 1000.0).setSyncable(true).setSentiment(Attribute.Sentiment.NEGATIVE));
    public static final DeferredHolder<Attribute, Attribute> MAX_MANA = REGISTRY.register("max_mana", () -> new RangedAttribute("attribute.the_crusader.max_mana", 0.0, 0.0, 1.0E8).setSyncable(true));

    @SubscribeEvent
    public static void addAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().forEach(entity -> event.add(entity, NUMERICAL_SIZE));
        List.of((EntityType)TheCrusaderModEntities.SHADOW_ATRONACH.get()).stream().filter(DefaultAttributes::hasSupplier).map(entityType -> entityType).collect(Collectors.toList()).forEach(entity -> event.add(entity, STALKING_AGE));
        List.of((EntityType)TheCrusaderModEntities.UTAHRAPTOR.get(), (EntityType)TheCrusaderModEntities.DIREWOLF.get()).stream().filter(DefaultAttributes::hasSupplier).map(entityType -> entityType).collect(Collectors.toList()).forEach(entity -> event.add(entity, HUNGER_METER));
        event.add(EntityType.PLAYER, WEIGHT);
        List.of(EntityType.VILLAGER).stream().filter(DefaultAttributes::hasSupplier).map(entityType -> entityType).collect(Collectors.toList()).forEach(entity -> event.add(entity, VILLAGER_SANITY));
        event.add(EntityType.PLAYER, MAX_MANA);
    }
}

