/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.init;

import net.mcreator.thecrusader.potion.AngerMobEffect;
import net.mcreator.thecrusader.potion.CorrosionMobEffect;
import net.mcreator.thecrusader.potion.HolyAuraMobEffect;
import net.mcreator.thecrusader.potion.InfernalWrathMobEffect;
import net.mcreator.thecrusader.potion.IronStomachMobEffect;
import net.mcreator.thecrusader.potion.MilkingCooldownMobEffect;
import net.mcreator.thecrusader.potion.PluckingCooldownMobEffect;
import net.mcreator.thecrusader.potion.PoisonResistanceMobEffect;
import net.mcreator.thecrusader.potion.UnconsiousMobEffect;
import net.mcreator.thecrusader.potion.WebbedMobEffect;
import net.mcreator.thecrusader.procedures.IronStomachEffectStartedappliedProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TheCrusaderModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_crusader");
    public static final DeferredHolder<MobEffect, MobEffect> PLUCKING_COOLDOWN = REGISTRY.register("plucking_cooldown", () -> new PluckingCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> WEBBED = REGISTRY.register("webbed", () -> new WebbedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> POISON_RESISTANCE = REGISTRY.register("poison_resistance", () -> new PoisonResistanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HOLY_AURA = REGISTRY.register("holy_aura", () -> new HolyAuraMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INFERNAL_WRATH = REGISTRY.register("infernal_wrath", () -> new InfernalWrathMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IRON_STOMACH = REGISTRY.register("iron_stomach", () -> new IronStomachMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MILKING_COOLDOWN = REGISTRY.register("milking_cooldown", () -> new MilkingCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ANGER = REGISTRY.register("anger", () -> new AngerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CORROSION = REGISTRY.register("corrosion", () -> new CorrosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> UNCONSIOUS = REGISTRY.register("unconsious", () -> new UnconsiousMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheCrusaderModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheCrusaderModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(IRON_STOMACH)) {
            IronStomachEffectStartedappliedProcedure.execute(entity);
        }
    }
}

