/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.network;

import java.util.HashMap;
import net.mcreator.thecrusader.TheCrusaderMod;
import net.mcreator.thecrusader.procedures.AcrobatSelectedProcedure;
import net.mcreator.thecrusader.procedures.ArcherSelectedProcedure;
import net.mcreator.thecrusader.procedures.AssassinSelectedProcedure;
import net.mcreator.thecrusader.procedures.BarbarianSelectedProcedure;
import net.mcreator.thecrusader.procedures.BardSelectedProcedure;
import net.mcreator.thecrusader.procedures.BattlemageSelectedProcedure;
import net.mcreator.thecrusader.procedures.BurglarSelectedProcedure;
import net.mcreator.thecrusader.procedures.HealerSelectedProcedure;
import net.mcreator.thecrusader.procedures.KnightSelectedProcedure;
import net.mcreator.thecrusader.procedures.MageSelectedProcedure;
import net.mcreator.thecrusader.procedures.MonkSelectedProcedure;
import net.mcreator.thecrusader.procedures.NightbladeSelectedProcedure;
import net.mcreator.thecrusader.procedures.RangerSelectedProcedure;
import net.mcreator.thecrusader.procedures.RogueSelectedProcedure;
import net.mcreator.thecrusader.procedures.ScorcerorSelectedProcedure;
import net.mcreator.thecrusader.procedures.SpellswordSelectedProcedure;
import net.mcreator.thecrusader.procedures.ThiefSelectedProcedure;
import net.mcreator.thecrusader.procedures.WarriorSelectedProcedure;
import net.mcreator.thecrusader.world.inventory.ClassSelectionScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ClassSelectionScreenButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClassSelectionScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_crusader", (String)"class_selection_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClassSelectionScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ClassSelectionScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ClassSelectionScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ClassSelectionScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ClassSelectionScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ClassSelectionScreenMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BarbarianSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ArcherSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            KnightSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MonkSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            RangerSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            WarriorSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            BattlemageSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            AcrobatSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            AssassinSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BardSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            RogueSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            ThiefSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            NightbladeSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            MageSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            HealerSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            ScorcerorSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            SpellswordSelectedProcedure.execute((Entity)entity);
        }
        if (buttonID == 17) {
            BurglarSelectedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheCrusaderMod.addNetworkMessage(TYPE, STREAM_CODEC, ClassSelectionScreenButtonMessage::handleData);
    }
}

