/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.network;

import java.util.HashMap;
import net.mcreator.thecrusader.TheCrusaderMod;
import net.mcreator.thecrusader.procedures.RaceSelectGoBackProcedure;
import net.mcreator.thecrusader.procedures.SubterraneanDaedronSelectedProcedure;
import net.mcreator.thecrusader.world.inventory.SubterraneanDaedronSelectScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SubterraneanDaedronSelectScreenButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SubterraneanDaedronSelectScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_crusader", (String)"subterranean_daedron_select_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SubterraneanDaedronSelectScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SubterraneanDaedronSelectScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SubterraneanDaedronSelectScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SubterraneanDaedronSelectScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                SubterraneanDaedronSelectScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = SubterraneanDaedronSelectScreenMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SubterraneanDaedronSelectedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            RaceSelectGoBackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheCrusaderMod.addNetworkMessage(TYPE, STREAM_CODEC, SubterraneanDaedronSelectScreenButtonMessage::handleData);
    }
}

