/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.network;

import java.util.function.Supplier;
import net.mcreator.thecrusader.TheCrusaderMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheCrusaderModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"the_crusader");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheCrusaderMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        TheCrusaderMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_crusader", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_crusader", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public String Race = "\"None\"";
        public String FactionRank = "\"None\"";
        public double FactionRankGrade = 0.0;
        public double VillagerPraise = 0.0;
        public double IllagerTargeting = 0.0;
        public String Faction = "\"None\"";
        public String ActiveAbility = "\"None\"";
        public double IllagersSlain = 0.0;
        public double ElementalCharge = 0.0;
        public double huntersinstinctcountdown = 72000.0;
        public boolean Hunter = false;
        public boolean Daedric = false;
        public double BaseStamina = 200.0;
        public double CurrentStamina = 200.0;
        public double Strength = 0.0;
        public double Intelligence = 0.0;
        public String HomeBiome = "\"None\"";
        public double Level = 1.0;
        public double PassiveInventoryFillTimer = 1200.0;
        public boolean Amphibious = false;
        public double CurrentMana = 0.0;
        public String CharacterClass = "\"None\"";
        public double Willpower = 0.0;
        public double Agility = 0.0;
        public double Speed = 0.0;
        public double Endurance = 0.0;
        public double Personality = 0.0;
        public double Luck = 50.0;
        public double Progresstonextlevel = 0.0;
        public double ShortbladeSkillStatus = 0.0;
        public double ShortbladeSkillLevel = 5.0;
        public double RacialAbilityCooldown = 0.0;
        public double MaximumCarryWeight = 0.0;
        public double CurrentCarryWeight = 0.0;
        public double Fear = 0.0;
        public double ScurvyCountdown = 80000.0;
        public double ScurvyStage = 0.0;
        public double MaxScurvyCountdown = 80000.0;
        public double AttributePoints = 0.0;
        public double hydrationcountdown = 6000.0;
        public double hydrationsaturation = 0.0;
        public double hydration = 20.0;
        public double MaxHydration = 20.0;
        public double shortblade_skill_progression = 0.0;
        public double archery_skill_level = 5.0;
        public double archery_skill_progression = 0.0;
        public double heavy_armor_level = 5.0;
        public double archery_skill_status = 0.0;
        public double heavy_armor_skill_progression = 5.0;
        public double block_skill = 5.0;
        public double block_skill_progression = 0.0;
        public double block_skill_status = 0.0;
        public double LongBladeSkillLevel = 5.0;
        public double LongBladeSkillProgress = 0.0;
        public double LongBladeSkillStatus = 0.0;
        public double HeavyArmorStatus = 0.0;
        public double MediumArmorSkillLevel = 5.0;
        public double MediumArmorSkillProgress = 0.0;
        public double MediumArmorStatus = 0.0;
        public double LightArmorSkillLevel = 5.0;
        public double LightArmorSkillProgress = 0.0;
        public double LightArmorSkillStatus = 0.0;
        public double NoArmorSkillLevel = 5.0;
        public double NoArmorSkillProgress = 0.0;
        public double NoArmorSkillStatus = 0.0;
        public double AxeSkillProgress = 0.0;
        public double AxeSkillLevel = 5.0;
        public double AxeSkillStatus = 0.0;
        public double PolearmSkillLevel = 5.0;
        public double PolearmSkillProgress = 0.0;
        public double PolearmSkillStatus = 0.0;
        public double BludgeonSkillLevel = 5.0;
        public double BludgeonSkillProgress = 0.0;
        public double BludgeonSkillStatus = 0.0;
        public double SmithingSkillLevel = 5.0;
        public double JumpingSkillLevel = 5.0;
        public double JumpingSkillProgress = 0.0;
        public double JumpingSkillStatus = 0.0;
        public double MedicalSkillLevel = 5.0;
        public double MedicalSkillProgress = 0.0;
        public double MedicalSkillStatus = 0.0;
        public double Bounty = 0.0;
        public double Reward = 0.0;
        public double SmithingSkillProgress = 0.0;
        public double DestructionSkillLevel = 5.0;
        public double DestructionSkillProgress = 0.0;
        public double DestructionSkillStatus = 0.0;
        public double CursePoints = 0.0;
        public double ConjurationSkillLevel = 5.0;
        public double TrenchFootAccumulation = 0.0;
        public String ActivePower = "\"Unknown\"";
        public boolean BasicRaceSkillUnlocked = false;
        public boolean ResistArrest = false;
        public double daysuntilfreedom = 0.0;
        public boolean ShieldForbidden = false;
        public boolean AxesForbidden = false;
        public boolean BucklersOnly = false;
        public double SmithingSkillStatus = 0.0;
        public double HeartContainersUsed = 0.0;
        public boolean AglitySpecialization = false;
        public String Demon = "\"None\"";
        public boolean HasBedbugs = false;
        public boolean Fiery = false;
        public double totemcooldown = 0.0;
        public double StealthSkillLevel = 5.0;
        public double SteathSkillProgress = 0.0;
        public double StealthSkillStatus = 0.0;
        public double MysticalSkillLevel = 5.0;
        public double MtsticalSkillProgress = 0.0;
        public double MysticalSkillStatus = 0.0;
        public double MiningSkillLevel = 5.0;
        public double MiningSkillProgress = 0.0;
        public double MiningSkillStatus = 0.0;
        public boolean Spellcaster = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("Race", this.Race);
            nbt.putString("FactionRank", this.FactionRank);
            nbt.putDouble("FactionRankGrade", this.FactionRankGrade);
            nbt.putDouble("VillagerPraise", this.VillagerPraise);
            nbt.putDouble("IllagerTargeting", this.IllagerTargeting);
            nbt.putString("Faction", this.Faction);
            nbt.putString("ActiveAbility", this.ActiveAbility);
            nbt.putDouble("IllagersSlain", this.IllagersSlain);
            nbt.putDouble("ElementalCharge", this.ElementalCharge);
            nbt.putDouble("huntersinstinctcountdown", this.huntersinstinctcountdown);
            nbt.putBoolean("Hunter", this.Hunter);
            nbt.putBoolean("Daedric", this.Daedric);
            nbt.putDouble("BaseStamina", this.BaseStamina);
            nbt.putDouble("CurrentStamina", this.CurrentStamina);
            nbt.putDouble("Strength", this.Strength);
            nbt.putDouble("Intelligence", this.Intelligence);
            nbt.putString("HomeBiome", this.HomeBiome);
            nbt.putDouble("Level", this.Level);
            nbt.putDouble("PassiveInventoryFillTimer", this.PassiveInventoryFillTimer);
            nbt.putBoolean("Amphibious", this.Amphibious);
            nbt.putDouble("CurrentMana", this.CurrentMana);
            nbt.putString("CharacterClass", this.CharacterClass);
            nbt.putDouble("Willpower", this.Willpower);
            nbt.putDouble("Agility", this.Agility);
            nbt.putDouble("Speed", this.Speed);
            nbt.putDouble("Endurance", this.Endurance);
            nbt.putDouble("Personality", this.Personality);
            nbt.putDouble("Luck", this.Luck);
            nbt.putDouble("Progresstonextlevel", this.Progresstonextlevel);
            nbt.putDouble("ShortbladeSkillStatus", this.ShortbladeSkillStatus);
            nbt.putDouble("ShortbladeSkillLevel", this.ShortbladeSkillLevel);
            nbt.putDouble("RacialAbilityCooldown", this.RacialAbilityCooldown);
            nbt.putDouble("MaximumCarryWeight", this.MaximumCarryWeight);
            nbt.putDouble("CurrentCarryWeight", this.CurrentCarryWeight);
            nbt.putDouble("Fear", this.Fear);
            nbt.putDouble("ScurvyCountdown", this.ScurvyCountdown);
            nbt.putDouble("ScurvyStage", this.ScurvyStage);
            nbt.putDouble("MaxScurvyCountdown", this.MaxScurvyCountdown);
            nbt.putDouble("AttributePoints", this.AttributePoints);
            nbt.putDouble("hydrationcountdown", this.hydrationcountdown);
            nbt.putDouble("hydrationsaturation", this.hydrationsaturation);
            nbt.putDouble("hydration", this.hydration);
            nbt.putDouble("MaxHydration", this.MaxHydration);
            nbt.putDouble("shortblade_skill_progression", this.shortblade_skill_progression);
            nbt.putDouble("archery_skill_level", this.archery_skill_level);
            nbt.putDouble("archery_skill_progression", this.archery_skill_progression);
            nbt.putDouble("heavy_armor_level", this.heavy_armor_level);
            nbt.putDouble("archery_skill_status", this.archery_skill_status);
            nbt.putDouble("heavy_armor_skill_progression", this.heavy_armor_skill_progression);
            nbt.putDouble("block_skill", this.block_skill);
            nbt.putDouble("block_skill_progression", this.block_skill_progression);
            nbt.putDouble("block_skill_status", this.block_skill_status);
            nbt.putDouble("LongBladeSkillLevel", this.LongBladeSkillLevel);
            nbt.putDouble("LongBladeSkillProgress", this.LongBladeSkillProgress);
            nbt.putDouble("LongBladeSkillStatus", this.LongBladeSkillStatus);
            nbt.putDouble("HeavyArmorStatus", this.HeavyArmorStatus);
            nbt.putDouble("MediumArmorSkillLevel", this.MediumArmorSkillLevel);
            nbt.putDouble("MediumArmorSkillProgress", this.MediumArmorSkillProgress);
            nbt.putDouble("MediumArmorStatus", this.MediumArmorStatus);
            nbt.putDouble("LightArmorSkillLevel", this.LightArmorSkillLevel);
            nbt.putDouble("LightArmorSkillProgress", this.LightArmorSkillProgress);
            nbt.putDouble("LightArmorSkillStatus", this.LightArmorSkillStatus);
            nbt.putDouble("NoArmorSkillLevel", this.NoArmorSkillLevel);
            nbt.putDouble("NoArmorSkillProgress", this.NoArmorSkillProgress);
            nbt.putDouble("NoArmorSkillStatus", this.NoArmorSkillStatus);
            nbt.putDouble("AxeSkillProgress", this.AxeSkillProgress);
            nbt.putDouble("AxeSkillLevel", this.AxeSkillLevel);
            nbt.putDouble("AxeSkillStatus", this.AxeSkillStatus);
            nbt.putDouble("PolearmSkillLevel", this.PolearmSkillLevel);
            nbt.putDouble("PolearmSkillProgress", this.PolearmSkillProgress);
            nbt.putDouble("PolearmSkillStatus", this.PolearmSkillStatus);
            nbt.putDouble("BludgeonSkillLevel", this.BludgeonSkillLevel);
            nbt.putDouble("BludgeonSkillProgress", this.BludgeonSkillProgress);
            nbt.putDouble("BludgeonSkillStatus", this.BludgeonSkillStatus);
            nbt.putDouble("SmithingSkillLevel", this.SmithingSkillLevel);
            nbt.putDouble("JumpingSkillLevel", this.JumpingSkillLevel);
            nbt.putDouble("JumpingSkillProgress", this.JumpingSkillProgress);
            nbt.putDouble("JumpingSkillStatus", this.JumpingSkillStatus);
            nbt.putDouble("MedicalSkillLevel", this.MedicalSkillLevel);
            nbt.putDouble("MedicalSkillProgress", this.MedicalSkillProgress);
            nbt.putDouble("MedicalSkillStatus", this.MedicalSkillStatus);
            nbt.putDouble("Bounty", this.Bounty);
            nbt.putDouble("Reward", this.Reward);
            nbt.putDouble("SmithingSkillProgress", this.SmithingSkillProgress);
            nbt.putDouble("DestructionSkillLevel", this.DestructionSkillLevel);
            nbt.putDouble("DestructionSkillProgress", this.DestructionSkillProgress);
            nbt.putDouble("DestructionSkillStatus", this.DestructionSkillStatus);
            nbt.putDouble("CursePoints", this.CursePoints);
            nbt.putDouble("ConjurationSkillLevel", this.ConjurationSkillLevel);
            nbt.putDouble("TrenchFootAccumulation", this.TrenchFootAccumulation);
            nbt.putString("ActivePower", this.ActivePower);
            nbt.putBoolean("BasicRaceSkillUnlocked", this.BasicRaceSkillUnlocked);
            nbt.putBoolean("ResistArrest", this.ResistArrest);
            nbt.putDouble("daysuntilfreedom", this.daysuntilfreedom);
            nbt.putBoolean("ShieldForbidden", this.ShieldForbidden);
            nbt.putBoolean("AxesForbidden", this.AxesForbidden);
            nbt.putBoolean("BucklersOnly", this.BucklersOnly);
            nbt.putDouble("SmithingSkillStatus", this.SmithingSkillStatus);
            nbt.putDouble("HeartContainersUsed", this.HeartContainersUsed);
            nbt.putBoolean("AglitySpecialization", this.AglitySpecialization);
            nbt.putString("Demon", this.Demon);
            nbt.putBoolean("HasBedbugs", this.HasBedbugs);
            nbt.putBoolean("Fiery", this.Fiery);
            nbt.putDouble("totemcooldown", this.totemcooldown);
            nbt.putDouble("StealthSkillLevel", this.StealthSkillLevel);
            nbt.putDouble("SteathSkillProgress", this.SteathSkillProgress);
            nbt.putDouble("StealthSkillStatus", this.StealthSkillStatus);
            nbt.putDouble("MysticalSkillLevel", this.MysticalSkillLevel);
            nbt.putDouble("MtsticalSkillProgress", this.MtsticalSkillProgress);
            nbt.putDouble("MysticalSkillStatus", this.MysticalSkillStatus);
            nbt.putDouble("MiningSkillLevel", this.MiningSkillLevel);
            nbt.putDouble("MiningSkillProgress", this.MiningSkillProgress);
            nbt.putDouble("MiningSkillStatus", this.MiningSkillStatus);
            nbt.putBoolean("Spellcaster", this.Spellcaster);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.Race = nbt.getString("Race");
            this.FactionRank = nbt.getString("FactionRank");
            this.FactionRankGrade = nbt.getDouble("FactionRankGrade");
            this.VillagerPraise = nbt.getDouble("VillagerPraise");
            this.IllagerTargeting = nbt.getDouble("IllagerTargeting");
            this.Faction = nbt.getString("Faction");
            this.ActiveAbility = nbt.getString("ActiveAbility");
            this.IllagersSlain = nbt.getDouble("IllagersSlain");
            this.ElementalCharge = nbt.getDouble("ElementalCharge");
            this.huntersinstinctcountdown = nbt.getDouble("huntersinstinctcountdown");
            this.Hunter = nbt.getBoolean("Hunter");
            this.Daedric = nbt.getBoolean("Daedric");
            this.BaseStamina = nbt.getDouble("BaseStamina");
            this.CurrentStamina = nbt.getDouble("CurrentStamina");
            this.Strength = nbt.getDouble("Strength");
            this.Intelligence = nbt.getDouble("Intelligence");
            this.HomeBiome = nbt.getString("HomeBiome");
            this.Level = nbt.getDouble("Level");
            this.PassiveInventoryFillTimer = nbt.getDouble("PassiveInventoryFillTimer");
            this.Amphibious = nbt.getBoolean("Amphibious");
            this.CurrentMana = nbt.getDouble("CurrentMana");
            this.CharacterClass = nbt.getString("CharacterClass");
            this.Willpower = nbt.getDouble("Willpower");
            this.Agility = nbt.getDouble("Agility");
            this.Speed = nbt.getDouble("Speed");
            this.Endurance = nbt.getDouble("Endurance");
            this.Personality = nbt.getDouble("Personality");
            this.Luck = nbt.getDouble("Luck");
            this.Progresstonextlevel = nbt.getDouble("Progresstonextlevel");
            this.ShortbladeSkillStatus = nbt.getDouble("ShortbladeSkillStatus");
            this.ShortbladeSkillLevel = nbt.getDouble("ShortbladeSkillLevel");
            this.RacialAbilityCooldown = nbt.getDouble("RacialAbilityCooldown");
            this.MaximumCarryWeight = nbt.getDouble("MaximumCarryWeight");
            this.CurrentCarryWeight = nbt.getDouble("CurrentCarryWeight");
            this.Fear = nbt.getDouble("Fear");
            this.ScurvyCountdown = nbt.getDouble("ScurvyCountdown");
            this.ScurvyStage = nbt.getDouble("ScurvyStage");
            this.MaxScurvyCountdown = nbt.getDouble("MaxScurvyCountdown");
            this.AttributePoints = nbt.getDouble("AttributePoints");
            this.hydrationcountdown = nbt.getDouble("hydrationcountdown");
            this.hydrationsaturation = nbt.getDouble("hydrationsaturation");
            this.hydration = nbt.getDouble("hydration");
            this.MaxHydration = nbt.getDouble("MaxHydration");
            this.shortblade_skill_progression = nbt.getDouble("shortblade_skill_progression");
            this.archery_skill_level = nbt.getDouble("archery_skill_level");
            this.archery_skill_progression = nbt.getDouble("archery_skill_progression");
            this.heavy_armor_level = nbt.getDouble("heavy_armor_level");
            this.archery_skill_status = nbt.getDouble("archery_skill_status");
            this.heavy_armor_skill_progression = nbt.getDouble("heavy_armor_skill_progression");
            this.block_skill = nbt.getDouble("block_skill");
            this.block_skill_progression = nbt.getDouble("block_skill_progression");
            this.block_skill_status = nbt.getDouble("block_skill_status");
            this.LongBladeSkillLevel = nbt.getDouble("LongBladeSkillLevel");
            this.LongBladeSkillProgress = nbt.getDouble("LongBladeSkillProgress");
            this.LongBladeSkillStatus = nbt.getDouble("LongBladeSkillStatus");
            this.HeavyArmorStatus = nbt.getDouble("HeavyArmorStatus");
            this.MediumArmorSkillLevel = nbt.getDouble("MediumArmorSkillLevel");
            this.MediumArmorSkillProgress = nbt.getDouble("MediumArmorSkillProgress");
            this.MediumArmorStatus = nbt.getDouble("MediumArmorStatus");
            this.LightArmorSkillLevel = nbt.getDouble("LightArmorSkillLevel");
            this.LightArmorSkillProgress = nbt.getDouble("LightArmorSkillProgress");
            this.LightArmorSkillStatus = nbt.getDouble("LightArmorSkillStatus");
            this.NoArmorSkillLevel = nbt.getDouble("NoArmorSkillLevel");
            this.NoArmorSkillProgress = nbt.getDouble("NoArmorSkillProgress");
            this.NoArmorSkillStatus = nbt.getDouble("NoArmorSkillStatus");
            this.AxeSkillProgress = nbt.getDouble("AxeSkillProgress");
            this.AxeSkillLevel = nbt.getDouble("AxeSkillLevel");
            this.AxeSkillStatus = nbt.getDouble("AxeSkillStatus");
            this.PolearmSkillLevel = nbt.getDouble("PolearmSkillLevel");
            this.PolearmSkillProgress = nbt.getDouble("PolearmSkillProgress");
            this.PolearmSkillStatus = nbt.getDouble("PolearmSkillStatus");
            this.BludgeonSkillLevel = nbt.getDouble("BludgeonSkillLevel");
            this.BludgeonSkillProgress = nbt.getDouble("BludgeonSkillProgress");
            this.BludgeonSkillStatus = nbt.getDouble("BludgeonSkillStatus");
            this.SmithingSkillLevel = nbt.getDouble("SmithingSkillLevel");
            this.JumpingSkillLevel = nbt.getDouble("JumpingSkillLevel");
            this.JumpingSkillProgress = nbt.getDouble("JumpingSkillProgress");
            this.JumpingSkillStatus = nbt.getDouble("JumpingSkillStatus");
            this.MedicalSkillLevel = nbt.getDouble("MedicalSkillLevel");
            this.MedicalSkillProgress = nbt.getDouble("MedicalSkillProgress");
            this.MedicalSkillStatus = nbt.getDouble("MedicalSkillStatus");
            this.Bounty = nbt.getDouble("Bounty");
            this.Reward = nbt.getDouble("Reward");
            this.SmithingSkillProgress = nbt.getDouble("SmithingSkillProgress");
            this.DestructionSkillLevel = nbt.getDouble("DestructionSkillLevel");
            this.DestructionSkillProgress = nbt.getDouble("DestructionSkillProgress");
            this.DestructionSkillStatus = nbt.getDouble("DestructionSkillStatus");
            this.CursePoints = nbt.getDouble("CursePoints");
            this.ConjurationSkillLevel = nbt.getDouble("ConjurationSkillLevel");
            this.TrenchFootAccumulation = nbt.getDouble("TrenchFootAccumulation");
            this.ActivePower = nbt.getString("ActivePower");
            this.BasicRaceSkillUnlocked = nbt.getBoolean("BasicRaceSkillUnlocked");
            this.ResistArrest = nbt.getBoolean("ResistArrest");
            this.daysuntilfreedom = nbt.getDouble("daysuntilfreedom");
            this.ShieldForbidden = nbt.getBoolean("ShieldForbidden");
            this.AxesForbidden = nbt.getBoolean("AxesForbidden");
            this.BucklersOnly = nbt.getBoolean("BucklersOnly");
            this.SmithingSkillStatus = nbt.getDouble("SmithingSkillStatus");
            this.HeartContainersUsed = nbt.getDouble("HeartContainersUsed");
            this.AglitySpecialization = nbt.getBoolean("AglitySpecialization");
            this.Demon = nbt.getString("Demon");
            this.HasBedbugs = nbt.getBoolean("HasBedbugs");
            this.Fiery = nbt.getBoolean("Fiery");
            this.totemcooldown = nbt.getDouble("totemcooldown");
            this.StealthSkillLevel = nbt.getDouble("StealthSkillLevel");
            this.SteathSkillProgress = nbt.getDouble("SteathSkillProgress");
            this.StealthSkillStatus = nbt.getDouble("StealthSkillStatus");
            this.MysticalSkillLevel = nbt.getDouble("MysticalSkillLevel");
            this.MtsticalSkillProgress = nbt.getDouble("MtsticalSkillProgress");
            this.MysticalSkillStatus = nbt.getDouble("MysticalSkillStatus");
            this.MiningSkillLevel = nbt.getDouble("MiningSkillLevel");
            this.MiningSkillProgress = nbt.getDouble("MiningSkillProgress");
            this.MiningSkillStatus = nbt.getDouble("MiningSkillStatus");
            this.Spellcaster = nbt.getBoolean("Spellcaster");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_crusader_mapvars";
        public double ExistingCrusaderWarlords = 0.0;
        public double ExistingLegendaryCrusaders = 0.0;
        public double ExistingCrusaderDeathLusters = 0.0;
        public double ExistingCrusaderChampions = 0.0;
        public double ExistingCrusaderAntiHeroes = 0.0;
        public double ExistingCrusaderHeroes = 0.0;
        public double BaseHP = 0.0;
        public double growth_stages = 10.0;
        public double EventTimer = 540000.0;
        public double sentence = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.ExistingCrusaderWarlords = nbt.getDouble("ExistingCrusaderWarlords");
            this.ExistingLegendaryCrusaders = nbt.getDouble("ExistingLegendaryCrusaders");
            this.ExistingCrusaderDeathLusters = nbt.getDouble("ExistingCrusaderDeathLusters");
            this.ExistingCrusaderChampions = nbt.getDouble("ExistingCrusaderChampions");
            this.ExistingCrusaderAntiHeroes = nbt.getDouble("ExistingCrusaderAntiHeroes");
            this.ExistingCrusaderHeroes = nbt.getDouble("ExistingCrusaderHeroes");
            this.BaseHP = nbt.getDouble("BaseHP");
            this.growth_stages = nbt.getDouble("growth_stages");
            this.EventTimer = nbt.getDouble("EventTimer");
            this.sentence = nbt.getDouble("sentence");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("ExistingCrusaderWarlords", this.ExistingCrusaderWarlords);
            nbt.putDouble("ExistingLegendaryCrusaders", this.ExistingLegendaryCrusaders);
            nbt.putDouble("ExistingCrusaderDeathLusters", this.ExistingCrusaderDeathLusters);
            nbt.putDouble("ExistingCrusaderChampions", this.ExistingCrusaderChampions);
            nbt.putDouble("ExistingCrusaderAntiHeroes", this.ExistingCrusaderAntiHeroes);
            nbt.putDouble("ExistingCrusaderHeroes", this.ExistingCrusaderHeroes);
            nbt.putDouble("BaseHP", this.BaseHP);
            nbt.putDouble("growth_stages", this.growth_stages);
            nbt.putDouble("EventTimer", this.EventTimer);
            nbt.putDouble("sentence", this.sentence);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_crusader_worldvars";
        public double ExistingFlameAcolyteGrandmasters = 0.0;
        public double ExistingFlameAcolyteHighGrandmasters = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.ExistingFlameAcolyteGrandmasters = nbt.getDouble("ExistingFlameAcolyteGrandmasters");
            this.ExistingFlameAcolyteHighGrandmasters = nbt.getDouble("ExistingFlameAcolyteHighGrandmasters");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("ExistingFlameAcolyteGrandmasters", this.ExistingFlameAcolyteGrandmasters);
            nbt.putDouble("ExistingFlameAcolyteHighGrandmasters", this.ExistingFlameAcolyteHighGrandmasters);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Race = original.Race;
            clone.FactionRank = original.FactionRank;
            clone.FactionRankGrade = original.FactionRankGrade;
            clone.VillagerPraise = original.VillagerPraise;
            clone.IllagerTargeting = original.IllagerTargeting;
            clone.Faction = original.Faction;
            clone.ActiveAbility = original.ActiveAbility;
            clone.Hunter = original.Hunter;
            clone.Daedric = original.Daedric;
            clone.BaseStamina = original.BaseStamina;
            clone.Strength = original.Strength;
            clone.Intelligence = original.Intelligence;
            clone.HomeBiome = original.HomeBiome;
            clone.Level = original.Level;
            clone.Amphibious = original.Amphibious;
            clone.CharacterClass = original.CharacterClass;
            clone.Willpower = original.Willpower;
            clone.Agility = original.Agility;
            clone.Speed = original.Speed;
            clone.Endurance = original.Endurance;
            clone.Personality = original.Personality;
            clone.Luck = original.Luck;
            clone.Progresstonextlevel = original.Progresstonextlevel;
            clone.ShortbladeSkillStatus = original.ShortbladeSkillStatus;
            clone.ShortbladeSkillLevel = original.ShortbladeSkillLevel;
            clone.MaximumCarryWeight = original.MaximumCarryWeight;
            clone.MaxScurvyCountdown = original.MaxScurvyCountdown;
            clone.AttributePoints = original.AttributePoints;
            clone.MaxHydration = original.MaxHydration;
            clone.shortblade_skill_progression = original.shortblade_skill_progression;
            clone.archery_skill_level = original.archery_skill_level;
            clone.archery_skill_progression = original.archery_skill_progression;
            clone.heavy_armor_level = original.heavy_armor_level;
            clone.archery_skill_status = original.archery_skill_status;
            clone.heavy_armor_skill_progression = original.heavy_armor_skill_progression;
            clone.block_skill = original.block_skill;
            clone.block_skill_progression = original.block_skill_progression;
            clone.block_skill_status = original.block_skill_status;
            clone.LongBladeSkillLevel = original.LongBladeSkillLevel;
            clone.LongBladeSkillProgress = original.LongBladeSkillProgress;
            clone.LongBladeSkillStatus = original.LongBladeSkillStatus;
            clone.HeavyArmorStatus = original.HeavyArmorStatus;
            clone.MediumArmorSkillLevel = original.MediumArmorSkillLevel;
            clone.MediumArmorSkillProgress = original.MediumArmorSkillProgress;
            clone.MediumArmorStatus = original.MediumArmorStatus;
            clone.LightArmorSkillLevel = original.LightArmorSkillLevel;
            clone.LightArmorSkillProgress = original.LightArmorSkillProgress;
            clone.LightArmorSkillStatus = original.LightArmorSkillStatus;
            clone.NoArmorSkillLevel = original.NoArmorSkillLevel;
            clone.NoArmorSkillProgress = original.NoArmorSkillProgress;
            clone.NoArmorSkillStatus = original.NoArmorSkillStatus;
            clone.AxeSkillProgress = original.AxeSkillProgress;
            clone.AxeSkillLevel = original.AxeSkillLevel;
            clone.AxeSkillStatus = original.AxeSkillStatus;
            clone.PolearmSkillLevel = original.PolearmSkillLevel;
            clone.PolearmSkillProgress = original.PolearmSkillProgress;
            clone.PolearmSkillStatus = original.PolearmSkillStatus;
            clone.BludgeonSkillLevel = original.BludgeonSkillLevel;
            clone.BludgeonSkillProgress = original.BludgeonSkillProgress;
            clone.BludgeonSkillStatus = original.BludgeonSkillStatus;
            clone.SmithingSkillLevel = original.SmithingSkillLevel;
            clone.JumpingSkillLevel = original.JumpingSkillLevel;
            clone.JumpingSkillProgress = original.JumpingSkillProgress;
            clone.JumpingSkillStatus = original.JumpingSkillStatus;
            clone.MedicalSkillLevel = original.MedicalSkillLevel;
            clone.MedicalSkillProgress = original.MedicalSkillProgress;
            clone.MedicalSkillStatus = original.MedicalSkillStatus;
            clone.Reward = original.Reward;
            clone.SmithingSkillProgress = original.SmithingSkillProgress;
            clone.DestructionSkillLevel = original.DestructionSkillLevel;
            clone.DestructionSkillProgress = original.DestructionSkillProgress;
            clone.DestructionSkillStatus = original.DestructionSkillStatus;
            clone.ConjurationSkillLevel = original.ConjurationSkillLevel;
            clone.ActivePower = original.ActivePower;
            clone.BasicRaceSkillUnlocked = original.BasicRaceSkillUnlocked;
            clone.ShieldForbidden = original.ShieldForbidden;
            clone.AxesForbidden = original.AxesForbidden;
            clone.BucklersOnly = original.BucklersOnly;
            clone.SmithingSkillStatus = original.SmithingSkillStatus;
            clone.HeartContainersUsed = original.HeartContainersUsed;
            clone.AglitySpecialization = original.AglitySpecialization;
            clone.Demon = original.Demon;
            clone.Fiery = original.Fiery;
            clone.StealthSkillLevel = original.StealthSkillLevel;
            clone.SteathSkillProgress = original.SteathSkillProgress;
            clone.StealthSkillStatus = original.StealthSkillStatus;
            clone.MysticalSkillLevel = original.MysticalSkillLevel;
            clone.MtsticalSkillProgress = original.MtsticalSkillProgress;
            clone.MysticalSkillStatus = original.MysticalSkillStatus;
            clone.MiningSkillLevel = original.MiningSkillLevel;
            clone.MiningSkillProgress = original.MiningSkillProgress;
            clone.MiningSkillStatus = original.MiningSkillStatus;
            clone.Spellcaster = original.Spellcaster;
            if (!event.isWasDeath()) {
                clone.IllagersSlain = original.IllagersSlain;
                clone.ElementalCharge = original.ElementalCharge;
                clone.huntersinstinctcountdown = original.huntersinstinctcountdown;
                clone.CurrentStamina = original.CurrentStamina;
                clone.PassiveInventoryFillTimer = original.PassiveInventoryFillTimer;
                clone.CurrentMana = original.CurrentMana;
                clone.RacialAbilityCooldown = original.RacialAbilityCooldown;
                clone.CurrentCarryWeight = original.CurrentCarryWeight;
                clone.Fear = original.Fear;
                clone.ScurvyCountdown = original.ScurvyCountdown;
                clone.ScurvyStage = original.ScurvyStage;
                clone.hydrationcountdown = original.hydrationcountdown;
                clone.hydrationsaturation = original.hydrationsaturation;
                clone.hydration = original.hydration;
                clone.Bounty = original.Bounty;
                clone.CursePoints = original.CursePoints;
                clone.TrenchFootAccumulation = original.TrenchFootAccumulation;
                clone.ResistArrest = original.ResistArrest;
                clone.daysuntilfreedom = original.daysuntilfreedom;
                clone.HasBedbugs = original.HasBedbugs;
                clone.totemcooldown = original.totemcooldown;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

