/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thecrusader.recipe.brewing;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class ThickFireResistancePotionBrewingRecipe
implements IBrewingRecipe {
    @SubscribeEvent
    public static void init(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe((IBrewingRecipe)new ThickFireResistancePotionBrewingRecipe());
    }

    public boolean isInput(ItemStack input) {
        Item inputItem = input.getItem();
        return (inputItem == Items.POTION || inputItem == Items.SPLASH_POTION || inputItem == Items.LINGERING_POTION) && ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.THICK);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return Ingredient.of((HolderSet)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.ITEM, (TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"the_crusader:thick_fire_resistance_potion_ingredients")))).test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return PotionContents.createItemStack((Item)input.getItem(), (Holder)Potions.FIRE_RESISTANCE);
        }
        return ItemStack.EMPTY;
    }
}

