/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.screens;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.data.SkiesRegistry;
import fr.tathan.sky_aesthetics.client.screens.SkiesComponents;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.LightSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyBoxSetting;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

public class SkyModificationScreen
extends BaseOwoScreen<FlowLayout> {
    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        FlowLayout skyComponents = SkiesComponents.createDefaultComponent(SkiesRegistry.SKY_DEV == null ? SkyProperties.createDefault() : SkiesRegistry.SKY_DEV.getSkyProperties());
        rootComponent.child(Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child(Containers.collapsible((Sizing)Sizing.fill((int)75), (Sizing)Sizing.content(), (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Sky Settings"), (boolean)true).child(Containers.verticalScroll((Sizing)Sizing.fill((int)50), (Sizing)Sizing.fill((int)90), (Component)skyComponents.id("sky_components")).surface(Surface.VANILLA_TRANSLUCENT).id("vertical_scroll")).id("collapsible_container")).child((Component)Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child(Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Generate resource pack"), button -> this.skyToText(skyComponents)).id("save_button")).child(this.createSkiesImportDropdown(rootComponent, skyComponents).id("import_dropdown")).child(this.createToggleDevSkyButton(skyComponents).horizontalSizing(Sizing.content()).id("toggle_button").margins(Insets.top((int)10))).child(this.createReloadButton(skyComponents).horizontalSizing(Sizing.content()).id("reload_button").margins(Insets.top((int)10))).margins(Insets.of((int)10, (int)0, (int)-20, (int)0))).id("horizontal_flow"));
    }

    public ButtonComponent createToggleDevSkyButton(FlowLayout skyComponents) {
        MutableComponent loadButtonText = SkiesRegistry.USE_SKY_DEV == false ? net.minecraft.network.chat.Component.literal((String)"Load Dev Sky") : net.minecraft.network.chat.Component.literal((String)"Disable Test Sky");
        return Components.button((net.minecraft.network.chat.Component)loadButtonText, button -> {
            if (SkiesRegistry.SKY_DEV == null) {
                this.setDevSkyComponent(skyComponents);
            }
            SkiesRegistry.USE_SKY_DEV = SkiesRegistry.USE_SKY_DEV == false;
            button.setMessage((net.minecraft.network.chat.Component)(SkiesRegistry.USE_SKY_DEV == false ? net.minecraft.network.chat.Component.literal((String)"Load Dev Sky") : net.minecraft.network.chat.Component.literal((String)"Disable Test Sky")));
        });
    }

    public ButtonComponent createReloadButton(FlowLayout skyComponents) {
        return Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Reload Sky"), button -> this.setDevSkyComponent(skyComponents));
    }

    @Nullable
    public SkyProperties setDevSkyComponent(@Nullable FlowLayout skyComponents) {
        if (skyComponents != null) {
            SkyProperties properties = SkyModificationScreen.fromComponent(skyComponents);
            SkiesRegistry.setSkyDev(properties.toDimensionSky());
            SkyAesthetics.LOG.error("Sky Dev set to: {}", (Object)properties.id());
            return properties;
        }
        SkiesRegistry.setSkyDev(null);
        return null;
    }

    public FlowLayout getSkyComponentsFromPath(FlowLayout rootComponent) {
        return (FlowLayout)((ScrollContainer)((CollapsibleContainer)((FlowLayout)rootComponent.childById(FlowLayout.class, "horizontal_flow")).childById(CollapsibleContainer.class, "collapsible_container")).childById(ScrollContainer.class, "vertical_scroll")).childById(FlowLayout.class, "sky_components");
    }

    public void skyToText(FlowLayout component) {
        SkyProperties properties = SkyModificationScreen.fromComponent(component);
        this.saveSkyProperties(properties);
    }

    public DropdownComponent createSkiesImportDropdown(FlowLayout rootComponent, FlowLayout skyComponents) {
        DropdownComponent dropdown = Components.dropdown((Sizing)Sizing.content());
        dropdown.margins(Insets.top((int)10));
        dropdown.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"Import Skies"));
        for (DimensionSky sky : SkiesRegistry.SKY_PROPERTIES.values()) {
            dropdown.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)sky.getSkyId().toString()), component -> {
                ScrollContainer scrollContainer = (ScrollContainer)((CollapsibleContainer)((FlowLayout)rootComponent.childById(FlowLayout.class, "horizontal_flow")).childById(CollapsibleContainer.class, "collapsible_container")).childById(ScrollContainer.class, "vertical_scroll");
                scrollContainer.child((Component)SkiesComponents.createDefaultComponent(sky.getSkyProperties()));
            });
        }
        return dropdown;
    }

    public static SkyProperties fromComponent(FlowLayout component) {
        CollapsibleContainer basicSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "basic_settings");
        if (!basicSettings.expanded()) {
            basicSettings.toggleExpansion();
        }
        String id = ((TextBoxComponent)basicSettings.childById(TextBoxComponent.class, "id")).getValue();
        String world = ((TextBoxComponent)basicSettings.childById(TextBoxComponent.class, "dimension")).getValue();
        boolean weather = ((CheckboxComponent)basicSettings.childById(CheckboxComponent.class, "weather")).selected();
        CollapsibleContainer cloudSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "cloud_settings");
        Optional<CloudSettings> cloud = !cloudSettings.expanded() ? Optional.empty() : Optional.of(new CloudSettings(((CheckboxComponent)cloudSettings.childById(CheckboxComponent.class, "cloud")).selected(), (int)((DiscreteSliderComponent)cloudSettings.childById(DiscreteSliderComponent.class, "cloud_height")).discreteValue()));
        CollapsibleContainer fogSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "fog_settings");
        Optional<FogSettings> fog = !fogSettings.expanded() ? Optional.empty() : Optional.of(new FogSettings(((CheckboxComponent)fogSettings.childById(CheckboxComponent.class, "fog")).selected(), SkyModificationScreen.getVec3iFromComponent((FlowLayout)fogSettings.childById(FlowLayout.class, "fog_color")), SkyModificationScreen.getVec2fFromComponent((FlowLayout)fogSettings.childById(FlowLayout.class, "fog_density"))));
        CollapsibleContainer skyColorSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "color_settings");
        Optional<SkyColorSettings> skyColor = !skyColorSettings.expanded() ? Optional.empty() : Optional.of(new SkyColorSettings(SkyModificationScreen.getVec4fFromComponent((FlowLayout)skyColorSettings.childById(FlowLayout.class, "sky_color")), SkyModificationScreen.getVec3iFromComponent((FlowLayout)skyColorSettings.childById(FlowLayout.class, "sunset_color")), ((TextBoxComponent)skyColorSettings.childById(TextBoxComponent.class, "alpha_modifier")).getValue().equals("-1") ? Optional.empty() : Optional.of(Integer.valueOf((Integer)SkyModificationScreen.convertValue(((TextBoxComponent)skyColorSettings.childById(TextBoxComponent.class, "alpha_modifier")).getValue(), Integer.class)))));
        CollapsibleContainer moonSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "moon_settings");
        Optional<CustomVanillaObject.Moon> moon = !moonSettings.expanded() ? Optional.empty() : Optional.of(new CustomVanillaObject.Moon(((CheckboxComponent)moonSettings.childById(CheckboxComponent.class, "phases")).selected(), ResourceLocation.parse((String)((TextBoxComponent)moonSettings.childById(TextBoxComponent.class, "texture")).getValue()), Float.valueOf(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)moonSettings.childById(TextBoxComponent.class, "height")).getValue(), Float.class)).floatValue()), Float.valueOf(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)moonSettings.childById(TextBoxComponent.class, "size")).getValue(), Float.class)).floatValue())));
        CollapsibleContainer sunSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "sun_settings");
        Optional<CustomVanillaObject.Sun> sun = !sunSettings.expanded() ? Optional.empty() : Optional.of(new CustomVanillaObject.Sun(ResourceLocation.parse((String)((TextBoxComponent)sunSettings.childById(TextBoxComponent.class, "texture")).getValue()), Float.valueOf(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)sunSettings.childById(TextBoxComponent.class, "height")).getValue(), Float.class)).floatValue()), Float.valueOf(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)sunSettings.childById(TextBoxComponent.class, "size")).getValue(), Float.class)).floatValue())));
        CollapsibleContainer skyObjectsSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "sky_objects");
        FlowLayout skyObjects = (FlowLayout)skyObjectsSettings.childById(FlowLayout.class, "objects");
        ArrayList<SkyObject> objects = new ArrayList<SkyObject>(List.of());
        for (Component child : skyObjects.children()) {
            CollapsibleContainer container;
            if (!(child instanceof CollapsibleContainer) || (container = (CollapsibleContainer)child).id() == null || !container.id().equals("object")) continue;
            if (!container.expanded()) {
                container.toggleExpansion();
            }
            FlowLayout layout = (FlowLayout)container.children().getLast();
            ResourceLocation location = ResourceLocation.parse((String)((TextBoxComponent)layout.childById(TextBoxComponent.class, "texture")).getValue());
            boolean blend = ((CheckboxComponent)layout.childById(CheckboxComponent.class, "blend")).selected();
            int size = (Integer)SkyModificationScreen.convertValue(((TextBoxComponent)layout.childById(TextBoxComponent.class, "size")).getValue(), Integer.class);
            int height = (Integer)SkyModificationScreen.convertValue(((TextBoxComponent)layout.childById(TextBoxComponent.class, "height")).getValue(), Integer.class);
            String rotationType = SkyModificationScreen.getRotationType(((TextBoxComponent)layout.childById(TextBoxComponent.class, "rotation_type")).getValue());
            FlowLayout rotationLayout = (FlowLayout)layout.childById(FlowLayout.class, "rotation");
            Vector3f rotation = new Vector3f(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)rotationLayout.childById(TextBoxComponent.class, "x")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)rotationLayout.childById(TextBoxComponent.class, "y")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)rotationLayout.childById(TextBoxComponent.class, "z")).getValue(), Float.class)).floatValue());
            FlowLayout objectRotationLayout = (FlowLayout)layout.childById(FlowLayout.class, "object_rotation");
            Vector3f objectRotation = new Vector3f(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)objectRotationLayout.childById(TextBoxComponent.class, "x")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)objectRotationLayout.childById(TextBoxComponent.class, "y")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)objectRotationLayout.childById(TextBoxComponent.class, "z")).getValue(), Float.class)).floatValue());
            objects.add(new SkyObject(location, blend, size, rotation, objectRotation, height, rotationType));
        }
        CollapsibleContainer starSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "star_settings");
        StarSettings stars = new StarSettings(((CheckboxComponent)starSettings.childById(CheckboxComponent.class, "vanilla")).selected(), ((CheckboxComponent)starSettings.childById(CheckboxComponent.class, "moving_stars")).selected(), (int)((DiscreteSliderComponent)starSettings.childById(DiscreteSliderComponent.class, "count")).discreteValue(), ((CheckboxComponent)starSettings.childById(CheckboxComponent.class, "all_days_visible")).selected(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)starSettings.childById(TextBoxComponent.class, "scale")).getValue(), Float.class)).floatValue(), SkyModificationScreen.getVec3iFromComponent((FlowLayout)starSettings.childById(FlowLayout.class, "star_color")).get(), Optional.empty(), Optional.empty());
        CollapsibleContainer skyBoxSetting = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "skybox_settings");
        Optional<SkyBoxSetting> skyBox = !skyBoxSetting.expanded() ? Optional.empty() : Optional.of(new SkyBoxSetting((int)((DiscreteSliderComponent)skyBoxSetting.childById(DiscreteSliderComponent.class, "gradation")).discreteValue(), ResourceLocation.parse((String)((TextBoxComponent)skyBoxSetting.childById(TextBoxComponent.class, "texture")).getValue()), SkyModificationScreen.getVec3fFromComponent((FlowLayout)skyBoxSetting.childById(FlowLayout.class, "rotation")).orElseGet(Vector3f::new)));
        CollapsibleContainer lightSettings = (CollapsibleContainer)component.childById(CollapsibleContainer.class, "light_settings");
        Optional<LightSettings> light = !lightSettings.expanded() ? Optional.empty() : Optional.of(new LightSettings(((CheckboxComponent)lightSettings.childById(CheckboxComponent.class, "forceBrightLightmap")).selected(), ((CheckboxComponent)lightSettings.childById(CheckboxComponent.class, "constantAmbientLight")).selected()));
        return new SkyProperties((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)world)), ResourceLocation.parse((String)id), cloud, fog, weather, sun, moon, stars, skyColor, objects, Optional.empty(), skyBox, light);
    }

    public static String getRotationType(String str) {
        return switch (str.toLowerCase()) {
            case "static" -> "STATIC";
            case "day" -> "DAY";
            default -> "STATIC";
        };
    }

    public static Optional<Vector3f> getVec3fFromComponent(FlowLayout component) {
        Vector3f color = new Vector3f(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "x")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "y")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "z")).getValue(), Float.class)).floatValue());
        return color.x() == 0.0f && color.y() == 0.0f && color.z() == 0.0f ? Optional.empty() : Optional.of(color);
    }

    public static Optional<Vector3i> getVec3iFromComponent(FlowLayout component) {
        Vector3i color = new Vector3i(((Integer)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "x")).getValue(), Integer.class)).intValue(), ((Integer)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "y")).getValue(), Integer.class)).intValue(), ((Integer)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "z")).getValue(), Integer.class)).intValue());
        return color.x() == 0 && color.y() == 0 && color.z() == 0 ? Optional.empty() : Optional.of(color);
    }

    public static Optional<Vector2f> getVec2fFromComponent(FlowLayout component) {
        Vector2f color = new Vector2f(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "x")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "y")).getValue(), Float.class)).floatValue());
        return color.x() == 0.0f && color.y() == 0.0f ? Optional.empty() : Optional.of(color);
    }

    public static Optional<Vector4f> getVec4fFromComponent(FlowLayout component) {
        Vector4f color = new Vector4f(((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "x")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "y")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "z")).getValue(), Float.class)).floatValue(), ((Float)SkyModificationScreen.convertValue(((TextBoxComponent)component.childById(TextBoxComponent.class, "w")).getValue(), Float.class)).floatValue());
        return color.x() == 0.0f && color.y() == 0.0f ? Optional.empty() : Optional.of(color);
    }

    public static Object convertValue(String str, Class<?> type) {
        try {
            return switch (type.getSimpleName()) {
                case "int", "Integer" -> Integer.parseInt(str);
                case "long", "Long" -> Long.parseLong(str);
                case "double", "Double" -> Double.parseDouble(str);
                case "float", "Float" -> Float.valueOf(Float.parseFloat(str));
                default -> str;
            };
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void saveSkyProperties(SkyProperties properties) {
        try {
            JsonElement element = (JsonElement)SkyProperties.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)properties).result().orElseThrow(() -> new IllegalStateException("Failed to encode to JSON"));
            Path resourcePackPath = this.minecraft.getResourcePackDirectory().resolve(properties.id().getPath());
            Path directoryPath = resourcePackPath.resolve("assets").resolve(properties.id().getNamespace()).resolve("sky_aesthetics");
            Path metadataPath = resourcePackPath.resolve("pack.mcmeta");
            Path filePath = directoryPath.resolve(properties.id().getPath() + ".json");
            if (!filePath.getParent().toFile().exists()) {
                filePath.getParent().toFile().mkdirs();
                metadataPath.getParent().toFile().mkdirs();
            }
            SkyModificationScreen.writeFile(filePath, element);
            PackMetadataSection section = new PackMetadataSection((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)(properties.id().getPath() + " Generated Sky")), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty());
            JsonElement sectionElement = (JsonElement)PackMetadataSection.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)section).result().orElseThrow(() -> new IllegalStateException("Failed to encode to JSON"));
            JsonObject packMetadata = new JsonObject();
            packMetadata.add("pack", sectionElement);
            SkyModificationScreen.writeFile(metadataPath, (JsonElement)packMetadata);
            Util.getPlatform().openUri(resourcePackPath.toUri());
        }
        catch (Exception e) {
            this.playToast((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"sky_aesthetics.toast.error.title"), (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"sky_aesthetics.toast.error.description"));
            SkyAesthetics.LOG.error("Failed to save sky properties to file", (Throwable)e);
        }
    }

    public void playToast(net.minecraft.network.chat.Component title, net.minecraft.network.chat.Component description) {
        this.minecraft.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, title, description));
    }

    public static void writeFile(Path path, JsonElement element) {
        try {
            File folder = path.toFile().getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            FileWriter writer = new FileWriter(path.toFile());
            SkyAesthetics.GSON.toJson(element, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            SkyAesthetics.LOG.error("Failed to write file: {}", (Object)path, (Object)e);
        }
    }
}

