/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.DimensionRenderer;
import fr.tathan.sky_aesthetics.client.data.SkiesRegistry;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.helper.PlatformHelper;
import fr.tathan.sky_aesthetics.mixin.client.LevelRendererAccessor;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SkyHelper {
    public static void drawSky(Matrix4f matrix4f, Matrix4f projectionMatrix) {
        ((LevelRendererAccessor)class_310.method_1551().field_1769).stellaris$getSkyBuffer().method_1353();
        ((LevelRendererAccessor)class_310.method_1551().field_1769).stellaris$getSkyBuffer().method_34427(matrix4f, projectionMatrix, RenderSystem.getShader());
        class_291.method_1354();
    }

    public static void drawMoonWithPhase(class_289 tesselator, class_4587 poseStack, float y, class_2960 texture, float dayAngle) {
        int moonPhase = 3;
        int xCoord = moonPhase % 4;
        int yCoord = moonPhase / 4 % 2;
        float startX = (float)xCoord / 4.0f;
        float startY = (float)yCoord / 2.0f;
        float endX = (float)(xCoord + 1) / 4.0f;
        float endY = (float)(yCoord + 1) / 2.0f;
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, 20.0f, dayAngle, startX, endX, startY, endY, true);
    }

    public static void drawCelestialBody(class_2960 texture, class_289 tesselator, class_4587 poseStack, float y, float size, float dayAngle, boolean blend) {
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, size, dayAngle, 0.0f, 1.0f, 1.0f, 0.0f, blend);
    }

    public static void drawCelestialBody(class_2960 texture, class_289 tesselator, class_4587 poseStack, float y, float size, float dayAngle, float startX, float endX, float startY, float endY, boolean blend) {
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, size, dayAngle, startX, endX, startY, endY, blend, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
    }

    public static void drawCelestialBody(class_2960 texture, class_289 tesselator, class_4587 poseStack, float y, float size, float dayAngle, float startX, float endX, float startY, float endY, boolean blend, float @Nullable [] color) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(dayAngle));
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        if (color == null) {
            color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        float ratio = 1.0f;
        if (y > class_310.method_1551().field_1773.method_3193()) {
            ratio = class_310.method_1551().field_1773.method_3193() / y;
        }
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)4.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, -size * ratio, y * ratio - 1.0f, -size * ratio).method_22913(startX, endY);
        bufferBuilder.method_22918(matrix4f, size * ratio, y * ratio - 1.0f, -size * ratio).method_22913(endX, endY);
        bufferBuilder.method_22918(matrix4f, size * ratio, y * ratio - 1.0f, size * ratio).method_22913(endX, startY);
        bufferBuilder.method_22918(matrix4f, -size * ratio, y * ratio - 1.0f, size * ratio).method_22913(startX, startY);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        poseStack.method_22909();
        if (blend) {
            RenderSystem.disableBlend();
        }
    }

    public static void renderEndSky(class_4587 poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)((LevelRendererAccessor)class_310.method_1551().field_1769).stellaris$getEndSkyLocation());
        class_289 tesselator = class_289.method_1348();
        for (int i = 0; i < 6; ++i) {
            poseStack.method_22903();
            switch (i) {
                case 1: 
                case 4: {
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    break;
                }
                case 2: 
                case 5: {
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(270.0f));
                }
            }
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_39415(-14145496);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_39415(-14145496);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            poseStack.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static boolean canRenderSky(class_638 level, Consumer<DimensionSky> action) {
        if (SkiesRegistry.SKY_DEV != null && SkiesRegistry.USE_SKY_DEV.booleanValue() && level.method_27983().equals(SkiesRegistry.SKY_DEV.getDimension())) {
            action.accept(SkiesRegistry.SKY_DEV);
            return true;
        }
        for (DimensionSky sky : SkiesRegistry.SKY_PROPERTIES.values()) {
            if (!sky.getDimension().equals((Object)level.method_27983())) continue;
            if (Arrays.stream(SkyAesthetics.CONFIG.disabledSkies).anyMatch(s -> s.equals(sky.getSkyId().toString()))) {
                return false;
            }
            if (Arrays.stream(SkyAesthetics.CONFIG.disabledDimensions).anyMatch(s -> s.equals(sky.getDimension().method_29177().toString()))) {
                return false;
            }
            DimensionRenderer renderer = sky.getRenderer();
            if (renderer.renderCondition != null && renderer.renderCondition.isSkyRendered(DimensionRenderer.getServerLevel())) {
                return false;
            }
            action.accept(sky);
            return true;
        }
        return false;
    }

    public static boolean isAModCancelRendering(String[] modIds) {
        for (String modId : modIds) {
            if (!PlatformHelper.isModLoaded(modId)) continue;
            return true;
        }
        return false;
    }
}

