/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SkyBoxSetting {
    public static Codec<SkyBoxSetting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("gradation").forGetter(b -> b.gradation), (App)class_2960.field_25139.fieldOf("texture").forGetter(b -> b.texture), (App)SkyObject.VEC3F.fieldOf("rotation").forGetter(b -> b.rotation)).apply((Applicative)instance, SkyBoxSetting::new));
    public class_291 sphere;
    public final int gradation;
    public final class_2960 texture;
    public final Vector3f rotation;

    public SkyBoxSetting(int gradation, class_2960 texture, Vector3f rotation) {
        this.gradation = gradation;
        this.texture = texture;
        this.rotation = rotation;
        this.sphere = this.createSphere();
    }

    public class_291 createSphere() {
        float PI = (float)Math.PI;
        int gradation = this.gradation;
        class_289 tesselator = class_289.method_1348();
        class_291 vertexBuffer = new class_291(class_291.class_8555.field_44793);
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1585);
        for (int i = 0; i < gradation; ++i) {
            float alpha1 = (float)i * (float)Math.PI / (float)gradation;
            float alpha2 = (float)(i + 1) * (float)Math.PI / (float)gradation;
            for (int j = 0; j < gradation * 2; ++j) {
                float beta1 = (float)(j * 2) * (float)Math.PI / (float)(gradation * 2);
                float beta2 = (float)((j + 1) * 2) * (float)Math.PI / (float)(gradation * 2);
                float x1 = (float)(Math.sin(alpha1) * Math.cos(beta1));
                float y1 = (float)(Math.sin(alpha1) * Math.sin(beta1));
                float z1 = (float)Math.cos(alpha1);
                float x2 = (float)(Math.sin(alpha1) * Math.cos(beta2));
                float y2 = (float)(Math.sin(alpha1) * Math.sin(beta2));
                float z2 = (float)Math.cos(alpha1);
                float x3 = (float)(Math.sin(alpha2) * Math.cos(beta1));
                float y3 = (float)(Math.sin(alpha2) * Math.sin(beta1));
                float z3 = (float)Math.cos(alpha2);
                float x4 = (float)(Math.sin(alpha2) * Math.cos(beta2));
                float y4 = (float)(Math.sin(alpha2) * Math.sin(beta2));
                float z4 = (float)Math.cos(alpha2);
                float u1 = beta1 / ((float)Math.PI * 2);
                float v1 = alpha1 / (float)Math.PI;
                float u2 = beta2 / ((float)Math.PI * 2);
                float v2 = alpha1 / (float)Math.PI;
                float u3 = beta1 / ((float)Math.PI * 2);
                float v3 = alpha2 / (float)Math.PI;
                float u4 = beta2 / ((float)Math.PI * 2);
                float v4 = alpha2 / (float)Math.PI;
                bufferBuilder.method_22912(x1, y1, z1).method_22913(u1, v1);
                bufferBuilder.method_22912(x2, y2, z2).method_22913(u2, v2);
                bufferBuilder.method_22912(x3, y3, z3).method_22913(u3, v3);
                bufferBuilder.method_22912(x3, y3, z3).method_22913(u3, v3);
                bufferBuilder.method_22912(x2, y2, z2).method_22913(u2, v2);
                bufferBuilder.method_22912(x4, y4, z4).method_22913(u4, v4);
            }
        }
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(bufferBuilder.method_60800());
        class_291.method_1354();
        return vertexBuffer;
    }

    public void renderSkyBox(class_4587 poseStack, Matrix4f projectionMatrix, class_4184 camera) {
        poseStack.method_22903();
        class_758.method_23792();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f viewMatrix = new Matrix4f();
        camera.method_23767().get(viewMatrix);
        viewMatrix.invert();
        Matrix4f modelMatrix = new Matrix4f().identity().scale(1.0f);
        modelMatrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.rotation.x)).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.rotation.y)).rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.rotation.z));
        Matrix4f mvMatrix = new Matrix4f((Matrix4fc)viewMatrix).mul((Matrix4fc)modelMatrix);
        this.sphere.method_1353();
        this.sphere.method_34427(mvMatrix, projectionMatrix, class_757.method_34542());
        class_291.method_1354();
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    public static SkyBoxSetting createDefaultSettings() {
        return new SkyBoxSetting(100, class_2960.method_60654((String)"sky_aesthetics:textures/skyboxes/venus.png"), new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

