/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.DimensionRenderer;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.LightSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyBoxSetting;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public record SkyProperties(class_5321<class_1937> world, class_2960 id, Optional<CloudSettings> cloudSettings, Optional<FogSettings> fogSettings, Boolean weather, Optional<CustomVanillaObject.Sun> sun, Optional<CustomVanillaObject.Moon> moon, StarSettings stars, Optional<SkyColorSettings> skyColor, List<SkyObject> skyObjects, Optional<RenderCondition> renderCondition, Optional<SkyBoxSetting> skyBoxSetting, Optional<LightSettings> lightSettings) {
    public static final Codec<SkyProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("world").forGetter(SkyProperties::world), (App)class_2960.field_25139.fieldOf("id").forGetter(SkyProperties::id), (App)CloudSettings.CODEC.optionalFieldOf("cloud_settings").forGetter(SkyProperties::cloudSettings), (App)FogSettings.CODEC.optionalFieldOf("fog_settings").forGetter(SkyProperties::fogSettings), (App)Codec.BOOL.fieldOf("weather").forGetter(SkyProperties::weather), (App)CustomVanillaObject.Sun.CODEC.optionalFieldOf("sun").forGetter(SkyProperties::sun), (App)CustomVanillaObject.Moon.CODEC.optionalFieldOf("moon").forGetter(SkyProperties::moon), (App)StarSettings.CODEC.fieldOf("stars").forGetter(SkyProperties::stars), (App)SkyColorSettings.CODEC.optionalFieldOf("sky_color").forGetter(SkyProperties::skyColor), (App)SkyObject.CODEC.listOf().fieldOf("sky_objects").forGetter(SkyProperties::skyObjects), (App)RenderCondition.CODEC.optionalFieldOf("condition").forGetter(SkyProperties::renderCondition), (App)SkyBoxSetting.CODEC.optionalFieldOf("sky_box").forGetter(SkyProperties::skyBoxSetting), (App)LightSettings.CODEC.optionalFieldOf("light_settings").forGetter(SkyProperties::lightSettings)).apply((Applicative)instance, SkyProperties::new));

    public DimensionRenderer toDimensionRenderer() {
        DimensionRenderer.Builder builder = new DimensionRenderer.Builder().setWeather(this.weather).setStar(this.stars);
        this.moon.ifPresent(builder::addMoon);
        this.sun.ifPresent(builder::addSun);
        this.skyObjects.forEach(builder::addSkyObject);
        this.cloudSettings.ifPresent(builder::addCloudSettings);
        this.fogSettings.ifPresent(builder::setFogSettings);
        this.skyColor.ifPresent(builder::setSkyColor);
        this.renderCondition.ifPresent(builder::setRenderCondition);
        this.skyBoxSetting.ifPresent(builder::setSkyBoxSetting);
        return builder.build();
    }

    public DimensionSky toDimensionSky() {
        return new DimensionSky(this);
    }

    public static SkyProperties createDefault() {
        return new SkyProperties((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)"overworld")), class_2960.method_60654((String)"default"), Optional.of(CloudSettings.createDefaultSettings()), Optional.of(FogSettings.createDefaultSettings()), true, Optional.of(CustomVanillaObject.Sun.createDefaultSun()), Optional.of(CustomVanillaObject.Moon.createDefaultMoon()), StarSettings.createDefaultStars(), Optional.of(SkyColorSettings.createDefaultSettings()), List.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public record RenderCondition(Optional<class_6862<class_1959>> biomes, Optional<class_5321<class_1959>> biome) {
        public static final Codec<RenderCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41236).optionalFieldOf("biomes").forGetter(RenderCondition::biomes), (App)class_5321.method_39154((class_5321)class_7924.field_41236).optionalFieldOf("biome").forGetter(RenderCondition::biome)).apply((Applicative)instance, RenderCondition::new));

        public boolean isSkyRendered(class_3218 level) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || level == null) {
                return false;
            }
            if (this.biomes().isPresent()) {
                return level.method_23753(player.method_23312()).method_40220(this.biomes().get());
            }
            if (this.biome().isPresent()) {
                return level.method_23753(player.method_23312()).method_40225(this.biome().get());
            }
            return true;
        }
    }
}

