/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyBoxSetting;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerLevel;
import org.joml.Matrix4f;

public class DimensionRenderer {
    public final List<SkyObject> skyObjects;
    public final CloudSettings cloudSettings;
    public final CustomVanillaObject.Sun sun;
    public final CustomVanillaObject.Moon moon;
    public final SkyColorSettings skyColor;
    public final FogSettings fogSettings;
    public final StarSettings starSettings;
    public final SkyBoxSetting skyBoxSetting;
    public final boolean weather;
    public final SkyProperties.RenderCondition renderCondition;
    private final VertexBuffer starBuffer;
    private final HashMap<UUID, ShootingStar> shootingStars = new HashMap();

    private DimensionRenderer(List<SkyObject> skyObjects, CloudSettings cloudSettings, CustomVanillaObject.Sun sun, CustomVanillaObject.Moon moon, SkyColorSettings skyColor, FogSettings fogSettings, StarSettings starSettings, SkyBoxSetting skyBoxSetting, boolean weather, SkyProperties.RenderCondition renderCondition) {
        this.skyObjects = skyObjects;
        this.cloudSettings = cloudSettings;
        this.sun = sun;
        this.moon = moon;
        this.skyColor = skyColor;
        this.fogSettings = fogSettings;
        this.starSettings = starSettings;
        this.starBuffer = starSettings.getStarsBuffer();
        this.skyBoxSetting = skyBoxSetting;
        this.weather = weather;
        this.renderCondition = renderCondition;
    }

    public boolean canRenderSky() {
        if (this.renderCondition == null) {
            return true;
        }
        return this.renderCondition.isSkyRendered(this.getServerLevel());
    }

    public void render(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, Runnable fogCallback) {
        Tesselator tesselator = Tesselator.getInstance();
        float dayAngle = level.getTimeOfDay(partialTick) * 360.0f % 360.0f;
        float nightAngle = dayAngle + 180.0f;
        this.fogSettings.runFogCallback(fogCallback);
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        this.skyColor.setSkyColor(level, camera, partialTick);
        SkyHelper.drawSky(poseStack.last().pose(), projectionMatrix);
        if (this.skyBoxSetting != null) {
            this.skyBoxSetting.renderSkyBox(poseStack, projectionMatrix, camera);
        }
        this.fogSettings.runFogCallback(fogCallback);
        this.starSettings.renderStars(level, partialTick, poseStack, projectionMatrix, nightAngle, this.starBuffer);
        this.starSettings.shootingStars().ifPresent(shootingStars -> this.starSettings.handleShootingStars(level, poseStack, projectionMatrix, this.starSettings, partialTick, this.shootingStars));
        this.fogSettings.runFogCallback(fogCallback);
        if (this.sun != null) {
            this.sun.render(tesselator, poseStack, dayAngle);
        }
        if (this.moon != null) {
            this.moon.render(null, tesselator, poseStack, nightAngle);
        }
        for (SkyObject skyObject : this.skyObjects) {
            skyObject.drawSkyObject(tesselator, poseStack, dayAngle);
        }
        this.testRender(level, poseStack, projectionMatrix, partialTick, camera, fogCallback);
        this.fogSettings.runFogCallback(fogCallback);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    public void testRender(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, Runnable fogCallback) {
    }

    public boolean renderClouds() {
        return this.cloudSettings.showCloud();
    }

    public static ServerLevel getServerLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer integratedServer = minecraft.getSingleplayerServer();
        return integratedServer != null ? integratedServer.getLevel(minecraft.level.dimension()) : null;
    }

    public static class Builder {
        public List<SkyObject> skyObjects = new ArrayList<SkyObject>();
        public CloudSettings cloudSettings = CloudSettings.createDefaultSettings();
        public CustomVanillaObject.Sun sun = null;
        public CustomVanillaObject.Moon moon = null;
        public FogSettings fogSettings = FogSettings.createDefaultSettings();
        public StarSettings star = StarSettings.createDefaultStars();
        public SkyProperties.RenderCondition renderCondition = null;
        public SkyColorSettings skyColor = SkyColorSettings.createDefaultSettings();
        public boolean weather = true;
        public SkyBoxSetting skyBoxSetting = null;

        public Builder setSkyBoxSetting(SkyBoxSetting skyBoxSetting) {
            this.skyBoxSetting = skyBoxSetting;
            return this;
        }

        public Builder setStar(StarSettings star) {
            this.star = star;
            return this;
        }

        public Builder setFogSettings(FogSettings fogSettings) {
            this.fogSettings = fogSettings;
            return this;
        }

        public Builder setWeather(boolean weather) {
            this.weather = weather;
            return this;
        }

        public Builder setSkyColor(SkyColorSettings skyColor) {
            this.skyColor = skyColor;
            return this;
        }

        public Builder addMoon(CustomVanillaObject.Moon moon) {
            this.moon = moon;
            return this;
        }

        public Builder setRenderCondition(SkyProperties.RenderCondition renderCondition) {
            this.renderCondition = renderCondition;
            return this;
        }

        public Builder addSun(CustomVanillaObject.Sun sun) {
            this.sun = sun;
            return this;
        }

        public Builder addCloudSettings(CloudSettings cloudSettings) {
            this.cloudSettings = cloudSettings;
            return this;
        }

        public Builder addSkyObject(SkyObject skyObject) {
            this.skyObjects.add(skyObject);
            return this;
        }

        public DimensionRenderer build() {
            return new DimensionRenderer(this.skyObjects, this.cloudSettings, this.sun, this.moon, this.skyColor, this.fogSettings, this.star, this.skyBoxSetting, this.weather, this.renderCondition);
        }
    }
}

