/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.screens;

import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.LightSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyBoxSetting;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Sizing;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

public class SkiesComponents {
    public static FlowLayout createDefaultComponent(SkyProperties properties) {
        return (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.createBasicSettings(properties).id("basic_settings")).child(SkiesComponents.createCloudSettings(properties.cloudSettings()).id("cloud_settings")).child(SkiesComponents.createFogSettings(properties.fogSettings()).id("fog_settings")).child(SkiesComponents.createColorSettings(properties.skyColor()).id("color_settings")).child(SkiesComponents.createSkyObjects(properties.skyObjects()).id("sky_objects")).child(SkiesComponents.createStarSettings(properties.stars()).id("star_settings")).child(SkiesComponents.createMoonSettings(properties.moon()).id("moon_settings")).child(SkiesComponents.createSunSettings(properties.sun()).id("sun_settings")).child(SkiesComponents.createSkyBoxSettings(properties.skyBoxSetting()).id("skybox_settings")).child(SkiesComponents.createLightSettings(properties.lightSettings()).id("light_settings")).id("sky_components");
    }

    public static CollapsibleContainer createBasicSettings(SkyProperties properties) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content((int)0), (Component)Component.literal((String)"Basic Settings"), (boolean)true);
        container.child(SkiesComponents.textBox(Sizing.fill((int)75), properties.id().toString()).id("id")).tooltip((Component)Component.literal((String)"The ID of the sky"));
        container.child(SkiesComponents.textBox(Sizing.fill((int)75), properties.world().location().toString()).id("dimension").tooltip((Component)Component.literal((String)"The dimension of the sky")));
        container.child(Components.checkbox((Component)Component.literal((String)"weather")).checked(properties.weather().booleanValue()).id("weather")).tooltip((Component)Component.literal((String)"Should the weather be rendered?"));
        return container;
    }

    public static CollapsibleContainer createCloudSettings(Optional<CloudSettings> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content((int)0), (Component)Component.literal((String)"Cloud Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        CloudSettings setting = settings.orElseGet(CloudSettings::createDefaultSettings);
        container.child(Components.checkbox((Component)Component.literal((String)"cloud")).checked(setting.showCloud()).id("cloud").tooltip((Component)Component.literal((String)"Should clouds be rendered")));
        container.child(Components.discreteSlider((Sizing)Sizing.fill((int)50), (double)0.0, (double)300.0).value((double)setting.cloudHeight().intValue()).id("cloud_height").tooltip((Component)Component.literal((String)"Cloud Height in blocks")));
        return container;
    }

    public static CollapsibleContainer createFogSettings(Optional<FogSettings> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Fog Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        FogSettings setting = settings.orElseGet(FogSettings::createDefaultSettings);
        Vector3i fogColor = setting.customFogColor().orElse(new Vector3i(0, 0, 0));
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(fogColor.x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(fogColor.y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(fogColor.z)).id("z")).tooltip((Component)Component.literal((String)"The RGB values for the fog color")).id("fog_color"));
        Vector2f fogDensity = setting.fogDensity().orElse(new Vector2f(0.0f, 0.0f));
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(fogDensity.x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(fogDensity.y)).id("y")).tooltip((Component)Component.literal((String)"The min and max density of the fog")).id("fog_density"));
        container.child(Components.checkbox((Component)Component.literal((String)"fog")).checked(setting.fog().booleanValue()).id("fog"));
        return container;
    }

    public static CollapsibleContainer createSkyBoxSettings(Optional<SkyBoxSetting> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"SkyBox Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        SkyBoxSetting setting = settings.orElseGet(SkyBoxSetting::createDefaultSettings);
        container.child(Components.discreteSlider((Sizing)Sizing.fill((int)50), (double)10.0, (double)300.0).value((double)setting.gradation).id("gradation").tooltip((Component)Component.literal((String)"The detail of the sphere")));
        container.child(SkiesComponents.textBox(Sizing.fill((int)75)).text(setting.texture.toString()).id("texture").tooltip((Component)Component.literal((String)"The texture of the sky box")));
        Vector3f rotation = setting.rotation;
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(rotation.x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(rotation.y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(rotation.z)).id("z")).tooltip((Component)Component.literal((String)"The Sphere rotation")).id("rotation"));
        return container;
    }

    public static CollapsibleContainer createMoonSettings(Optional<CustomVanillaObject.Moon> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Moon Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        CustomVanillaObject.Moon setting = settings.orElseGet(CustomVanillaObject.Moon::createDefaultMoon);
        container.child(Components.checkbox((Component)Component.literal((String)"Moon Phases")).checked(setting.moonPhase()).id("phases").tooltip((Component)Component.literal((String)"Should the moon have Moon Phases?"))).child(SkiesComponents.textBox(Sizing.fill((int)75)).text(setting.moonTexture().toString()).id("texture").tooltip((Component)Component.literal((String)"The texture of the moon"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.moonHeight())).id("height").tooltip((Component)Component.literal((String)"The Moon Height"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.moonSize())).id("size").tooltip((Component)Component.literal((String)"The Moon Size")));
        return container;
    }

    public static CollapsibleContainer createSunSettings(Optional<CustomVanillaObject.Sun> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Sun Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        CustomVanillaObject.Sun setting = settings.orElseGet(CustomVanillaObject.Sun::createDefaultSun);
        container.child(SkiesComponents.textBox(Sizing.fill((int)75)).text(setting.sunTexture().toString()).id("texture").tooltip((Component)Component.literal((String)"The texture of the sun"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.sunHeight())).id("height").tooltip((Component)Component.literal((String)"The Sun Height"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.sunSize())).id("size").tooltip((Component)Component.literal((String)"The Sun Size")));
        return container;
    }

    public static CollapsibleContainer createColorSettings(Optional<SkyColorSettings> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Sky Color Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        SkyColorSettings setting = settings.orElseGet(SkyColorSettings::createDefaultSettings);
        Vector3i fogColor = setting.sunsetColor().orElse(new Vector3i(0, 0, 0));
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogColor.x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogColor.y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogColor.z)).id("z")).tooltip((Component)Component.literal((String)"RGB values for sunset color")).id("sunset_color"));
        Vector4f fogDensity = setting.color().orElse(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f));
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogDensity.x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogDensity.y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogDensity.z)).id("z")).child(SkiesComponents.textBox(Sizing.fill((int)20)).text(String.valueOf(fogDensity.w)).id("w")).tooltip((Component)Component.literal((String)"RGBA values for sky color")).id("sky_color"));
        int alphaModifier = setting.sunriseAlphaModifier().orElse(1);
        container.child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(alphaModifier)).tooltip((Component)Component.literal((String)"Sky color alpha modifier for sunrise")).id("alpha_modifier"));
        return container;
    }

    public static CollapsibleContainer createSkyObjects(List<SkyObject> skyObjects) {
        CollapsibleContainer container = (CollapsibleContainer)Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Sky Objects"), (boolean)true).id("sky_objects");
        FlowLayout objectsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("objects");
        for (SkyObject skyObject : skyObjects) {
            objectsLayout.child(SkiesComponents.createSkyObject(skyObject, (BaseParentComponent)objectsLayout).id("object"));
        }
        container.child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Components.button((Component)Component.literal((String)"Add Sky Object"), buttonComponent -> {
            SkyObject newSkyObject = new SkyObject(ResourceLocation.parse((String)"default_texture"), false, 40.0f, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 100, "STATIC");
            objectsLayout.child(SkiesComponents.createSkyObject(newSkyObject, (BaseParentComponent)objectsLayout).id("object"));
        })).id("add_button"));
        container.child((io.wispforest.owo.ui.core.Component)objectsLayout);
        return container;
    }

    public static CollapsibleContainer createSkyObject(SkyObject skyObject, BaseParentComponent parent) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)("Object : " + parent.children().size())), (boolean)false);
        container.child(Components.checkbox((Component)Component.literal((String)"Blend")).checked(skyObject.blend()).id("blend").tooltip((Component)Component.literal((String)"Should the object be blended?"))).child(SkiesComponents.textBox(Sizing.fill((int)75)).text(skyObject.texture().toString()).id("texture").tooltip((Component)Component.literal((String)"The texture of the sky object"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.size())).id("size").tooltip((Component)Component.literal((String)"The size of the sky object"))).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.height())).id("height").tooltip((Component)Component.literal((String)"The height of the sky object in blocks"))).child(SkiesComponents.textBox(Sizing.fill((int)50)).text(skyObject.rotationType()).id("rotation_type")).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.rotation().x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.rotation().y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.rotation().z)).id("z")).tooltip((Component)Component.literal((String)"X, Y, Z position of the sky object")).id("rotation")).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.objectRotation().x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.objectRotation().y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(skyObject.objectRotation().z)).id("z")).tooltip((Component)Component.literal((String)"X, Y, Z rotation of the sky object")).id("object_rotation")).child((io.wispforest.owo.ui.core.Component)Components.button((Component)Component.literal((String)"Remove"), button -> parent.removeChild((io.wispforest.owo.ui.core.Component)container)));
        return container;
    }

    public static CollapsibleContainer createStarSettings(Optional<StarSettings> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content(), (Component)Component.literal((String)"Star Settings (Optionnal)"), (boolean)true);
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        StarSettings setting = settings.orElseGet(StarSettings::createDefaultStars);
        container.child(Components.checkbox((Component)Component.literal((String)"Vanilla")).checked(setting.vanilla()).id("vanilla").tooltip((Component)Component.literal((String)"Should vanilla stars be rendered?"))).child(Components.checkbox((Component)Component.literal((String)"Moving Stars")).checked(setting.movingStars()).id("moving_stars").tooltip((Component)Component.literal((String)"Should the stars move?"))).child(Components.discreteSlider((Sizing)Sizing.fill((int)50), (double)0.0, (double)100000.0).value((double)setting.count()).id("count").tooltip((Component)Component.literal((String)"Star Count"))).child(Components.checkbox((Component)Component.literal((String)"All Day Visible")).checked(setting.movingStars()).id("all_days_visible").tooltip((Component)Component.literal((String)"Should stars be visible all day?"))).child(SkiesComponents.textBox(Sizing.fill((int)25), String.valueOf(setting.scale())).id("scale").tooltip((Component)Component.literal((String)"Star Scale"))).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.color().x)).id("x")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.color().y)).id("y")).child(SkiesComponents.textBox(Sizing.fill((int)25)).text(String.valueOf(setting.color().z)).id("z")).tooltip((Component)Component.literal((String)"RGB values for star color")).id("star_color"));
        return container;
    }

    public static CollapsibleContainer createLightSettings(Optional<LightSettings> settings) {
        CollapsibleContainer container = Containers.collapsible((Sizing)Sizing.content(), (Sizing)Sizing.content((int)0), (Component)Component.literal((String)"Light Settings (Optionnal)"), (boolean)settings.isPresent());
        if (settings.isEmpty() && container.expanded()) {
            container.toggleExpansion();
        }
        LightSettings setting = settings.orElseGet(LightSettings::createDefaultSettings);
        container.child(Components.checkbox((Component)Component.literal((String)"Force Bright Lightmap")).checked(setting.forceBrightLightmap()).id("forceBrightLightmap"));
        container.child(Components.checkbox((Component)Component.literal((String)"Constant Ambient Light")).checked(setting.constantAmbientLight()).id("constantAmbientLight"));
        return container;
    }

    public static TextBoxComponent textBox(Sizing horizontalSizing) {
        TextBoxComponent component = Components.textBox((Sizing)horizontalSizing);
        component.setMaxLength(600);
        return component;
    }

    public static TextBoxComponent textBox(Sizing horizontalSizing, String text) {
        TextBoxComponent textBox = SkiesComponents.textBox(horizontalSizing);
        textBox.text(text);
        return textBox;
    }
}

