/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SkyBoxSetting {
    public static Codec<SkyBoxSetting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("gradation").forGetter(b -> b.gradation), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(b -> b.texture), (App)SkyObject.VEC3F.fieldOf("rotation").forGetter(b -> b.rotation)).apply((Applicative)instance, SkyBoxSetting::new));
    public VertexBuffer sphere;
    public final int gradation;
    public final ResourceLocation texture;
    public final Vector3f rotation;

    public SkyBoxSetting(int gradation, ResourceLocation texture, Vector3f rotation) {
        this.gradation = gradation;
        this.texture = texture;
        this.rotation = rotation;
        this.sphere = this.createSphere();
    }

    public VertexBuffer createSphere() {
        float PI = (float)Math.PI;
        int gradation = this.gradation;
        Tesselator tesselator = Tesselator.getInstance();
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < gradation; ++i) {
            float alpha1 = (float)i * (float)Math.PI / (float)gradation;
            float alpha2 = (float)(i + 1) * (float)Math.PI / (float)gradation;
            for (int j = 0; j < gradation * 2; ++j) {
                float beta1 = (float)(j * 2) * (float)Math.PI / (float)(gradation * 2);
                float beta2 = (float)((j + 1) * 2) * (float)Math.PI / (float)(gradation * 2);
                float x1 = (float)(Math.sin(alpha1) * Math.cos(beta1));
                float y1 = (float)(Math.sin(alpha1) * Math.sin(beta1));
                float z1 = (float)Math.cos(alpha1);
                float x2 = (float)(Math.sin(alpha1) * Math.cos(beta2));
                float y2 = (float)(Math.sin(alpha1) * Math.sin(beta2));
                float z2 = (float)Math.cos(alpha1);
                float x3 = (float)(Math.sin(alpha2) * Math.cos(beta1));
                float y3 = (float)(Math.sin(alpha2) * Math.sin(beta1));
                float z3 = (float)Math.cos(alpha2);
                float x4 = (float)(Math.sin(alpha2) * Math.cos(beta2));
                float y4 = (float)(Math.sin(alpha2) * Math.sin(beta2));
                float z4 = (float)Math.cos(alpha2);
                float u1 = beta1 / ((float)Math.PI * 2);
                float v1 = alpha1 / (float)Math.PI;
                float u2 = beta2 / ((float)Math.PI * 2);
                float v2 = alpha1 / (float)Math.PI;
                float u3 = beta1 / ((float)Math.PI * 2);
                float v3 = alpha2 / (float)Math.PI;
                float u4 = beta2 / ((float)Math.PI * 2);
                float v4 = alpha2 / (float)Math.PI;
                bufferBuilder.addVertex(x1, y1, z1).setUv(u1, v1);
                bufferBuilder.addVertex(x2, y2, z2).setUv(u2, v2);
                bufferBuilder.addVertex(x3, y3, z3).setUv(u3, v3);
                bufferBuilder.addVertex(x3, y3, z3).setUv(u3, v3);
                bufferBuilder.addVertex(x2, y2, z2).setUv(u2, v2);
                bufferBuilder.addVertex(x4, y4, z4).setUv(u4, v4);
            }
        }
        vertexBuffer.bind();
        vertexBuffer.upload(bufferBuilder.buildOrThrow());
        VertexBuffer.unbind();
        return vertexBuffer;
    }

    public void renderSkyBox(PoseStack poseStack, Matrix4f projectionMatrix, Camera camera) {
        poseStack.pushPose();
        FogRenderer.setupNoFog();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f viewMatrix = new Matrix4f();
        camera.rotation().get(viewMatrix);
        viewMatrix.invert();
        Matrix4f modelMatrix = new Matrix4f().identity().scale(Minecraft.getInstance().gameRenderer.getRenderDistance());
        modelMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(this.rotation.x)).rotate((Quaternionfc)Axis.YP.rotationDegrees(this.rotation.y)).rotate((Quaternionfc)Axis.ZP.rotationDegrees(this.rotation.z));
        Matrix4f mvMatrix = new Matrix4f((Matrix4fc)viewMatrix).mul((Matrix4fc)modelMatrix);
        this.sphere.bind();
        this.sphere.drawWithShader(mvMatrix, projectionMatrix, GameRenderer.getPositionTexShader());
        VertexBuffer.unbind();
        RenderSystem.enableDepthTest();
        poseStack.popPose();
    }

    public static SkyBoxSetting createDefaultSettings() {
        return new SkyBoxSetting(100, ResourceLocation.parse((String)"sky_aesthetics:textures/skyboxes/venus.png"), new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

